@Style<Justification On, Hyphenation On, WidestBlank 1.4, Spacing 1,
        Spread 1, Indent 0, HyphenBreak Off, SingleSided>
@Use<Hyphendic="KER:KUSER.HYP">
@Modify<Quotation,Indentation 0, Above 1, Below 1, Spacing 1>
@Modify<Example, Above 1, Below 1, Blanklines Hinge>
@Modify<Verbatim, Leftmargin 0>
@Modify<Itemize, Above 1, Below 1, Spacing 1, Spread 1>
@Modify<Enumerate, Above 1, Below 1, Spacing 1, Spread 1>
@Modify<Description, Above 1, Below 1, Spacing 1>
@Define<Q,FaceCode R>
@Define<QQ,FaceCode R,AfterEntry=["],BeforeExit=["]>
@Define<SubH,Use Display,FaceCode R,Above 1.6,Below 1>
@Case<Device,
 Imagen300="@Use(AuxFile='KERIMP.AUX')
    @Define<Q,FaceCode U>
    @Define(QQ,FaceCode U,AfterEntry=[@r<``>],BeforeExit=[@r<''>])
    @Define<SubH,Use Display,FaceCode B,Above 1.6,Below 1>
    @Modify<Insert,Spacing 1>
    @Modify<Verbatim,FaceCode U>
    @Modify<Example,FaceCode U,spacing 1.2>
    @Modify<Itemize,Spread 0.8>
    @Style<FontFamily SmallRoman12,Spacing 1.6,SingleSided>",
 X9700="@Use<AuxFile='KERMX9.AUX'>
    @Style<FontFamily Univers10, DoubleSided, Spacing 0.9, Spread 0.8>
    @Style<Scriptpush No>
    @Define<Q,FaceCode U>
    @Define(QQ,FaceCode U,AfterEntry=[@r<``>],BeforeExit=[@r<''>])
    @Define<SubH,Use Display,FaceCode B,Above 1.6,Below 1>
    @Modify<Description,Spacing 0.8,Spread 0.75> 
    @Modify<Quotation,Spacing 0.8,Spread 0.75> 
    @Modify<Enumerate,Spacing 0.8,Spread 0.75> 
    @Modify(Verbatim,Spacing 0.8,Spread 0.75,FaceCode U)
    @Modify<Example,FaceCode U, Spacing 1.1>
    @Modify[Itemize, Numbered < @,- >, Spacing 0.8, Spread 0.5]"
 >
@PageHeading(Even,Left="Page @ref(page)",
Right="@b<MS-DOS Kermit, Specification for System-Dependent Modules>")
@PageHeading(Odd,Right="Page @ref(page)",
Left="@b<MS-DOS Kermit, Specification for System-Dependent Modules>")

@heading(Specification for MS-DOS Kermit System-Dependent Modules)

@center(@i<by Jeff Damens, Columbia University>)

@begin<quotation,use i>
This document applies to Verson 2.28 of MS-DOS Kermit, and it has some
updates at the end for Version 2.29.  It has not been updated for version
2.30.
@end<quotation>

All the system-@|independent global data structures used in Kermit-MS are
defined in the file @q<MSDEFS.H>.

The routine @q(MSX@i<xxx>.ASM) contains system-@|dependent support for
system @i<xxx>, except for terminal emulation, which is in
@q(MSY@i<xxx>.ASM), described below.

The routines in the MSX module may change any registers but
the stack pointer and segment registers, unless otherwise noted.  A
routine that returns via a RET instruction is said to return normally;
a routine that skip returns is one that returns to three bytes past
the normal return address.

Global variables that must be defined in the system-dependent module:

@begin(description)
XOFSNT@\byte.  This should be set to a non-zero value if we are doing
flow control and have sent an XOFF character to the remote host, zero
otherwise.

MACHNAM@\byte.  A $-terminated string identifying the machine
this version of Kermit is for; it is printed when Kermit
starts up.

SETKTAB@\byte.  A keyword table associating terminal key names to
16-bit scan code values, used in the set key command.  If the
kermit version can accept arbitrary decimal values as scan
codes, the word "SCAN" should appear in the table with a scan
value of -1.  If key redefinition is not implemented, the
first byte of the table should be a zero.

SETKHLP@\byte.  A $-terminated string to be printed when ? is typed in
the SET KEY command.  This is usually simply a list of the key
names in SETKTAB.  SETKHLP must be defined even if key
redefinition is not implemented, to satisfy the linker; if key
redefinition is not implemented, SETKHLP will never be
displayed.

COUNT@\word.  The number of characters in the serial input buffer, if
known.  This is how Kermit knows to send an XON if the serial
handler has sent an XOFF.  If the number of characters in the
buffer isn't known, COUNT should be 0.
@end(description)


These are the required entry points for the system dependent dependent
module @q(MSX@i<xxx>.ASM).
@begin(description,group,spread 0.5)
SERINI

Parameters@\None.

Returns@\Normally, no return value.

Description@\Perform any initialization that must be done before the
	serial port can be used, including setting baud rate,
	interrupt vectors, etc.  Parity and baud rate should be set
	according to the values in the PORTINFO structure.  The external
	variable PORTVAL points to the PORTINFO structure for the
	current port.  Calling SERINI more than	once without an
	intervening call to SERRST should have no effect. 
@end(description)
@begin(description,group,spread 0.5,above 2)
SERRST

Parameters@\None.

Returns@\Normally, no return value.

Description@\Undoes any initialization done by SERINI, including
	resetting the serial port, restoring any interrupt vectors
	changed by SERINI, etc.  Calling this more than once without
	an intervening call to SERINI should be harmless.
@end(description)
@begin(description,group,spread 0.5,above 2)
CLRBUF

Parameters@\None.

Returns@\Normally, no return value.

Description@\Remove and discard from the serial port's input buffer any
	characters sent by the remote host that have not yet been read
	by Kermit, and set COUNT to 0.  This is used before a file
	transfer to flush NAK's that accumulate in the buffer when the
	remote host is in server mode.
@end(description)
@begin(description,group,spread 0.5,above 2)
OUTCHR

Parameters@\A character in AH.

Returns@\Skip returns if the character has been transmitted; returns
	normally if the character can not be transmitted because of a
	hardware error.

Description@\Sends the character in AH out the currently selected serial
	port.  OUTCHR can assume that SERINI will have been called
	previously. OUTCHR should call the external routine DOPAR to set
	the parity of the character if the communications hardware
	doesn't automatically set parity.  Flow control should be
	honored; the external variable PORTVAL contains a pointer to a
	PORTINFO structure (as defined in @q(MSDEFS.H)) containing the
	current flow control definitions.
@end(description)
@begin(description,group,spread 0.5,above 2)
COMS

Parameters@\None.

Returns@\Normally if a parse error is encountered, skip returns otherwise.

Description@\Called by the SET PORT command.  On a machine with
	multiple serial ports, COMS should parse for the name or
	number of a serial port and make that the port used by
	succeeding calls to SERINI, PRTCHR, OUTCHR, and SERRST.  It
	should set the external variable PORTVAL to point to one of the
	external port structures PORT1 or PORT2, and set COMFLG in the
	FLAGS structure to 1 for port one, 0 for port 2.  For
	implementations that use only one serial port, COMS should print
	a message to that effect and skip return.
@end(description)
@begin(description,group,spread 0.5,above 2)
VTS

Parameters@\None.

Returns@\Normally if a parse error is encountered, skip returns otherwise.

Description@\Parses for an ON or OFF, sets HEATH-19 emulation while in
	terminal emulation appropriately.  The VTFLG field of the FLAGS
	structure should be set non-zero if HEATH-29 emulation is on,
	zero otherwise.  If HEATH-19 emulation is not done, VTS should
	print a message and skip return.
@end(description)
@begin(description,group,spread 0.5,above 2)
DODEL

Parameters@\None.

Returns@\Normally, no return value.

Description@\Erases the character immediately to the left of the
	cursor from the screen, then backs up the cursor.
@end(description)
@begin(description,group,spread 0.5,above 2)
CTLU

Parameters@\None.

Returns@\Normally, no return value.

Description@\Move the cursor to the left margin, then clear the line.
@end(description)
@begin(description,group,spread 0.5,above 2)
CMBLNK

Parameters@\None.

Returns@\Normally, no return value.

Description@\Clears the screen and homes the cursor.
@end(description)
@begin(description,group,spread 0.5,above 2)
LOCATE

Parameters@\None.

Returns@\Normally, no return value.

Description@\Homes the cursor.
@end(description)
@begin(description,group,spread 0.5,above 2)
LCLINI

Parameters@\None.

Returns@\Normally, no return value.

Description@\Performs any system-dependent initialization required by
	this implementation.
@end(description)
@begin(description,group,spread 0.5,above 2)
PRTCHR

Parameters@\None.

Returns@\Normally, with the next character from the currently selected
	serial port in AL.  Skip returns if no character is available.

Description@\Reads the next character from the current serial port.
	PRTCHR can assume SERINI has been called previously, and
	should handle flow control correctly.
@end(description)
@begin(description,group,spread 0.5,above 2)
DOBAUD

Parameters@\None.

Returns@\Normally, no return value.

Description@\Sets the baud rate for the current port.  The baud rate
	should be obtained from the BAUD field of the PORTINFO
	structure, pointed to by the external variable PORTVAL.
@end(description)
@begin(description,group,spread 0.5,above 2)
CLEARL

Parameters@\None.

Returns@\Normally, no return value.

Description@\Clears from the cursor to the end of the current line.
@end(description)
@begin(description,group,spread 0.5,above 2)
DODISK

Parameters@\None.

Returns@\Normally, no return value.

Description@\Sets the external variable DRIVES to the number of disk drives
	attached to the machine.
@end(description)
@begin(description,group,spread 0.5,above 2)
GETBAUD

Parameters@\None.

Returns@\Normally, no return value.

Description@\Store current baud rate of the currently selected port in
	the BAUD field of the current PORTINFO structure, which is
	pointed to by PORTVAL.  If the baud rate is to default to a
	particular value, this routine can store that value into the
	BAUD field instead. 
@end(description)
@begin(description,group,spread 0.5,above 2)
BEEP

Parameters@\None.

Returns@\Normally, no return value.

Description@\Rings the terminal bell.
@end(description)
@begin(description,group,spread 0.5,above 2)
PUTHLP

Parameters@\A pointer to a string in AX.

Returns@\Normally, no return value.

Description@\Writes the null-terminated string given in AX to the
	terminal.  This is used to display help and status messages.
	The IBM and Rainbow versions write the string in a reverse
	video box.
@end(description)
@begin(description,group,spread 0.5,above 2)
PUTMOD

Parameters@\A pointer to a string in AX.

Returns@\Normally, no return value.

Description@\Writes the null-terminated string given in AX to the last
	line of the screen, in inverse video if possible.
@end(description)
@begin(description,group,spread 0.5,above 2)
CLRMOD

Parameters@\None.

Returns@\Normally, no return value.

Description@\Clears the line written by PUTMOD.
@end(description)
@begin(description,group,spread 0.5,above 2)
POSCUR

Parameters@\Row in DH, column in DL.

Returns@\Normally, no return value.

Description@\Positions the cursor to the row and column given in DX.
	Rows and columns both originate at 0 (not 1!).
@end(description)
@begin(description,group,spread 0.5,above 2)
SENDBR

Parameters@\None.

Returns@\Normally, no return value.

Description@\Send a break to the current serial port.
@end(description)
@begin(description,group,spread 0.5,above 2)
SHOWKEY

Parameters@\Pointer to a terminal argument block in AX (see TERM below).

Returns@\Normally, with a string pointer in AX and the length of the
	string in CX.

Description@\Called by the SHOW KEY command.  Reads a key from the
	terminal and returns a string containing
	implementation-dependent information about the key. In the
	usual case, the string contains the key's (machine-dependent)
	scan code, and the key's definition (if any) from the terminal
	argument block.  The length of the returned string should be
	returned in CX.  The string may contain any characters;
	unprintable characters will be quoted when the string is
	printed.  If the implementation does not support key
	redefinition, SHOWKEY may return a static string saying so.
@end(description)
@begin(description,group,spread 0.5,above 2)
TERM

Parameters@\Pointer to terminal argument block in AX.

Returns@\Normally, no return value.

Description@\Do terminal emulation, based on argument block described
	below...
@end(description)

The following entry points were added for version 2.29 by Joe R. Doupnik
of Utah State University (May 1986):
@begin(description,group,spread 0.5,above 2)
DTRLOW

Parameters@\None.

Returns@\Return-skip normally or just Return if command not confirmed.

Description@\Parses HANGUP command and calls local procedure SERHNG to lower
modem control lines DTR and RTS.  Most MS Kermits have not implemented SERHNG;
a "not implemented" message results in these cases.
@end<description>
@begin(description,group,spread 0.5,above 2)
DUMPSCR

Parameters@\None.

Returns@\Normally.

Description@\Copies text from the screen to a file. Word DMPNAME holds
the address (offset in data segment) of a zero terminated
string of the filename or device; the default string is
@q<KERMIT.SCN>; MSSSET stores this string. Method of copying
is to capture the screen to a buffer and read out the
text to a file, with lines trimmed of trailing blanks and
terminated by CR/LF. A Form Feed ends the file. The filename
is checked for collision with system, readonly, subdirectory
types etc and a complaint message is displayed if such
a collision occurs.  The file is opened and closed for each
screen dump operation.  Current implementations are on IBM
and Rainbow machines, and they append new material to a
pre-existing file. On other systems a simple Return is done.
@end<description>
@begin(description,group,spread 0.5,above 2)
IHOSTR

Parameters@\None.

Returns@\Normally.

Description@\Initializes the remote host for our reception of a file by
sending the flow-on character (XON normally) to release any
held data. Called by receive-file code just after initing
the serial port.
@end<description>
@begin(description,group,spread 0.5,above 2)
IHOSTS

Parameters@\None.

Returns@\Normally.

Description@\Initializes the host for our sending of a file by sending the
flow-on character (XON normally) to release any held data, such as NAKs,
flushes the serial port input buffer, waits one second (by calling SLEEP), and
exits if the buffer is empty.  Otherwise, the cycle of clear buffer, sleep one
second, check buffer is repeated. Called by send-file routine just after
initializing the serial port.
@end<description>
@begin(description,group,spread 0.5,above 2)
VTS

Parameters@\None.

Returns@\Skip-return normally or just Return if parser error.

@begin<multiple>
Description@\Parses SET TERM commands. The IBM version has many keywords
which are further parsed and cause jumps to action routines
within this procedure. Non-IBM Kermits usually parse the
keywords ON and OFF, for Heath-19 emulation or not. Common
to all MS Kermits is the setting of global byte @q<FLAGS.VTFLG>
indicating the terminal emulation type (types are defined
in the header file @q<MSSDEF.H>). For the VT102 emulator in the
IBM Kermit VTS also writes into structure VTEMU to pass
information to the emulator about colors, tabstops, line-wrap,
and other Set Term parameters and controls global byte REFRESH
passed to module MSYIBM to govern screen refresh methodology.
Small local parsing support procedures are included here.

Structure VTEMU is defined in header file @Q<MSSDEF.H> and contains the
following fields:
@end<multiple>
@begin(description,group,spread 0.5,above 2)
VTFLGST@\Byte. Holds VT102 setup flag bits, which when set mean -
@begin<multiple>
@begin<description,leftmargin +4,indent -4>
VSNEWLINE (01H)@\ANSI Newline mode active

VSWRAP (02H)@\Line wrap is active

VSSHIFT3 (04H)@\Sharp sign (#) replaced by Pound Sterling

VSKEYCLICK (08)@\Keyclick on

VSMARGINBELL (10H)@\Sound bell when cursor passes column 72

VSCURSOR (20H)@\Cursor is a block (vs underline)

VSSCREEN (40H)@\Screen is to be reverse video
@end<description>
A constant VSDEFAULTS is defined in the header file as the OR of bits above
which is used by the emulator at Kermit startup time in lieu of Set Term.
@end<multiple>

VTTBS@\Word. Holds address (offset in data segment) to default
tabstop byte array. This array is located in file MSZIBM.

VTTBST@\Word. Holds address (offset in data segment) to active
tabstop byte array. This array is located in file MSZIBM.

ATT_PTR@\Word. Pointer (offest in data segment) to video attributes
byte pair (which is stored in file MSZIBM).
@end<description>
Further, global byte FLAGS.VTFLG holds the kind of terminal being emulated.
Kinds are defined in the header file as constants:
@begin<example>
TTGENERIC       0       @r<no emulation>
TTHEATH         1       @r<Heath-19>
TTVT52          2       @r<VT52 submode of VT102>
TTVT102         3       @r<VT102>
TTTYPES         4       @r<number of types defined above.>
@end<example>
@end<description>

@begin(description,group,spread 0.5,above 2)
VTSTAT

Parameters@\Enter with register DI pointing to status buffer STTBUF.

Returns@\Register CX counting the right most column used in status
display and register DI 40 bytes larger that at entry.
Uses normal Return, not Skip-return.

Description@\Displays Status information about terminal emulator. Called
by procedure STAT0 in file MSSSET. This procedure is similar
to normal Status ones except the data items are from
structure VTEMU. Command macros for VTSTAT are defined in file
MSXxxx. VTSTAT writes the status information directly to the
screen and returns to STAT0 with character in line pointer
register DI set 40 bytes larger than when entered (even though
several lines may have been displayed) and register CX holding
the number of chars shown on the last line. Non-IBM Kermits
just do a simple Return. Normally VTSTAT is the last Status
item called by STAT0.
@end<description>
Terminal emulation is supplied in the system dependent files @q<MSX>@i<xxx>,
@q<MSY>@i<xxx>, and possibly @q<MSZ>@i<xxx>, depending on the machine. The
terminal "argument block" passed to procedure TERM is listed below; but note
that the VT102 emulator for IBM machines uses an additional global structure
VTEMU.  The terminal argument block passed to the terminal emulator has the
following fields:
@begin(description)
FLGS@\Byte containing flags.  Flags are:

@begin(description)
  SCRSAM (80H)@\If on, the terminal emulator shouldn't re-display the
		 screen when entered.

  CAPT (40H)@\Capture output.  If on, the routine passed in field CAPTR
		is called with each character sent to the screen.

  EMHEATH (20H)@\On if terminal emulation is active.  Obsolete.
The preferred method is to examine byte
FLAGS.VTFLG for the terminal type.

  HAVTT (10H)@\A key redefinition table is present.

  TRNCTL (08H)@\Print control character X as ^X (useful for debugging).

  MODOFF (04H)@\Do not display emulator mode line if on.

  LCLECHO (01H)@\Echo keyboard characters on the screen in addition to
		  sending them to the port.
@end(description)

PRT@\Port to use for terminal emulation, used only in mode line.  This
	is just a copy of COMFLG in FLAGS.

COLS@\Number of columns on screen.

ROWS@\Number of rows on screen.

CAPTR@\Routine to call to with each character sent to the screen if
	CAPT flag is on.  Characters are passed in AL.

BELLD@\Bell divisor (used only on IBM).

KLEN@\Number of keys in key redefinition table, if HAVTT flag is on.

KTAB@\Address of key redefinition table.  The key redefinition table is
	a table of KLEN 16-bit scan codes.  Each (machine dependent)
	scan code represents a key that is redefined.

KRPL@\Address of key replacement table.  The key replacement table
	parallels the key redefinition table given in KTAB.  Entries in
	the replacement table are 16-bit pointers to redefinitions.
	Each redefinition has a one-byte length, followed by the definition.

ESCC@\Escape character (single byte).  When this character is typed to
	the emulator, it should return.

BAUDB@\byte.  Bits describing the baud rate so it can be printed on the
	mode line.  This is a copy of the BAUD field in the PORTINFO
	structure.  Currently used only on the IBM.  See @q(MSDEFS.H) for
	possible values.

PARITY@\byte.  Current parity to print on the mode line.  This is a
	copy of PARFLG in the PORTINFO structure.  Currently used only
	on the IBM.  See @q(MSDEFS.H) for possible values. 
@end(description)
