@Part(CMSKERMIT,root="KER:KUSER")
@string(-cmsversion="4.0")
@string(-cmsdate="87/12/17")
@Chapter<IBM VM/CMS KERMIT>
@Begin<Description,Leftmargin +14,Indent -14,spread 0>
@i(Program:)@\John Chandler (Harvard/Smithsonian Center for
Astrophysics); contributions from
Vace Kundakci and
Daphne Tzoar (Columbia U),
Bob Shields (U. Maryland), Victor Lee (Queens U.), Gary Bjerke (U.
Texas at Austin), Greg Small (UC Berkeley), Clark Frazier (Harvard
Bus. Sch.), Bob Bolch and Steve Blankinship (Triangle), Ron Rusnak
(U. Chicago), Andre Pirard (U. Liege)

@i(Language:)@\IBM/370 Assembler

@i(Documentation:)@\John Chandler (CfA)

@i(Version:)@\@value(-cmsversion) (@value<-cmsdate>)

@i(Date: )@\1987 December
@end<Description>

@subheading<Kermit-CMS Capabilities At A Glance:>
@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\No
Remote operation:@\Yes
Transfers text files:@\Yes
Transfers binary files:@\Yes
Wildcard send:@\Yes
@q(^X/^Z) interruption:@\Yes (through micro)
Filename collision avoidance:@\Yes
Can time out:@\No
8th-bit prefixing:@\Yes
Repeat count prefixing:@\Yes
Alternate block checks:@\Yes
Terminal emulation:@\No
Communication settings:@\No
Transmit BREAK:@\No
Transaction logging:@\Yes
Session logging:@\No
Raw transmit:@\Yes (no prompts)
Sliding window:@\No
Long packets:@\Yes
Act as server:@\Yes
Talk to server:@\Yes
Advanced server functions:@\Yes
Advanced commands for servers:@\Yes
Local file management:@\Yes
Handle Attribute Packets:@\Yes
Command/init files:@\Yes
Command macros:@\No
@end<format>

@Index(IBM)
@Index(VM/CMS)@Index(TTY)@Index(Series/1)
Kermit-CMS is a member of the generic Kermit-370 family and shares most
of the features and capabilities of the group.
As its name implies, Kermit-CMS is the
version of Kermit-370 that runs under the VM/CMS operating system.
The primary documentation for Kermit-CMS is actually
the chapter on Kermit-370, which
describes general properties; the present chapter assumes the
reader is familiar with that material.  Only the details specific to
CMS operation will be discussed here, e.g., command syntax
relating to the CMS file system or commands not offered in general
by Kermit-370.

@subheading<CMS Specifics of Kermit-370:>
@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(3.5inches,4.0inches)
Global INIT file:@\@q(SYSTEM KERMINI *)
User INIT file:@\@q(<userid> KERMINI *)
Debug packet log:@\@q(KER LOG A1)
Server reply log:@\@q(KER REPLY A1)
Maximum packet size:@\1920
Maximum disk LRECL:@\65535
@end<format>

@Section<The VM/CMS File System>

The features of the CMS file system of greatest interest to Kermit
users are the format of file specifications (or @i<filespecs>)
and the concept of
records.  The latter is described in the Kermit-370 chapter.

The VM/CMS @i<filespec> takes the form
@example<filename filetype filemode>
(often abbreviated FN FT FM).  The filename and filetype are one to eight
characters each.  The name field is the primary identifier
for the file, and the type is an indicator which, by convention, tells
what kind of file it is.  For instance, @q<TEST FORTRAN> is the
source of a Fortran program named TEST.  @q(MODULE) is the
filetype for executable programs (as distinct from object code, which
has a filetype of @q<TEXT>!).  Although some operating systems
consider the filetype optional, VM/CMS requires a type for each file.
Therefore, Kermit-CMS supplies a default type of @qq($) for any
received file if no type is
provided by the remote system.  The same default is used for
a missing filename.  At the same time, the FN and FT are forced to
conform to CMS rules in other respects.
The FN and FT may contain, in any order, uppercase letters, digits, and
the special characters @qq<$> (dollar sign), @qq<#> (pound sign),
@qq<@@> (at sign), @qq<+> (plus), @qq<-> (hyphen), @qq<:> (colon), and
@qq<_> (underscore).  Other characters may be not be included.  If an
invalid character is found in the FN or FT field, it is replaced by
an underscore (or converted to uppercase if it is a lowercase letter).
Also, both FN and FT are truncated, if necessary, to eight characters.

@Index(Home disk)
The filemode, which consists of a letter and a number, is similar
to a device specification on microcomputer systems: @w<@q(FN FT FM)>
would translate to @q<FM:FN.FT> in CP/M or MS-DOS if the filemode
number is ignored.  Indeed, the filemode number is more properly an
attribute of a file than part of its name -- no two files can
co-exist with names that match all but the filemode number.  Even the
filemode letter is not a fixed part of the @i(filespec) because the
same mini-disk could be accessed under a different mode letter.
In some ways, the filemode letter is also like
a disk directory designator, since many such mini-disks may reside
on the same disk drive.  For this reason, the Kermit
concept of the "working
directory" is equated with a particular disk mode letter under
Kermit-CMS.  The current "working directory" is, thus, the
"home" filemode (normally @qq<A>, which is the primary
user mini-disk under CMS), and file transfers take place preferentially
to and from the "home" disk.
If the filemode is
omitted from a @i(filespec) when sending, the "home" disk
is normally used, but there is an option for using a default of
@qq(*) instead.
In this case, the user's disks are scanned according to the search
order and the first occurrence of the file is the one that is sent.
If the filemode is omitted from a
@i(filespec) when receiving, the "home"
disk is used with a filemode number of @qq(1).

To provide compatibility with other operating systems, when Kermit-CMS
sends a file, it ordinarily makes a file header with
only the filename and filetype.  It also converts the
intervening blank to a period.  On the other hand, extra information
may be added by way of the SET FOREIGN subcommand.

@Index<Wildcard>
VM/CMS allows a group of files to be specified in a single
@i(filespec) by including the special
"wildcard" characters @qq<*>
and @qq<%>.  A @qq<*> matches any string of characters (even a null
string) from the
current position to the end of the field;
a @qq<%> matches any single character.  Here are some examples:

@Begin(Description,spread 0.5,leftmargin +12, indent -10)
@q<* COBOL A>@\All files of type @q<COBOL> (all COBOL source files) on
the A disk.

@q<F* * *>@\All files whose names start with F.

@q<% * B>@\All B-disk files with one-character FN's.
@End(Description)

CMS files, like those in other IBM 370 systems, are record-oriented
(see the introduction to the Kermit-370 chapter).
In particular, CMS files are characterized by record
format (RECFM), which may be fixed-length or varying-length,
and by maximum record
length (LRECL).  The size of record blocks is irrelevant, however,
because CMS performs the blocking and deblocking operations
automatically and transparently, including the spanning of records
across block boundaries.  Records in CMS files may be up to 65535 bytes
long.

@section<Program Operation>

@Index(Initialization files)
At startup time, Kermit-CMS looks for two initialization
files, @q(SYSTEM KERMINI) and @i(<userid>) @q(KERMINI)
(where @i(<userid>) is the user's
logon ID).  If either of these files exists on more than one disk,
it will be read and executed from the first copy in the search order.
The file @q(SYSTEM KERMINI) should be placed on a
publicly accessible disk by a systems programmer, preferably the
same disk where the Kermit executable module is kept.
The file @i(<userid>) @q(KERMINI) can be maintained by the user on any
convenient disk.

One important distinction between Kermit-CMS and other Kermits is that
a program running under VM/CMS is unable to interrupt a read on
its "console".  This means that the CMS version of Kermit cannot
time out after sending a packet.  The only way to
time out is from the other side:
typing a carriage return to the local Kermit causing it to retransmit
its last packet, or an automatic timeout as provided by most other
Kermits.

Five CP SET parameters (MSG, IMSG, WNG, ACNT, and TIMER)
are set OFF during protocol mode
(and restored afterwards) to prevent CP from
interrupting any I/O in progress, and RUN is set ON to
ensure that Kermit can recover from accidental attention interrupts.
Also, on a TTY line, the TERMINAL LINESIZE is set OFF
to prevent CP from inserting
carriage return-linefeed pairs into packets, TERMINAL SCROLL is set to
CONT to prevent CP pauses, LINEDIT is set OFF to ensure that all
characters are taken literally, and the
CMS user terminal translation tables (established via the CMS SET INPUT
and OUTPUT commands) are temporarily suppressed for both short and long
packet protocols.@Index(Long packets)
The settings in effect when Kermit starts up are saved as a sort of
"normal" status snapshot (as opposed to the "protocol" status just
described).  The protocol status is selected whenever
Kermit enters protocol mode and also after Kermit executes a CP command
in server mode.  Similarly, normal status is selected when Kermit
leaves protocol mode and before Kermit executes a CP command in server
mode.
Note: if Kermit is
interrupted in the midst of a transfer or while in server mode, these
parameters will be left with peculiar settings (namely, the protocol
status), and they may need
to be restored by hand.

@Index(TTY)@Index(Flow control)@Index(Handshake)
CMS is different from some other IBM mainframe systems in that allows
a program to
take control of prompting and synchronization on @qq(TTY) lines.
Kermit-CMS takes advantage of this option, and
it is not, in general, necessary to enable handshaking
on the micro Kermit before
connecting to CMS.  In other words, handshaking
should be suppressed for both @qq(TTY) and @qq(SERIES1) devices
(the micro Kermit should have
HANDSHAKE set OFF, and Kermit-CMS should have HANDSHAKE set to 0).
Since the generic Kermit-370 default handshake (XON) is retained in
Kermit-CMS, the subcommand @qq(SET HANDSHAKE 0) is a good candidate
for inclusion in @q(SYSTEM KERMINI).

@subheading(Interactive Operation:)

To run Kermit-CMS interactively, invoke the program from CMS by
typing @q<KERMIT>.  When you see the prompt,
@example(Kermit-CMS>)
you may type a Kermit subcommand.  The cycle repeats until you
exit from the program.  For example:
@Begin(Example)
@ux(KERMIT)

Kermit-CMS Version @value(-cmsversion) (@value<-cmsdate>)
Enter ? for a list of valid commands

Kermit-CMS>@ux(send foo *)

  @i(Files with fn FOO are sent)

Kermit-CMS>@ux(receive test spss)

  @i(File is received and called TEST SPSS A1)

Kermit-CMS>@ux(exit)
@end(example)

The prompt string under CMS is truly interactive.  In other words, the
string (without carriage return or linefeed) appears only when fresh
input is needed from the terminal.  If, for example, Kermit is invoked
after several subcommands have been stacked up, the stack is read and
executed before the first prompt appears.

@subheading(Command Line Invocation:)

Kermit-CMS may also be invoked with command line arguments from CMS.
The arguments are interpreted as one or more subcommands to be executed
by Kermit after completion of the initialization.
For instance:
@Begin(Example,below 0.5)
@ux(KERMIT send test fortran)
@End(Example)
or
@Begin(Example,above 0.5)
@ux(KERMIT set debug on # set file binary # server)
@End(Example)

Kermit will exit and return to CMS after completing the specified
subcommand or subcommands.  Note that several commands may be given on
the command line as long as they are separated by the LINEND character,
which is pound sign in this case.  The command line may contain up to
130 characters.

@subheading(EXEC Operation:)

@Index(Batch operation)
Like other CMS programs, Kermit-CMS may be invoked from a CMS EXEC.
Subcommands can be passed to Kermit using the program stack
and/or command line arguments.  For example, to start up Kermit-CMS
and have it act as a server, include the line:
@Begin(Example)
@ux(KERMIT server)
@End(Example)
To pass more than one subcommand, they must be stacked in the order in
which they are to be executed.  To start up a Kermit-CMS server with a
three character CRC, include:
@Begin(Example)
@ux(&STACK set block 3)
@ux(&STACK server)
@ux(KERMIT)
@End(Example)
Another way of setting up multiple subcommands would be to collect the
subcommands into a TAKE file and then issue the TAKE subcommand via the
command line or program stack.
Of course, EXEC's may be executed from Kermit, either directly or from a
TAKE file, and Kermit subcommands, in turn, may be issued from EXEC's as
long as Kermit is active.  See the TAKE subcommand for more details.

@subheading(Server mode:)

Command execution in server mode is different in several respects
from normal operation.  First of all, some Kermit subcommands
are not allowed (see the list of subcommands in the Kermit-370 chapter).
Moreover, command errors
always terminate any active TAKE file.
Also, commands other than CP commands run in a
special environment with RUN ON, TIMER OFF, and so forth.
Another difference is that Kermit intercepts all SVC instructions
in order to catch console I/O and transmit the data to the local
Kermit as text packets.  Since Kermit does not emulate the substitution
functions of the LINEDIT macro, some messages will appear rather
cryptic.  A more serious problem with this redirection is that
some VM/CMS system commands may issue console I/O directly to CP, so
that some messages never appear to the local Kermit (except, perhaps,
as bad packets).  For non-TTY terminals, such messages are stacked up
in the console output queue and appear all at once when Kermit
returns from server mode.

@Section<Kermit-CMS Subcommands>

Kermit-CMS supports all the subcommands
described in the corresponding section
of the Kermit-370 chapter.  In addition, there are two more, both of
which can be issued as remote Kermit commands when Kermit-CMS
is in server mode.  The first is @q(CMS), which is just a synonym for
the generic HOST subcommand.  The second is @q(CP), which specifically
issues a command to CP.  In most circumstances, the latter is not needed,
since CMS will pass along CP commands to CP.

The remainder of this section concentrates on
the subcommands that have special form or meaning for Kermit-CMS.
See also the chapter on Kermit-370 for further details.

@Heading<The SEND Subcommand>
@Index(SEND)

Syntax: @q<SEND> @i(filespec) [@i(foreign-filespec)]

The SEND subcommand causes a file or file group to be sent from CMS
to the Kermit on the other system.  @i(filespec) takes the
form:
@example(filename filetype [filemode])
but the filemode if optional only if the @i(foreign-filespec) is omitted.

@Index(File matching)
@Index(Search order)
@i(filespec) may contain the wildcard characters @qq<*> or @qq<%>.  If
@i(filespec) contains wildcard characters then all matching files will
be sent.  If, however, a file exists by the same name on more than one
disk, only the first one Kermit-CMS encounters, according to the disk
search order, is sent.  See also the CWD subcommand.

The @i(foreign-filespec), if any, is used for the file header of the
outgoing file, replacing the usual filename.filetype copied from the
CMS @i(filespec).  It may take one of two forms:
@example(filename filetype)
or
@example(arbitrary-string)
Normally, this form of the SEND subcommand is used only for single files
because the @i(foreign-filespec) is used only for the first file of a
group (subsequent files having default headers).  However, in the
two-token form of the @i(foreign-filespec) either the name or type may
be an Equals sign @qq(=) to signify that the corresponding CMS name
or type is to be retained in the file header.  In that case, the
partial renaming carries through an entire group of files.  It is
the user's responsibility to prevent such partial renaming from
sending duplicate file headers within a file group.

@Index<Cancelling a file transfer>
Although the file transfer cannot be cancelled from the CMS side,
Kermit-CMS is capable of responding to
"cancel file" or "cancel batch"
signals from the local Kermit;  these are typically entered by typing
Control-X or Control-Z, respectively.

@Heading<The RECEIVE Subcommand>

@Index(RECEIVE)
Syntax: @q<RECEIVE> [@i(filespec)]

The RECEIVE subcommand tells Kermit to receive a file or file group
from the other system.  You should then issue a SEND subcommand to the
other Kermit.

The format of @i(filespec) is:
@example<filename filetype [filemode]>

If the optional @i(filespec) is not included, Kermit-CMS will use the
name(s) provided by the other Kermit.  If that name is not a legal
CMS file name, Kermit-CMS will delete excess characters
and will change illegal characters to underscores.
A @i(filespec) in the subcommand indicates what name the incoming file
should be given.  The @i(filespec) may include a
filemode to designate the destination disk.  If none is provided,
the file will be saved on the "home" disk with filemode number
@qq(1).  If you want to use the same name
but a different filemode, specify @w(@qq<= = FM>).  Wildcards may not
be used.

If the optional @i(filespec) is provided,
but more than one file arrives, the
first file will be stored under
the given @i(filespec), and the remainder will be stored under
their own names on the "home" disk.  If, however, @qq<= = FM>
is used, all files will be placed onto the specified disk.

@Index(Binary files)
When the record format is fixed, any received record
longer than the logical record length (LRECL) will be truncated,
and shorter records will be padded.  The padding character is a blank
for text files and a null for binary files.
Received binary (but not V-binary or D-binary) files are treated as
byte streams and broken up into records all of the logical record
length.
See the SET FILE TYPE, SET FILE LRECL, and
SET FILE RECFM subcommands.

@Index<Incomplete file>
If an error occurs during the file transfer, as much of the file as
was received is saved on disk.  If the sending of a file is
cancelled by the user of the foreign system, Kermit-CMS will discard
whatever had arrived, unless APPEND is ON or INCOMPLETE is KEEP.

If the incoming file has the same name as an existing file,
and WARNING is OFF, the original file will be overwritten.
If WARNING is set ON, however, Kermit-CMS will change the incoming name
so as not to obliterate the pre-@|existing file.  It attempts to find
a unique name by successively modifying the original and checking for
the existence of such a file at each step.  The procedure begins by
truncating the filetype to six characters if necessary, and then
appending @qq($0).  If a file by that name exists,
Kermit then replaces the @qq(0) with a @qq(1).
It continues in this manner up to @qq(9), and if an unused name cannot
be found, the transfer fails.


@Heading<The GET Subcommand>

@Index(GET)
Syntax: @q<GET> @i(foreign-filespec) [@i(filespec)]

The GET subcommand tells Kermit to request a file or file group
from the other system, which must have a Kermit running in server mode.
The syntax is complicated by the allowance of two forms for the
@i(foreign-filespec), just as in the SEND subcommand.  Here the parsing
is based on the number of "words" (blank-delimited strings) in the
subcommand argument, which can be anything from one to five.  If the
number is anything but four, the interpretation is unambiguous, but when
there are four words, the first word plays the key role.  If it has more
than eight characters or contains a @qq(.) or @qq(/), it is assumed to
be the whole @i(foreign-filespec); otherwise, it is assumed to be the
first of two words that, when joined by a @qq(.), make up the
@i(filespec) on the other system.

@Heading<The TAKE Subcommand>
@Index(TAKE)

Syntax: @q<TAKE> @i(filespec)

Execute Kermit subcommands from the specified file, where @i(filespec)
has the format @q<fn [ft [fm]]>.  The default
filetype is @qq(TAKE), and the default filemode is @qq(*).

Kermit subcommands may also be executed from CMS EXEC's, so that the TAKE
subcommand is, in a sense, superfluous under VM/CMS.  In CMS terminology,
Kermit establishes a Kermit subcommand environment, and EXEC's written in
EXEC 2 or REXX may invoke subcommands within
that environment.  For example,
to display the current packet checksum type, an EXEC 2 would issue
@Example(&SUBCOMMAND KERMIT SHOW BLOCK-CHECK)
and a REXX macro would issue
@Example(Address KERMIT 'SHOW BLOCK-CHECK')
There is one important difference between executing a TAKE file and an
EXEC: the former may issue a QUIT or EXIT subcommand, but the latter
may not.  Also, a Kermit subcommand issued from an EXEC returns a
completion code according to the current error status (see the table
under "After Kermit Completes" in the Kermit-370 chapter).  An EXEC
could therefore be set up to react appropriately to file transmission
errors or other unpredictable events.

@Heading<The SET Subcommand>

Syntax: @q<SET> @i(parameter) [@i(value)]

The SET subcommand establishes or modifies various parameters controlling
file transfers.
The following SET subcommands are available in Kermit-CMS, but not in
Kermit-370 in general:
@Begin(Format,spread 0)
@tabclear()@tabset(2.0inches)
DESTINATION@\"Home" disk.
FILE
  LRECL@\Logical Record length for incoming file.
  RECFM@\Record format for incoming files.
SEARCH-ALL@\Determine the default disk search scope.
@End(format)

@Subheading<SET DESTINATION>
@Index<Home disk>

Syntax: SET DESTINATION @i(letter)

This subcommand is equivalent to the CWD subcommand (q.v.).

@Subheading(SET FILE LRECL)

Syntax: @q<SET FILE LRECL> @i(number)

This sets the logical record length for incoming files to a @i(number)
from 1 to 65535 (64K-1).  This variable is used only for fixed format
and binary files.  The default is 80.

@Subheading<SET FILE RECFM>

Syntax: @q<SET FILE RECFM> @i(option)

This
sets the record format to use for incoming files.  Valid @i<option>s are
"Fixed" and "Variable" (the default).
Fixed-format records are padded or truncated, as needed, to the current
LRECL.

@Subheading<SET SEARCH-ALL>

Syntax: @q<SET SEARCH-ALL ON @i(or) OFF>

@Begin(Description,leftmargin +8,indent -8,spread 0.5)
ON@\If the user omits the filemode from a SEND subcommand
(or a GET request
to the other Kermit), Kermit-CMS will search all accessed disks for the
named file or files.

OFF@\If the filemode is not specified, only the "home" disk and its
read-only extensions will be searched for matching files.  (Default.)
@End(Description)

@Heading(The CWD Subcommand)
@Index(Home disk)

Syntax: @q<CWD> @i(letter)

The CWD (Change Working Directory)
subcommand establishes a new default ("home") CMS disk.  @i(letter) may
be the mode letter of any accessed disk.  Subsequent file transfers
take place preferentially to and from the default disk.  The initial
home disk is @qq(A).

@Heading(The DIRECTORY Subcommand)

Syntax: @q<DIRECTORY> [@i(filespec)]

Under Kermit-CMS,
the DIRECTORY subcommand is identical to the CMS LISTFILE command.

@Heading(The SPACE Subcommand)

Syntax: @q<SPACE> [@i(letter)]

This subcommand displays the storage
allocation on the specified CMS disk.
If @i(letter) is omitted, the default disk specified by the CWD
subcommand is displayed.  Aside from this default, the subcommand is
identical with CMS QUERY DISK.

@Heading(The GIVE Subcommand)

Syntax: @q<GIVE> @i(table-name) @i(filespec)

This subcommand compares
the named table with its default values and saves the differences
in a TAKE file named @i(filespec).  The format of @i(filespec) is
@q(fn [ft [fm]]).  The default filetype is @qq(TAKE), and the default
filemode is that of the "home" disk.  See the CWD subcommand.

@Heading(The CP and CMS Subcommands)

Syntax: @q<CP @i(or) CMS>  @i(text of command)

@Index(KERMBOOT)@Index(User area)
Although Kermit-CMS does not have a full set of its own
subcommands for managing
local files, it provides those services through the operating system.
You can issue any CP or CMS command, but if Kermit-CMS has
been invoked as a normal user-area program, rather than as a high-memory
"resident" program or nucleus extension,
other user-area CMS commands (such as COPYFILE) are illegal.  Even
then, you can list, type, rename or
delete files, send messages, and so on.
The @q(CMS) subcommand under Kermit is
synonymous with the @q(HOST) subcommand.

@Section<How to build an executable version of Kermit-CMS>

Before attempting to build Kermit-CMS, look in the
Kermit distribution under both IK0KER and IKCKER for an
installation document, as well as "beware", help, and update files, and
read them first.  They will probably contain information that is more
current than what you see here.

Kermit-CMS consists at present of a large
assembly and a small optional one.  The large
assembly (KERMIT ASSEMBLE) contains the Kermit program, and the small
one (KERMBOOT ASSEMBLE) is a bootstrap program for loading Kermit
into high memory and running it.
Although KERMBOOT is all in one file in the Kermit distribution, the
source for Kermit itself is in many pieces, some generic for Kermit-370
and some specific to CMS.  All the necessary pieces are sequenced in
columns 73-80 so that the numbers form a strictly increasing
sequence when the pieces are correctly "pasted" together.
It is important to preserve the original sequence numbers so that
updates, if any, can be applied to the source.

To create a runnable version:

@begin(enumerate,spread 0.5)
Combine the following @qq(ASM) files from the Kermit distribution into
a single file with @q<RECFM F> and @q<LRECL 80>: IK0DOC, IK0MAC,
IKCMAC, IK0DEF, IK0MAI, IK0CMD, IK0COM, IKCUTL, and IK0PRO.
The resulting file is the composite source for Kermit-CMS, called
KERMIT ASSEMBLE.  This source must retain the original sequence numbers
in columns 73-80 (in other words, be sure not to resequence the source
accidentally by using the editor!)

Copy or rename IKCBOO ASM from the Kermit distribution (if desired)
to a file called
KERMBOOT ASSEMBLE with @q<RECFM F> and @q<LRECL 80>.

@Index(MACLIB)
GLOBAL the necessary MACLIBs.  Under VM/SP, these are
DMSSP, CMSLIB, OSMACRO, and TSOMAC.

Assemble the source file(s).

Load one file into memory via: @q<LOAD KERMIT> or @q<LOAD KERMBOOT>.
In the former case, the entire Kermit program is now loaded; in the
latter, only a bootstrap program which expects to find the object
file @q<KERMIT TEXT> at run time.
Under CMS/SP Release 4 and above, there is a third and better option,
namely, @q<LOAD KERMIT (RLDSAVE)>.

@Index(KERMBOOT)@Index(User area)
Create the executable called @q<KERMIT MODULE> via: @q<GENMOD KERMIT>.
Alternatively (under CMS/SP Release 3 and below),
create both KERMIT and KERMBOOT modules to give the
user a choice of user-area or high-memory execution.  Since
Kermit-CMS is serially reusable, it can be reinvoked in the user
area with the START command, but the high-memory version must be
reloaded each time.
If Kermit is loaded using the RLDSAVE option (Release 4 and above), the
module can, in fact, be run either way; the command @q<NUCXLOAD KERMIT>
will load Kermit "permanently" into high memory for invocation at need.

@Index(Initialization files)
If your site's ASCII/EBCDIC translation table
for TTY lines does not conform
to the one listed in the appendix (which in turn conforms to the
one given in the IBM System/370 Reference Summary), then enter
the appropriate SET ATOE/ETOA/TATOE/TETOA
subcommands in the SYSTEM KERMINI
file, which should reside on the same disk as KERMIT MODULE (and
KERMIT TEXT).
@i<NOTE:> If the ASCII/EBCDIC translation is not invertible,
Kermit will not and cannot work.
@end(enumerate)

@Section<What's New>
Below is a list of the more important CMS-specific features in Version
@value(-cmsversion) of Kermit-CMS added since the previous release,
Version 3.1, in September 1986.
For the list of generic additions, see the
chapter on Kermit-370.

@begin(enumerate,spread 0.5)
System commands issued through Kermit via the @q<CMS> or @q<HOST>
subcommands are automatically passed on to CP if (a) CMS rejects them and
(b) IMPCP is set ON.

Kermit subcommands may be executed directly from CMS EXEC's.

Reject files known (via A-packets) to be too big for available storage.

Bypass user translation tables and set TERMINAL SCROLL CONT
for protocol mode on TTY lines.

KERMBOOT avoids the loading problem (@q<VIRTUAL STORAGE CAPACITY
EXCEEDED>) due to large GLOBAL TXTLIB's and preserves the untokenized
command line so that Kermit may be given mixed-case or long words as
part of the initial command.

@end(enumerate)

@Section(What's Missing)

Work on Kermit-CMS will continue.  Features that need to be
improved or added include:
@begin(itemize)
Allow timeouts so Kermit-CMS does not wait forever if a packet does
not arrive in a timely fashion.  This is not possible under CMS at
present.

Detect file properties from Attribute packets and allow overriding
current parameter settings.  Also implement file archiving.

Add a @q(SET REPEAT) subcommand.

Finish @q(SET LINE), so that Kermit-CMS can be used as a local
Kermit, connecting to a remote host over another communication port.
Add a @q(CONNECT) subcommand.

Intercept CP messages during protocol mode, rather than just suppressing
them.  Display the messages later or log them or send in packets as
appropriate.

Define EXEC variables from Kermit by analogy with the XEDIT EXTRACT
subcommand.
@end(itemize)
