.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.ENABLE QUIET
.DISABLE DISPLAY
.;
.; Author:	Robert Hays
.; Date:	March 4, 1986
.;
.; Defines the global symbol $DEVIC, using device loaded as p1.
.;
.; RLH01	Robert Hays
.;		02-MAY-86
.;		Check that the [0,0]000000.DIR file is available.  The reason
.;		for this call to .TESTFILE is to ascertain that the current
.;		user has indeed mounted the device.  .TESTDEVICE only checks
.;		that ANY user has mounted the device (It looks at the device
.;		mounted flag bit in the device data base.  Since .TESTDEVICE
.;		does not check pool for WHO has it mounted, the MOU flag is
.;		set in <EXSTRI> whether you actually have access to the
.;		device or not.).
.;
	.SETS switch "/OVR/LOCK=N"		! Place your favorite mount
.;						! settings here for default
.;						! user mounts.
.Chkdev:
.;
.; Checks that the specified device is there, loaded, on-line and mounted.
.;
	.ONERR Error
	.SETN status 1				! Init status to success.
	.SETF $devmo				! Init to no mount here.
.;
	.IF p1 EQ "" .GOTO NoSuch
	.SETS devic p1				! Get parameter.
	.PARSE devic ":" devic rest		! Tack on :.
	.SETS devic devic+":"			! 
	.TESTDEVICE 'devic'			! Check the device.
	.SETS devlst <exstri>			! Save the string.
	.TEST devlst "NSD"			! Check that device exists.
	.IF <strlen> GT 0 .GOTO NoSuch
	.TEST devlst "UNL"			! Is it unloaded?
	.IF <strlen> LE 0 .GOTO Loaded		! If it is loaded, continue.
		.IFNINS LOA INS $LOA		! No, so check for LOA.
		.IF <exstat> EQ 1 .GOTO Ins1	! Did INS LOA succeed?
			.SETS tsk "LOA"		! LOA failed to install, so
			.GOTO Inserr		! set TSK and jump to error.
.Ins1:		LOA 'devic'
		.IF <exstat> NE 1 .GOTO NoLoad	! Did we load the device?
.Loaded:
	.TEST devlst "ALO"			! Is device allocated to
	.IF <strlen> GT 0 .GOTO Alloc		! another?
	.TEST devlst "PUB"			! Public device?
	.IF <strlen> GT 0 .GOTO Endchk		! We can get there, then.
.;
.; RLH01 -- Check that current user has mounted disk by looking for the
.;          [0,0]000000.DIR file.
.;
	.TESTFILE 'devic'[0,0]000000.DIR
	.IF <filerr> EQ 1 .GOTO Endchk		! We can access device.
.;
.Moudev:
.;
.; Mount the device.
.;
		MOU 'devic''switch'
.;
.; Check for errors.
.;
		.IF <exstat> NE 1 .GOTO NoMou	! MOU failed.
		.SETT $devmo			! Flag mounting.
.Endchk:
	.SETS $devic devic
	.EXIT status
.;
.; Error condition processing.
.;
.NoSuch:
	.DISABLE QUIET
	;
	; ERROR -- The device 'devic' does not exist on the system.
	;          Please check the spelling.  If in doubt, use the
	;          MCR DEV request to check for allowable devices.
	;
	.ENABLE QUIET
	.SETN status 4
	.GOTO Endchk
.;
.Inserr:
	.DISABLE QUIET
	;
	; ERROR -- Could not install task 'tsk'.
	;
	.ENABLE QUIET
	.SETN status 4
	.GOTO Endchk
.;
.NoLoad:
	.DISABLE QUIET
	;
	; ERROR -- Device 'devic' could not be loaded.
	;
	.ENABLE QUIET
	.SETN status 4
	.GOTO Endchk
.;
.Alloc:
	.DISABLE QUIET
	;
	; ERROR -- Device 'devic' is allocated to another user.
	;
	.ENABLE QUIET
	.SETN status 4
	.GOTO Endchk
.NoMou:
	.DISABLE QUIET
	;
	; ERROR -- Device 'devic' cannot be mounted.
	;
	.ENABLE QUIET
	.SETN status 4
	.GOTO Endchk
.Error:
	.SETN status 4
	.GOTO Endr
