/******************************************************************************

			UNSW Prolog (version 4)

			Written by Claude Sammut
		     Department of Computer Science
		     University of New South Wales
		   (and St. Joseph's U., Philadelphia)

		   Copyright (c)  1983 - Claude Sammut

******************************************************************************/





	/*	predicates for accesing internals of dtat structures	*/


#include "pred.h"

extern integer *stack_int;

static
nvars PREDICATE
{
	if (TYPE(arg[0]) != CLAUSE)
		fail("Nvars - first argument must be a clause")
	return(unify(arg[1], frame[1], stack_int, arg[0] -> g.nvars));
}


static
goal PREDICATE
{
	register i, n;
	register clause *p;

	if (! isinteger(arg[0]))
		fail("Goal - first argument must be a integer")
	if (TYPE(arg[1]) != CLAUSE)
		fail("Goal - second argument must be a clause")

	p = (clause *) arg[1];
	n = INT_VAL(0);

	for (i = 0; i <= n; i++)
		if (p -> goal[i] == 0) return(FALSE);
	return(unify(arg[2], frame[2], p -> goal[n], frame[1]));
}


static
offset PREDICATE
{
	if (isvariable(arg[0]))
		return(unify(arg[1], frame[1], stack_int, arg[0] -> v.offset));
	else
		fail("Offset - first argument must be variable")
}


atom_table p_access =
{
	SET_PRED(NONOP, 0, 2, "nvars", nvars),
	SET_PRED(NONOP, 0, 3, "goal", goal),
	SET_PRED(NONOP, 0, 2, "offset", offset),
	END_MARK
};
