.tr `'
.de cc		\" macro to format each command description"
.Eb
.ne 10
.sp
\\$1
.Ib
..
.ll +15
.Hd 'Ued'7-october-79'Ued' "" first
.Ft ''-%-''
NAME
.Ib
Ued - Text Editor
.Eb
SYNOPSIS
.Ib
UED file

EEE file
.Eb
DESCRIPTION
.Ib
Ued is a command-driven line editor.
.sp
If a FILE argument is given, UED simulates an E command (see below) on the 
named
file; that is to say, the file is read into UED's buffer so that it 
can be edited.
.sp
UED operates on a copy of any file it is editing; changes made
in the copy have no effect on the file
until a w (write), x (write new version), or control-z (same as x and q)
is given. The copy of the text being edited resides
in a temporary file called the buffer.  There is only one buffer.
.sp
The buffering of changes has advantages and disadvantages. One
major advantage is that if you decide you don't like
what you have been doing, you can exit the editor (without writing out
the buffer) and the file you were editing
will be unaffected.  The disadvantage
is that if you accidentally exit the editor without writing out the buffer, you
will
lose your work.  Ued will try to prevent this from happening.  If 
you try to exit (with a q command) without writing out your file, Ued will
warn you (but only once).  If you retype the command a second
time, it will be accepted, and the contents of the buffer will be lost.
.sp
Commands to UED have a simple and regular structure: zero or more addresses
followed by a single character command, possibly followed by
parameters to the command. These addresses specify
one or more lines in the buffer. Every command that requires addresses has 
default
addresses, so that the addresses can often be omitted.
.sp
In general, only one command may appear on a line. Certain commands allow the
input of text. This text is placed in the appropriate place in the
buffer. While UED is accepting text, it is said to
be in input mode. In this mode, no commands are recognized; all input is merely
collected. Input mode is left by typing a period "." alone at the beginning
of a line.
.sp
Ued supports a limited form of "regular expression" notation. A regular 
expression
specifies a set of strings of characters. A member of this set of strings is 
said to be "matched" by the regular expression. The regular 
expressions allowed by UED are constructed as follows:
.Ls ".	" i
.Le
An ordinary character (not one of those discussed below) matches the
specified character.

.Le
A circumflex "^" at the beginning of a regular expression matches the
empty string at the beginning of a line.

.Le
A currency symbol "$" at the end of the regular expression matches
the null character at the end of a line.

.Le
A period "." matches any character except a newline character (i.e.
it will not cross line boundaries).

.Le
A string of characters enclosed in square brackets ("[]") matches any
character in the string but no others. 
This notation is called a "character class".
If, however, the first
character of the string is a circumflex "^" the regular expression matches 
any character except newline and the characters in the string (called a
negated character class).
For example: "[abc]" matches an a, b, or a c.

.Le
An asterisk following a character,  or a character class or other
special character causes a match of 0 or more occurances of the 
preceding regular expression.
When more than one string on the line would match, the longest one
starting from the beginning of the substring preceding the `*' is used.
This sometimes is not what is desired but allows for `.*' to match
the entire line and `x.*' to mean x to the end of the line.

For example: ".*" matches the entire line; "a*" matches any length
string of a's;  "[abc]*" matches any number of characters all of
which are either a, b, or c. (note that the expression also matches zero
occurances as well). The regular expression "^[123456789]" 
matches any line beginning with a number; "^$" matches null lines;
"^ *$" matches null lines or those with only blanks.

.Le
The concatenation of regular expressions is a regular expression that
matches the concatenation of the strings matched by the components
of the regular expression.

.Le
The null regular expression standing alone is equivalent to the
last regular expression encountered.
That is, a regular expression is specified as a string of characters
delimeted by a pair of characters (quite often slashes). A null
regular expression is simply the two delimeter characters.
.El
Regular expressions are used in addresses to specify lines
and in one command (see substitute below) to specify a
portion of a line to be replaced.  If a 
user wants to use regular
expression metacharacters (such as $ [ ]  etc.)
as an ordinary character, that character may be
preceded by "\\". This also applies to the character delimiting
the regular expression and to "\\" itself.
.sp
To understand addressing in UED it is necessary to know that at any
time there is a current line.
Generally speaking the current line is the last line affected by
a command; however, the exact effect on the current line is 
discussed under the description of the command. Addresses are
constructed as folllows.
.Ls ".	" i
.Le
The character `.' addresses the current line.

.Le
The character `$' addresses the last line of the buffer.

.Le
A decimal number N addresses the n-th line of the buffer.
Note that line numbers are relative  to the beginning of the
the buffer
and that they change when lines are added or deleted.

.Le
A regular expression enclosed in slashes `/' addresses
the first line found by searching toward the
end of the buffer and stopping at the first
line containing a string matching
the regular expression.  If necessary
the search wraps around to the beginning
of the buffer.

.Le
A regular expression enclosed in queries `?' addresses the
first line found by searching toward the beginning
of the buffer and stopping at the
first line containing a string
matching the regular expression. If necessary, the
search wraps around to the end of the buffer.

.Le
An address followed by a plus sign `+' or a minus sign `-'
followed by a decimal number specifies that address plus
(resp. minus) the indicated number of lines.

.Le
If an address begins with `+' or `-' the addition or subtraction is taken
with respect to the current line; e.g. `-5' is understood to mean `.-5'.

.Le
If an address ends with `+' or `-', then 1 is added (resp. subtracted). As
a consequence of this rule and rule vii, the address `-' refers to the line 
before the current line.
Moreover, trailing `+' and `-' characters have cumulative effect, so `--'
refers to the current line less 2. Also, the escape key is equivalent 
to `.-1' and the carriage return alone refers to `.+1'.

.Le
The space bar when used as an address, stands for the last address pair
specified (if one exists). This is very useful when working on a set
of lines such as a list of files where one wants to modify all the lines
is the same way and does not want to keep specifying the range of lines.
The "last" range is save until 2 more addresses are input (i.e. single
address commands and the "z" command don't change them).
This is also the recomended way of deleting multiple lines; first list the
range of lines to be deleted, then issue the delete using the space bar
abrevition to insure which lines will be deleted.

.Le
To maintain compatibility with earlier versions of the editor,
the character `^' in addresses is entirely equivalent to `-'.
.El
Commands may require zero, one, or two addresses. Commands which require no
addresses regard the presence of an address as an error. Commands
that accept one or two address assume
default addresses when insufficient addresses are given. If more
addresses are given than such a command requires, the last
one or two (depending on what is accepted) are used.

Addresses are separated from each other typically by a comma `,'. They
may also be separated by a semicolon `;'. In this case the
current line `.' is set to the previous address
before the next address is interpreted. This feature can be used
to determine the starting line for forward and backward searches
(`/', `?'). The second address of any two-address sequence
must correspond to a line following the line corresponding to
the first address.

In the following list of UED commands, the default addresses are
shown in parentheses. The parentheses are not part of the address,
but are used to show that the given addresses are the default.

As mentioned, it is generally illegal for more than one command to appear
on a line.  However, any command may be suffixed by `p', in which case the
current line is printed.
.Eb
.sp
(.)a
.br
<text>
.br
(dot)
.Ib
This command APPENDs the given text after the addressed
line. `.' is left at the last line input; if there were none, at the
addressed line.
.cc (.,.)a<text>
This version of the APPEND command, appends text to the end of the
current line.
.sp
NOTE WELL, this command is implemented as a macro equivalent to
s!$!<text>.
The `!' is for visibility and is actually a control a. But since this
command is  a macro, appending text that contains `\\' or
the `&' need to be escaped (with the `\\') to nullify their special
meaning in the substitute command.
If it is desired not to print (echo) the new line a control-a may be
appended to the command (also useful for a multi-command global).
.cc (.,.)c
The CHANGE command deletes the addressed lines, then accepts input text that
replaces these lines. `.' is left at the last line input; if there was none, it
is left at the first line not deleted.
.cc "(.,.)d"
The DELETE command deletes the addressed lines, from the buffer.
The line originally after the last line deleted becomes
the current line; if the lines deleted were originally
at the end, the new last line becomes the current line.
.cc "e filename"
The EDIT command causes the entire contents of the buffer to be deleted, and
then the named file to be read in. `.' is set to the
first line of the buffer. The number of lines read is typed.
`filename' is remembered for a possible use as a default file
name in a subsequent e, r, w, x, or control-z command.
If the file does not exist, but is an otherwise valid filename, it
is remembered (Ued will tell you it can't open the file) for a later
w, x, op control-z.  This is desirable when creating a new file.
.cc "f filename"
The FILENAME command prints the currently remembered file name. If
`filename' is given, the currently remembered file name is changed
to `filename'.
.cc "(1,$)g/regular expression/command list"
In the GLOBAL command, the first step is to mark every line that matches the 
given regular expression. Then for every such line, the
given command list is executed with `.' initially set to that line.
A single command or the first of multiple commands appears on the same
line with the global command. All lines of a multi-line list
except the last line must be ended with `\\'. a, i, and c commands
and assocaiated input are permitted; the `.' terminating
input mode may be omitted if it would be on the last line of the
command list. The (global) commands g, and v, are not permitted
in the command list.

Note: The escape character must be itself escaped in the command list
portion of the global command. The way this works is that the command
list is copied to a temporary area to be repeatedly executed. In this
copy operation the escape character is interpreted (to handle multiple
lines) and thus is removed. Therefore, two escapes result in one stored
for later execution (one time for each line matched).
.sp
.sp
.Eb
(.)i
.br
<text>
.br
(dot)
.br
.Ib
This command INSERTs the given text before the addressed line. `.'
is left at the last line input; if there were none, then at the
line BEFORE the addressed line. This is equivalent to `.-1a'
.cc "(.,.)i<text>"
This version of the INSERT command inserts text on the front of
the current line. The same restrictions hold as in the append command
described above.
.cc "(.,$)j filename"
The JOIN command appends the addressed lines to the specified `filename'.
If the file does not exist, it is created. The last of the appended lines
becomes the current line.
.cc (.,.)ka
The KOPY command makes a copy of the addressed lines and places them in the
buffer after the addressed line `a'. The last of the copied lines
becomes the current line.
.cc (.,.)ma
The MOVE command repositions the addressed lines after the line addressed by a.
The last of the moved lines becomes the current line.
.cc o[vtsinf?]
The OPTIONs command permits selection of various options. Multiple options
may be selected in one command. The options are:

1. `ov' for verbose operation (long error messages)

2. `ot' for terse operation

3. `os' to sense case in string matching

4. `oi' to ignore case in string matching

5. `on' for line numbering on.

6. `of' for line numbering off (may be specified as `off')

7. `o?' - This is not actually an option. It is used to print the value
of the temp file pointer. Ued keeps appending to the temp file for every
line added or modified.  If this file runs out, then editing can no
longer take place. The value printed ranges from 1->32767,-32768->-1.
An operation such as inserting or changing 1 character on every line
in the file will double the value of the pointer. Before doing so, it is
wise to check this value (a positive value means it should work).
The version of Ued called Bed (Big Ed) has an average of 20 times
the capacity (sometimes better if lines are 64 or fewer chars on average)
and should be used where necessary.
The default options are verbose, case insensitive, and line numbering off.
.cc (.,.)p
The PRINT command prints the addressed lines. `.' is left at the last
line printed.
The p may be omitted if the command is not in a global command. That
is to say, addr1,addr2 will print from addr1 thru addr2. Recall that
any address range (two addreses) is remembered. Thus to reprint a
range of lines may be done via a space<cr> since space abbreviates to
the last range and the p command is the default here as well.
This is useful after a range of lines have been modified via s, a, or i
commands all of which will only print the last line changed.
.cc q
The QUIT command causes UED to exit. No automatic write of
a file is done, altough there is a warning mechanism. If your file has 
not been written out, the first issuance of the q command will cause
a warning; the second issuance will allow an exit. See the control-z
command as it will allow an exit with an automatic write of the
file (creating a new version number as well).
.cc "($)r filename"
The READ command reads in the given file after the addressed line.
If no file name is given, the remembered file name, if any, is
used (see e and f commands). The remembered
file name is not changed unless `filename' is the very first file
name mentioned. Address `0' is legal for r and causes
the file to be read at the beginning of the buffer.
If the read is successful, the number of lines is typed. `.' is
left at the last line read in from the file.
.cc "(.,.)s#/regular expression/replacement/
The SUBSTITUTE command searches each addressed line
for an occurrence of the specified regular expression.
Any character other than space or newline may be used instead of `/'
to delimit the regular expression and the replacement. `.' is left at
the last line substituted.
.sp
An ampersand `&' appearing in the replacement is replaced by the
string matching the regular expression. The special meaning of
the `&' in this context may be suppressed by preceding it by `\\'.
This may be used more than once on the line; useful for creating
pip command files since g/.*/s//&=&  will take all lines 
in a file containing a list of file names (with no extensions)
and turn them into "file=file".
.sp
Lines may be split by substituting newline characters into them. The
newline (line-feed) must be escaped by preceding it by `\\'. Note
that the line is not treated as two separate lines until written
out and read back in, rather it is simply a line with an imbedded newline.
.sp
The trailing delimeter (`/') is optional. If it is not specified, then
it is added along with a p command (for echoing).  This means
also, that if the trailing delimeter IS specified, then no echo of the
newly formed line is performed (useful in a global).
.sp
The # that follows the `s' is optional and means substitute the #-th
occurance of the regular expression. Also, if # is 0, then it means
do the substitution to all occurances of the regular expression on the
current line. The default value for # is 1.
To change all occurances of the string "old" to "new" can be done
 via: g/old/s0//new
or as 1,$s0/old/new.

This feature can be used to substitute the n-m'th characters in a line.
s10/..../  will match columns 10-13, s20/.*/ matches columns 20-end of
the line.

For compatibility with previous versions of this editor, a global
substitution may be performed as follows:

s/from/to/gp

The above is therefore exactly the same as:

s0/from/to

.cc "u"
This command will undo the last substitution (s command).  It may be
issued on a line by itself or with any other command appended to it.
A common editing error is to change the wrong pattern on the
line (usually because of an earlier match). The following example
illustrates a common use of `u'.

line:	This is thi kind of common error.

command: s/thi/the

result:	Thes is thi kind of common error.

To correct this by restoring the original line and changing the
second (desired) occurance of `thi' to `the' issue the following:

us2//the

This takes advantage of the fact that the previous pattern was
valid (and remembered by Ued) but the default is to select the 1st
occurance of the pattern. The final result is:

final: This is the kind of common error.

Note: You must issue the 'u' command immediatly after the bad substitution.
You can't move the pointer around first.  Since the `i' and `a' commands
have versions which are actually substitute commands (hidden with a macro),
the `u' command will undu those as well.
.cc "(1,$)v/regular expression/command list"
This command is the same as the global command except
that the command list is executed with `.' initially
set to every line except those matching the regular expression.
.cc "(1,$)w filename"
The WRITE command writes the addressed lines ONTO (updating) the given
file; if it does not exist it is created. This command will destroy the
contents of the file it references if it exists; therefore, the X command
is the recomended method of writing out the buffer. Only where the user
is sure that the old file is of no use (e.g. a temporary file) should the
WRITE command be given.
.cc "(1,$)x filename"
This command is similar to the W command described above, but in RSX it
will write the file to the next higher version number (of filename) if
a file with the name `filename' allready exists. If none exists, then it
is created (version number 1). This command may be combined with an exit
by using the control-z command.
This command along with the w command should be used periodically during
a long input session to safeguard against system crashes.
.cc "(.)z[+-][n]"
This command (we're running out of letters) lists n lines either just
before (-n), around (n), or after (+n) the specified line. The current line
is not changed.
The default value for `n' is 20 lines. If `n' is specified as a `z' (as in 
`zz') then this will print the entire buffer (no change to current line). 

If the line number print option (see `o' command option `n') is selected,
the z command will mark the current line with `--' to the right of the
line number.
.cc "Control-z"
This command is executed by depressing the control and z keys at the same time.
It is a macro which is translated into an x, then an f, and then a q command.
It has the effect of writing out the remembered file (the one named in the e
command or on the initial command line to UED) as a new version, then it
echoes the name of the file just written and exits. This is the 
prefered method
of exiting an edit session.
.cc (.)=
The `=' command will display the line number of the addressed line; useful
when combined with `$', as in `$=', to find the number of lines in the buffer.
.cc "(.+1)<newline>"
an address alone on a line causes the addressed line to be printed.
A blank line alone is equivalent to `.+1p'; it is useful for stepping
through text.
.cc "<escape>"
The escape key (no need for a carriage return after the escape key) is
equivalent to `.-1p'; along with the above <newline> command is useful
for stepping backward through text.
.cc "!<mcr command>"
This command allows for the temporary escape from the editor to perform
RSX commands.
.cc "(.)&"
This command will print then next 20 lines after the addressed line. The
current line is left at the last line printed.
.Eb
OPTIONAL STYLE
.Ib
The UED editor is available under the name EEE. This version has two 
differences.

1. The SUBSTITUTE (s) and CHANGE (c) commands are reversed; this is 
convienent for old `EDI' users.

2.  Line numbering is on at startup.
.Eb
BUGS
.Ib
Funny things happen with multiline global commands that try to insert lines 
before dot. Text seems to go in at the wrong place.
However, appending lines after dot works.

.Eb
SEE ALSO
.Ib
`A tutorial to the Unix editor.'  [Bell laboratories internal memorandum].
This introduction is quite good even though
it describes a slightly different dialect of this editor.
Also see the book "Software Tools" [Addison-Wesley - 1976].
Both are written by Brian W. Kernighan of Bell Laboratories with
"Software tools" co-authored by P. J. Plauger of Yourdon inc.
