
#include	"sysdef.h"

/*	initialization for the terminal and screen editor		*/

#include	"scerrd.h"
#include	"scterm.h"
#define	then

extern int win_low[] ;
extern int win_high[] ;
extern int win_curline[] ;
extern int w ;
extern int fastio ;

edinit()
{
	register int status ;

	status = cretm1() ;
	if ( status != 0 ) then status = cretm2() ;
	return( status ) ;
}
		
#if	VAXVMS

static struct exithandler 
		{ int *nextaddr ;
		  int *myaddr ;
		  int nargs ;
		  int *status_arg ;
		} myhandler ;
static int exit_status ;
#endif

scinit()
{
	register unsigned int *wp ;
	extern int *curline,inpage,*loclow,*maxline,page_size[],termtype ;
	extern int fill_s,infill,left_m,leftmargin,ttpsize,ttastarm;
	extern int workbuffer,*workpointer;
	extern int kpstatus, sts_one, sts_two, oldstsone ;
	extern int inmode,rept,no_echo,*lochigh ;
	int fixterm() ;	

	if ( (sts_one & _vtedit) != 0 )
	  then	{
		tederror("You can't call the screen edit from itself") ;
		return(0) ;
		}

	curline = &win_curline[0] ;
	loclow  = &win_low[0]  ;
	lochigh = &win_high[0] ;

	oldstsone = sts_one ;
	ttastarm = 0 ;
	rept = 0 ;
	no_echo = 0 ;
	inmode  = 0 ;
	workpointer = &workbuffer ;
	leftmargin = 0 ;
	left_m = 1 ;
	sts_one |= _vtnolines + _vtedit ;
	fill_s = 72 ;

	setpaste(0) ;
	if ((termtype = inqtermtype()) == 0) termtype = _vt100 ;
	ttpsize = page_size[termtype] ;
	setterminal() ;
	setbro_trap() ;
#if	VAXVMS
	myhandler.nextaddr = 0 ;
	myhandler.myaddr = &fixterm ;
	myhandler.nargs = 0 ;
	myhandler.status_arg = &exit_status ;
	sys$dclexh(&myhandler) ;
#endif
	terinit() ;
	inseofmark() ;
	if ( (*loclow = inpage) == 0 || inpage >= *maxline ) then *loclow = 1 ;
	*curline = *loclow ;
	kpapplication() ;
	kpstatus = 1 ;
	putbin("\015\012",2) ;
	scloadline() ;
	scmove() ;
	sctopline() ;
	newpage(*curline) ;
	scloadline() ;
	scmove() ;
	return(1) ;
}

	


terinit()

{
	extern int termtype ;
	int i ;

	switch (termtype) {

	  case	_tty:
		break ;

	  case _ansi:
		putbin("\033<",0) ;
		putbin("\033[?7l\033[>6h",0) ;
		break ;

	  case _vt100:
		putbin("\033(B\033<",0) ;
		putbin("\033[2J",0) ;
		putbin("\033[02;23r",0) ;
		putbin("\033[3g\033[?7l\033[?6l\033[?8h",0) ;
		for (i=0 ; i < 16; i++) putbin("\033[8C\033H",0) ;
		putbin("\015",0) ;
		break ;

	  case _vt220:
		putbin("\033[62;1\"p",0) ;
		putbin("\033(B\033<",0) ;
		putbin("\033[02;23r",0) ;
		putbin("\033[3g\033[?7l\033[?6l\033[?8h",0) ;
		for (i=0 ; i < 16; i++) putbin("\033[8C\033H",0) ;
		putbin("\015",0) ;
		break ;

	  default:
		break ;

	}
}


scbye()
{
	extern int oldstsone,sts_one,termtype ;

#if	VAXVMS
	sys$canexh(&myhandler) ;
#endif
	clrbro_trap() ;
	sts_one = oldstsone ;
	if ( termtype == _vt220 && inqtermtype() != _vt220 )
	     then putbin("\033[61\"p",0) ;
	putbin("\033[r\033[?7h",0) ;
	putbin("\015\012",0) ;
	fclear() ;
	deleofmark() ;
	kpnormal() ;
	rstterminal() ;

}

#if	VAXVMS
static fixterm()
{
	extern int termtype ;

	if ( termtype == _vt220 && inqtermtype() != _vt220 )
	     then putbin("\033[61\"p",0) ;
	putbin("\033[r\033[?7h",0) ;
	putbin("\015\012",0) ;
	fclear() ;
	kpnormal() ;
}
#endif

