	.TITLE	VTLACT - VTL VT100 Action Routines
	.IDENT	/1.1/
	.ENABL	LC
;+
;
;			  Free software BY
;		Project Software & Development, Inc.
;
; This  software  is  furnished  for  free and may be used and copied as
; desired.  This software or any other copies thereof may be provided or
; otherwise  made  available  to  any  other  person.  No  title  to and
; ownership of the software is hereby transferred or allowed. 
;
; The  information  in this software is subject to change without notice
; and  should  not  be  construed  as  a commitment  by PROJECT SOFTWARE
; AND DEVELOPMENT, INC.
;
; PROJECT SOFTWARE assumes no responsibility for the use or  reliability  
; of this software on any equipment whatsoever.
;
;	Project Software & Development, Inc.
;	14 Story St.
;	Cambridge, Ma. 02138
;	617-661-1444
;
;
; Title:	VTLACT.MAC
; Author:	Robin Miller
; Date:		July 7, 1983
;
; Description:
;
;	VT100 action routines.
;
; Modification History:
;
; May 23, 1984 by Robin Miller.  Edit (01).
;	Home the cursor before changing column modes and before setting
;	the scrolling region to avoid bugs in the VT100 terminal.
;
;-
	.ENABL	AMA
	.NLIST	BEX


;	Macro to move a VT100 escape sequence to buffer in R0.

	.MACRO	VTMSG	LABEL,MSG
	.PSECT	$VTMSG,RO,D,REL,CON
LABEL:	.ASCIZ	<ESC>"MSG"
	.PSECT
	JSR	R5,.SAVR1
	MOV	#LABEL,R1
	CALL	MOVEC
	.ENDM

;	Macro to write a VT100 escape sequence immediatly.

	.MACRO	VTWRT	LABEL,MSG
	.PSECT	$VTMSG,RO,D,REL,CON
	.NCHR	$$$,^/MSG/
LABEL:	.ASCII	<ESC>"MSG"
	.PSECT
	JSR	R2,$SAVVR
	MOV	#LABEL,R0
	MOV	#<$$$+1>,R1
	CALL	WRITIT
	.ENDM

;	Macro to move a single character to buffer in R0.

	.MACRO	MOVCHR	CHAR
	.NCHR	$$$,^/CHAR/
	.IF EQ	$$$-1
	MOVB	#''CHAR,(R0)+
	.IFF
	MOVB	#CHAR,(R0)+
	.ENDC
	.ENDM

;******************************************************************************

;	Put VT100 in ANSI mode.

ANSI::	VTWRT	ANSIM,^/</		; Enter the ANSI mode.
	RETURN

;******************************************************************************

;	Application keypad mode.

APPKEY::VTMSG	APPKM,<=>		; Enable application keypad mode.
	RETURN

;	Numeric (normal) keypad mode.

NUMKEY::VTMSG	NUMKM,^/>/		; Enable numeric keypad mode.
	RETURN

;******************************************************************************

;	Turn all attributes off.

ATTOFF::VTMSG	NOATTR,<[0m>		; Turn off all the attributes.
	RETURN

;	Turn on all attributes except for underscore.

ALLATT::VTMSG	ALLMSG,<[1;5;7m>	; Bold / blink / reverse.
	RETURN

;	Turn on blink attribute.

BLINK::	VTMSG	BLINKM,<[5m>		; Turn blink attribute on.
	RETURN

;	Turn on bold attribute.

BOLD::	VTMSG	BOLDM,<[1m>		; Turn bold attribute on.
	RETURN

;	Turn on reverse video attribute.

REVERSE::
	VTMSG	REVMSG,<[7m>		; Turn reverse video on.
	RETURN

;	Turn on underscore attribute.

UNDER::	VTMSG	UNDERM,<[4m>		; Turn underscore on.
	RETURN

;******************************************************************************

;	Clear the entire screen.

CLRSCR::CALL	HOME			; Put curser in home position.	(01)
	VTMSG	CLEARM,<[2J>		; Clear to end of the screen.
	RETURN

;	Clear to end of line.

CEOL::	VTMSG	CEOLM,<[0K>		; Erase to end of the line.
	RETURN

;	Clear to end of the screen.

CEOS::	VTMSG	CEOSM,<[0J>		; Erase to end of the screen.
	RETURN

;	Clear to the beginning of the screen.

CBOS::	VTMSG	CBOSM,<[1J>		; Erase to beginning of the screen.
	RETURN

;	Position cursor to the home position.

HOME::	VTMSG	HOMEM,<[H>		; Put curser in home position.	(01)
	VTMSG	CLEARM,<[2J>		; Clear to end of the screen.
	RETURN

;******************************************************************************

;	Cursor movement commands.

CUP::	VTMSG	CUPM,<[A>		; Move the cursor up a line.
	RETURN

CDOWN::	VTMSG	CDOWNC,<[B>		; Move the cursor down a line.
	RETURN

;******************************************************************************

;	Double width single height line.

DWIDTH::VTMSG	DWMSG,<#6>		; Double width single height.
	RETURN

;	Set for single width single height line.

SWIDTH::VTMSG	SWMSG,<#5>		; Single width single height.
	RETURN

;******************************************************************************

;	Change character sets.

SGRAPH::VTMSG	SGRAPM,<(0>		; Special graphics.
	RETURN

USSET::	VTMSG	USSETM,<(B>		; USASCII character set.
	RETURN

;******************************************************************************

;	Forward index.

INDEX::	VTMSG	INDEXM,<D>		; Forward index.

;	Reverse index.

RINDEX::VTMSG	RINDXM,<M>		; Reverse index.
	RETURN

;******************************************************************************

;	Set screen to 80 column mode.

NARROW::CALL	HOME			; Put curser in home position.	(01)
	VTMSG	NARSCR,<[?3l>		; Set screen to 80 column mode.
	RETURN

;	Set the screen to 132 column mode.

WIDE::	CALL	HOME			; Put curser in home position.	(01)
	VTMSG	WIDSCR,<[?3h>		; Set screen to 132 column mode.
	RETURN

;******************************************************************************

;	Disable the scrolling region (puts cursor in home position).

NOREG::	CALL	HOME			; Put curser in home position.	(01)
	VTMSG	NOREGM,<[r>		; Disable the scroll region.
	RETURN

;******************************************************************************

;	Save cursor position and attributes.

SAVEC::	VTMSG	SAVECM,<7>		; Save cursor and attributes.
	RETURN

RESTC::	VTMSG	RESTCM,<8>		; Restore curser and attributes.
	RETURN

	.SBTTL	MAKLIN - Make the VT100 ASCII line number.
;+
;
; MAKLIN - Make the VT100 ASCII line number.
;
; Inputs:
;	R0 = The output buffer address.
;	R1 = The binary line number to convert.
;
; Outputs:
;	R0 = The updated output buffer address.
;
;	All other registers are preserved.
;
;-
MAKLIN::JSR	R5,.SAVR1		; Save R1 - R5.
	MOVCHR	<ESC>			; Move in the
	MOVCHR	<[>			;   escape sequence.
	CALL	CVTDEC			; Make the ASCII line number.
	MOVCHR	<;>			; Prepare for the column number.
	RETURN

	.SBTTL	MAKCOL - Make the VT100 ASCII column number.
;+
;
; MAKCOL - Make the VT100 ASCII column number.
;
; Inputs:
;	R0 = The output buffer address.
;	R1 = The binary column number.
;
; Outputs:
;	R0 = The updated output buffer address.
;
;	All other registers are preserved.
;
;-
MAKCOL::JSR	R5,.SAVR1		; Save R1 - R5
	CALL	CVTDEC			; Make the ASCII column number.
	MOVCHR	<H>			; End of curser addressing.
	RETURN

	.END
