	.TITLE	PARSE - PARSE AND FIND WILDCARDS
	.IDENT	/01.1/
	.ENABL	LC
;+
;
;			  Free software BY
;		Project Software & Development, Inc.
;
; This software is furnished for free and may be used and  copied as
; desired. This software or  any  other copies  thereof may be provided
; or otherwise made available to any other person.  No title to and
; ownership of  the  software  is  hereby transferred or allowed. 
;
; The information in this software is subject to change  without  notice
; and  should  not  be  construed  as  a commitment by PROJECT SOFTWARE
; AND DEVELOPMENT, INC.
;
; PROJECT SOFTWARE assumes no responsibility for the use or  reliability  
; of this software on any equipment whatsoever.
;
;	Project Software & Development, Inc.
;	14 Story St.
;	Cambridge, Ma. 02138
;	617-661-1444
;
;
; Title:	PARSE
; Author:	Robin Miller
; Date:		February 11, 1982
;
; Description:
;
;	These routines are used to parse and find file(s).  They handle
; wildcards in any portion of the file specification.
;
; Modification History:
;
;-
	.ENABL	AMA
	.NLIST	BEX

	.MCALL	FDBDF$, FDAT$A, FDOP$A, FCSBT$, FDOFF$
	.MCALL	NBOF$L, IOERR$, FILIO$

	IOERR$				; DEFINE I/O ERROR CODES LOCALLY
	FILIO$				; DEFINE THE I/O FUNCTION CODES
	NBOF$L				; DEFINE FILE NAME BLOCK OFFSETS
	FCSBT$	DEF$L			; DEFINE FILE CONTROL STORAGE BITS
	FDOFF$	DEF$L			; DEFINE FILE DESCRIPTOR OFFSETS

	.SBTTL	LOCAL DEFINITIONS

	NB.SD1	=	400		; WILD CARD IN PROJECT #
	NB.SD2	=	1000		; WILD CARD IN PROGRAMMER #
	NB.SDI	=	NB.SD1!NB.SD2	; WILD CARD IN DIRECTORY

	HA.UAT	=	S.FATT*400+4	; WRITE USER ATTRIBUTE CODE

;
; Scratch storage for wild UIC logic consists of a file name block
; followed by the following extra words.
;
	N.WNM1	=	S.FNB		; 2 WORDS FOR RAD50 NON WILD CARD
					; PROJECT OR PROGRAMMER NAME
	N.WNM2	=	N.WNM1+4	; 5 WORDS OF STRING STORAGE FOR
					; ASCII FORM OF CURRENT DIRECTORY NAME
	S.WUIC	=	S.FNB+14.	; NO. OF BYTES IN SCRATCH AREA

	DIRTYP=<'D-100>*50*50+<<'I-100>*50>+<'R-100>	;.RAD50 DIR
	MFDNAM=<'0-22>*50*50+<<'0-22>*50>+<'0-22>	;.RAD50 000

TDRFDB:	FDBDF$				; TEMPORARY DIRECTORY FDB
	FDAT$A	R.FIX,,S.NFEN		; FIXED LENGTH RECORDS
	FDOP$A	,TDRNAM

ATTBLK:	.WORD	HA.UAT,TDRFDB,0

.TRLUN::.WORD	0			; TEMPORARY DIRECTORY (TRACE LUN)
					;   LUN FILLED IN BY TKB
TDRNAM:	.WORD	TDRDVS,TDRDVN,0,0,0,0	; DATASET DESCRIPTOR

TDRDVN:	.ASCII	/SY0/			; TEMPORARY DIRECTORY DEVICE
	TDRDVS=.-TDRDVN

	.EVEN

	.SBTTL	.WPARS - WILD CARD UIC PARSE
;+
;
; .WPARS - Wild card UIC parse.
;
;	Performs a normal call to .PARSE, and if a bad directory 
; indication is returned, attempts to parse and set up for wild UIC's
; if a successful indication is returned, the directory ID is set up
; pointing at the first directory to be used.
;
; Inputs:
;	R0 = File Descriptor Block (FDB).
;	R1 = File name block address.
;	R2 = File descriptor pointer.
;	R3 = Default file name block.
;	R4 = Addr of scratch area for wild UIC logic.
;
; Outputs:
;	C clear/set = success/failure.
;	All registers are preserved.
;
;-
.WPARS::
	MOV	#NB.SNM!NB.SVR,N.STAT(R4) ; WILDCARD NAME AND VERSION
	CALL	.PARSE			; TRY NORMAL PARSING
	BCC	20$			; IF CC, SUCCESSFUL
	CMPB	#IE.BDI,F.ERR(R0)	; BAD DIRECTORY NAME ?
	BNE	10$			; IF NE, NO (REPORT ERROR)

; See if wild card directory name.

	TST	N.DIRD(R2)		; NULL DIRECTORY DESCRIPTOR ?
	BEQ	10$			; IF EQ, YES (REPORT ERROR)
	CALL	PRSDIR			; NO, PARSE THE DIRECTORY
	BCS	20$			; IF CS, BAD DIRECTORY SYNTAX
	BIT	#NB.SDI,N.STAT(R4)	; WILD CARD IN DIRECTORY ?
	BEQ	10$			; IF EQ, NO

; It's a wild card directory name.

	MOV	#DIRTYP,N.FTYP(R4)	; SET FILE TYPE TO "DIR"
	CLR	N.NEXT(R4)		; NO NEXT FILE PROCESSING
	MOV	#-1,N.DID(R4)		; SHOW DOING FIND'S
	MOV	#-1,N.DID+2(R4)		;   IN MASTER FILE DIRECTORY
	CLR	N.DID+4(R4)		;
	MOV	N.DVNM(R1),N.DVNM(R4)	; COPY THE DEVICE NAME
	MOV	N.UNIT(R1),N.UNIT(R4)	;   AND THE UNIT NUMBER
	CALL	.NXDIR			; FIND THE NEXT DIRECTORY
	BCS	20$			; IF CS, ERROR OR IE.NSF
	CALL	.PARSE			; 
	MOV	N.STAT(R4),-(SP)	; COPY THE STATUS BITS
	BIC	#^C<NB.SDI>,@SP		; ISOLATE WILDCARD BITS
	BIS	(SP)+,N.STAT(R1) 	; SET BACK INTO FNB STATUS
	RETURN
10$:	SEC				; SHOW FAILURE
20$:	RETURN

	.SBTTL	.FNDNX - FIND THE NEXT FILE
;+
;
; .FNDNX - Find the next file.
;
;	Finds the next file in the current directory (even if wild card
; name, type and default version).  Optionally will cross to the next wild
; card directory if R2 non zero (and if wild card UIC's are present).
;
; Inputs:
;	R0 = FDB address.
;	R1 = File name block address.
;	R2 = Address of scratch block for UIC wild card logic.
;
; Outputs:
;	C clear/set = success/failure.
;	All registers are preserved.
;
;-
.FNDNX::
	TST	TDRFDB+F.FNB+N.DID	; IS SCRATCH DIRECTORY IN USE ?
	BNE	FNDNX1			; IF NE, YES
	CALL	.FIND			; TRY TO FIND NEXT FILE
	BCC	FNDNX2			; IF CC, FOUND ONE
	CMPB	F.ERR(R0),#IE.BAD	; CHECK FOR WILD CARD, DEFAULT VERSION
					; NOT SUPPORTED (OLD SYSTEM)
	BNE	FNDNX2			; IF NE, ITS NOT WILDCARD

; Handle the special case of wild card find of newest or oldest version.

FNDNX1:	TST	N.NEXT(R1)		; FIRST FILE IN CLASS ?
	BNE	10$			; IF NE, NO
	CALL	TDRINI			; YES, INIT TEMP DIRECTORY
	BCS	40$			; IF CS, IT FAILED
10$:	MOV	N.FVER(R1),-(SP)	; COPY THE VERSION NUMBER
20$:	MOV	N.STAT(R1),-(SP)	;   AND THE STATUS BITS
	BIS	#NB.SVR,N.STAT(R1)	; SHOW FIND ANY VERSION FIRST
	CALL	.FIND			; TRY TO FIND ONE
	BCS	60$			; IF CS, NO MORE FILES
	MOV	N.NEXT(R1),-(SP)	; SAVE CONTEXT FOR NEXT .FIND
	CLR	N.STAT(R1)		; CLEAR THE STATUS WORD
	CLR	N.NEXT(R1)		; AND THE CONTEXT
	MOV	4(SP),N.FVER(R1)	; SAVED FILE VERSION (0 OR -1)
	CALL	.FIND			; FIND NEWEST (OR OLDEST)
	BCS	50$			; IF CS, FAILED (SHOULDN'T HAPPEN)
	CALL	TDRENT			; HAVE WE ALREADY FOUND THIS ONE ?
	MOV	(SP)+,N.NEXT(R1)	; RESTORE CONTEXT
	MOV	(SP)+,N.STAT(R1)	;   AND THE STATUS WORD
	BCS	30$			; IF CS, FILE ALREADY FOUND
	TST	(SP)+			; POP THE SAVED VERSION
	BR	FNDNX3			; AND CONTINUE ...

; If duplicate error, we've seen this file before, don't "FIND" it again.

30$:	CMPB	#IE.DUP,TDRFDB+F.ERR	; DUPLICATION ERROR ?
	BEQ	20$			; IF EQ, YES (GO FIND ANOTHER)
	TST	(SP)+			; NO, CLEAN VERSION OFF STACK

; Error from init or enter in temporary directory.

40$:	MOVB	TDRFDB+F.ERR,F.ERR(R0)	; ERROR CODE FROM TEMPORARY FDB
	BR	80$			; AND SHOW FAILURE ...

; Couldn't find newest or oldest version.

50$:	MOV	(SP)+,N.NEXT(R1)	; RESTORE CONTEXT FOR .FIND
	BR	70$			; AND CONTINUE ...

; Failed to find next file in class, all done.

60$:	CALL	TDRDEL			; DELETE THE TEMPORARY DIRECTORY
70$:	MOV	(SP)+,N.STAT(R1)	; RESTORE THE STATUS WORD
	MOV	(SP)+,N.FVER(R1)	;   AND THE VERSION NUMBER
80$:	SEC				; SHOW FAILURE

FNDNX2:	BCC	FNDNX3			; IF CC, GOT A FILE NAME
	TST	R2			; ALLOWED TO CROSS DIRECTORIES ?
	BEQ	10$			; IF EQ, NO (FAILURE)
	BIT	#NB.SDI,N.STAT(R1)	; ANY WILD UIC'S
	BEQ	10$			; IF EQ, NO (FAILURE)
	CMPB	#IE.NSF,F.ERR(R0)	; IS ERROR "NO SUCH FILE" ?
	BNE	10$			; IF NE, NO (UNEXPECTED ERROR)
	MOV	R3,-(SP)		; SAVE R3
	MOV	R4,-(SP)		;   AND R4
	MOV	R2,R4			; COPY SCRATCH BLOCK ADDRESS
	MOV	F.DSPT(R0),R2		; SET FILE DESCRIPTOR
	MOV	F.DFNB(R0),R3		; SET DEFAULT NAME BLOCK
	CALL	.NXDIR			; FIND THE NEXT DIRECTORY
	MOV	R4,R2			; RESTORE SCRATCH BLOCK ADDRESS
	MOV	(SP)+,R4		;  AND THE
	MOV	(SP)+,R3		;    REGISTERS
	BCC	.FNDNX			; IF CC, FOUND NEW DIRECTORY
10$:	SEC				; ELSE SHOW FAILURE
FNDNX3:	RETURN

	.SBTTL	.NXDIR - FIND NEXT WILD CARD DIRECTORY
;+
;
; .NXDIR - Find next wild card directory.
;
;	Finds the next directory that meets the wild card criteria
; if only the project # was wild, then the prog names must match and
; vice-versa.  Directory names of more than 6 chars will not satisfy
; the match, and likewise, any name beginning with 000 (RAD50) will
; also not match.  This means the MFD will not be found.
;
;	When a directory is found, it's ID is placed in the directory
; ID slot in the file name block.  Also the directory string is generated
; and pointed to by F.DSPT if present, or the directory ID is put into
; the default name block if it is present.
;
; Inputs:
;	R0 = FDB address.
;	R1 = File name block address.
;	R2 = File descriptor pointer.
;	R3 = Default file name block.
;	R4 = Addr of scratch area for wild UIC logic.
;
; Outputs:
;	C clear/set = success/failure.
;	All registers are preserved.
;
;-
.NXDIR::
	BIT	#NB.SDI,N.STAT(R4)	; WILD CARD UIC'S ?
	BEQ	50$			; IF EQ, NO (NO SUCH FILE)
	CALL	$SAVAL			; SAVE ALL REGISTERS
10$:	MOV	R1,-(SP)		; SAVE FILE NAME BLOCK
	MOV	R4,R1			; SET SCRATCH AREA ADDRESS
	CALL	.FIND			; FIND THE NEXT DIRECTORY
	MOV	(SP)+,R1		; RESTORE THE FNB
	BCS	60$			; IF CS, NO MORE DIRECTORYS

; Found one, see if it matches our requirements.

	CMP	#MFDNAM,N.FNAM(R4)	; IS THIS THE MFD ?
	BEQ	10$			; IE EQ, YES (SKIP IT)
	TST	N.FNAM+4(R4)		; IS DIRECORY NAME TOO BIG ?
	BNE	10$			; IF NE, YES (ONLY 6 ALLOWED)

; Match PROJ or PROG name if necessary.

	BIT	#NB.SD1,N.STAT(R4)	; WILD CARD PROJECT # ?
	BNE	20$			; IF NE, YES
	CMP	N.WNM1(R4),N.FNAM(R4)	; IS THIS THE PROJECT # ?
	BNE	10$			; IF NE, NO (TRY NEXT)
20$:	BIT	#NB.SD2,N.STAT(R4)	; WILD CARD PROGRAMMER # ?
	BNE	30$			; IF NE, YES
	CMP	N.WNM1+2(R4),N.FNAM+2(R4) ; IS THIS THE PROGRAMMER # ?
	BNE	10$			; IF NE, NO (TRY NEXT)

; Found a directory match.

30$:	MOV	N.FID(R4),N.DID(R1)	; COPY THE
	MOV	N.FID+2(R4),N.DID+2(R1)	;   FILE
	MOV	N.FID+4(R4),N.DID+4(R1)	;     ID
	CLR	N.NEXT(R1)		; START AT BEGINNING OF DIRECTORY

; Set up string with directory name, and point to it from the file
; descriptor pointer.

	MOV	R2,R5			; SAVE THE FILE DECRIPTOR POINTER
	BEQ	40$			; IF EQ, THERE IS NONE
	MOV	R4,R0			; COPY SCRATCH AREA
	ADD	#N.WNM2,R0		; POINT TO STRING AREA
	MOV	N.FNAM(R4),R1		; COPY 1ST RAD50 FILE NAME WORD
	CALL	C5TB			; CONVERT RAD50 TO BINARY
	MOV	R1,-(SP)		; SAVE THE PROJECT #
	MOV	N.FNAM+2(R4),R1		; COPY 2ND RAD50 FILE NAME WORD
	CALL	C5TB			; AND CONVERT IT TO BINARY
	CLR	R3			; INITIALIZE THE PPN
	BISB	(SP)+,R3		; COPY THE PROJECT #
	SWAB	R3			; PUT IT IN THE HIGH BYTE
	BISB	R1,R3			; COMPLETE PPN; .BYTE PROG#,PROJ#
	MOV	R0,R2			; SCRATCH AREA STRING ADDRESS
	CLR	R4			; ZERO SUPPRESS, INSERT SEPARATORS
	CALL	.PPASC			; CONVERT PPN TO ASCII STRING
	MOV	R0,N.DIRD+2(R5)		; R5=F.DSPT, STORE STRING ADDRESS
	SUB	R0,R2			; CALCULATE DIRECTORY STRING SIZE
	MOV	R2,N.DIRD(R5)		; AND STORE IT IN F.DSPT
	BR	60$			; USE COMMON RETURN ...

; Set directory ID in default name block, since there was no file
; descriptor pointer to put a string in.

40$:	TST	R3			; IS THERE A DEFAULT FNB ?
	BEQ	60$			; IF EQ, NO
	MOV	N.FID(R4),N.DID(R3)	; YES, STORE
	MOV	N.FID+2(R4),N.DID+2(R3)	;   THE FILE
	MOV	N.FID+4(R4),N.DID+4(R3)	;     ID THERE
	BR	60$			; AND RETURN ...

50$:	MOVB	#IE.NSF,F.ERR(R0)	; SET "No such file" ERROR
	SEC				; SHOW FAILURE

60$:	RETURN

	.SBTTL	.WLDVC - CHECK FOR WILD CARDS WITH DEFAULT VERSION
;+
;
; .WLDVC - Check for wild cards with default version.
;
; Inputs:
;	R0 = FDB address.
;	R1 = File name block.
;
; Outputs:
;	C=1 if wild name or type, and default version.
;	C=0 if not wild card.
;	All registers are preserved.
;
;-
.WLDVC::
	BIT	#NB.SNM!NB.STP,N.STAT(R1) ; WILDCARD NAME OR TYPE ?
	BEQ	20$			; IF EQ, NO
	BIT	#NB.SVR,N.STAT(R1)	; IS THERE A WILD VERSION ?
	BNE	20$			; IF NE, YES
	TST	N.FVER(R1)		; EXPLICIT VERSION ?
	BEQ	10$			; IF EQ, NO (WILDCARD)
	CMP	#-1,N.FVER(R1)		; SET FOR OLDEST VERSION
	BNE	20$			; AND CONTINUE ...

10$:	SEC				; SHOW WILDCARD
	RETURN

20$:	CLC				; SHOW NOT WILDCARD
	RETURN

	.SBTTL	PRSDIR - PARSE THE DIRECTORY STRING
;+
;
; PRSDIR - Parse the directory string, allowing wild card UIC's.
;
;	Sets up the status word (N.STAT) in the FNB of the scratch
; area with the appropriate wild card UIC bits, and stores the explicit
; project name (RAD50) and programer name in N.WNM1, N.WNM1+2 (R4).
;
; Inputs:
;	R0 = FDB address.
;	R1 = File name block address.
;	R2 = File descriptor pointer.
;	R3 = Default file name block.
;	R4 = Scratch area to be initialized with wild card
;		UIC information.
;
; Outputs:
;	C clear/set = success/failure (syntax error in directory).
;	All registers are preserved.
;
;-
PRSDIR:	CALL	$SAVAL			; SAVE ALL REGISTERS
	MOV	R4,-(SP)		; COPY SCRATCH AREA ADDRESS
	MOV	R4,R1			; SET FILE NAME BLOCK ADDRESS
	ADD	#N.WNM1,R1		; POINT TO RAD50 PPN STORAGE AREA
	CALL	PRSUI1			; CONVERT & STORE PROJECT #
	MOV	(SP)+,R4		; RESTORE SCRATCH AREA
	BCS	30$			; IF CS, SYNTAX ERROR
	MOV	-(R3),R1		; SAVE THE PROJECT #
	MOV	R4,R0			; COPY SCRATCH AREA ADDRESS
	ADD	#N.WNM2,R0		; POINT TO ASCII PPN STORAGE AREA
	CALL	CDRNM			; CONVERT NUMBER TO RAD50  (1 WORD)
	MOV	R1,(R3)+		; STORE RAD50 BACK IN N.WNM1(R4)
	BCC	10$			; IF CC, SUCCESS

; Check for wildcard in project or programmer numbers.

	CMP	#-1,R1			; WAS THERE A WILDCARD ?
	BNE	30$			; IF NE, NO (SYNTAX ERROR)
	BIS	#NB.SD1,N.STAT(R4)	; SET WILD PROJECT #
10$:	MOV	@R3,R1			; COPY THE PROGRAMMER #
	MOV	R4,R0			; RESTORE SCRATCH AREA
	ADD	#N.WNM2,R0		; POINT TO ASCII PPN STORAGE AREA
	CALL	CDRNM			; CONVERT TO OCTAL ASCII
	MOV	R1,@R3			; STORE THE RAD50
	BCC	20$			; IF CC, SUCCESS
	CMP	#-1,R1			; WAS THERE A WILDCARD ?
	BNE	30$			; IF NE, NO (SYNTAX ERROR)
	BIS	#NB.SD2,N.STAT(R4)	; SET WILD CARD PROGRAMMER #
20$:	CLC				; SHOW SUCCESS
	RETURN
30$:	SEC				; SHOW SYNTAX ERROR
	RETURN

	.SBTTL	.PRSUI - PARSE UIC STRING INTO BINARY WORDS
;+
;
; .PRSUI - Parse UIC string into binary PROJ and PROG numbers (2 words).
;
; Inputs:
;	R1 = Address of 2 word block to store PPN.
;	R2 = File descriptor pointer.
;
; Outputs:
;	C clear/set = success/failure (syntax error).
;	All registers are preserved.
;	@R1 = Project # or -1 if *
;	2(R1) = Programmer # or -1 if *
;
; Alternate entry:
;	CALL	PRSUI1
;
; Inputs:
;	Same.
;
; Outputs:
;	Same except registers not preserved.
;	R3 = Address of programmer # (2nd word).
;	R0 preserved, R2,R4,R5 altered.
;
;-
.PRSUI::
	JSR	R5,.SAVR1		; SAVE R1 - R5

PRSUI1:	MOV	R1,R3			; R3=ADR TO RETURN PROJECT #
	MOV	N.DIRD(R2),R1		; R1=SIZE OF DIRECTORY STRING
	MOV	N.DIRD+2(R2),R2		; R2=ADDRESS OF DIRECOTRY STRING
	CMPB	#'[,(R2)+		; REQUIRE LEADING "["
	BNE	30$			; IF NE, SYNTAX ERROR
	DEC	R1			; COUNT THE "["
	CMPB	#'*,(R2)		; IS THIS A WILDCARD ?
	BNE	10$			; IF NE, NO
	CMPB	#'],1(R2)		; IS IT OF THE FORM [*] ?
	BEQ	40$			; IF EQ, YES (ALLOW THIS)
10$:	MOV	#',,R4			; R4=TERMINATOR CHARACTER
	CALL	SCNCVT			; CONVERT PROJECT #
	BCS	20$			; IF CS, BAD SYNTAX
	TST	(R3)+			; R3= ADDRESS TO STORE PROG #
	MOV	#'],R4			; R4=TERMINATING CHAR
	CALL	SCNCVT			; CONVERT PROGRAMMER #
20$:	RETURN

30$:	SEC				; SHOW SYNTAX ERROR
	RETURN

40$:	MOV	#-1,(R3)		; SET WILDCARD PROJECT #
	MOV	(R3)+,(R3)		;  AND WILDCARD PROGRAMMER #
	CLC				; SHOW SUCCESS
	RETURN

	.SBTTL	SCNCVT - SCAN ASCII STRING FOR TERMINATOR
;+
;
; SCNCVT - Scan ASCII string for terminating character.
;
; Convert to number or -1 if wild card, return @R3.
;
; Inputs:
;	R1 = String size.
;	R2 = String address.
;	R3 = Address to return value.
;	R4 = Terminating character to match.
;
; Outputs:
;	C clear/set = success/failure (syntax error).
;	R1 and R2 are updated to reflect characters scanned.
;	R4 are R5 altered.
;	R0 and R3 are preserved.
;
;-
SCNCVT:	MOV	R2,R5			; SAVE STARTING ADDRESS

10$:	CMPB	R4,(R2)+		; FIND TERMINATOR ?
	BEQ	20$			; IF EQ, YES
	SOB	R1,10$			; LOOP TO END OF STRING
	SEC				; SHOW BAD SYNTAX
	RETURN

20$:	DEC	R1			; COUNT TERMINATOR
	CMPB	#'*,@R5			; IS THERE A WILD CARD ?
	BNE	30$			; IF NE, NO
	MOV	#-1,@R3			; YES, SHOW WILDCARD DETECTED
	CLC				; AND SHOW SUCCESS
	RETURN

30$:	MOV	R2,R4			; COPY UPDATED ADDRESS
	SUB	R5,R4			; CALCULATE THE BYTE COUNT
	DEC	R4			; ADJUST THE COUNT
	CALL	.ODCVT			;
	RETURN

	.SBTTL	CDRNM - CONVERT PPN TO RAD50 NAME
;+
;
; CDRNM - Convert Project or Programmer number to RAD50 name.
;
; Inputs:
;	R0 = String address to store chars in (scratch).
;	R1 = Number to convert.
;
; Outputs:
;	C=0 if converted, C=1 if high byte of R1 non zero.
;	R1 = RAD50 conversion of number.
;	R0 are R2 altered.
;	R3, R4, and R5 are preserved.
;
;-
CDRNM:	BIT	#177400,R1		; HIGH BYTE NON-ZERO ?
	BEQ	10$			; IF EQ, NO (CONTINUE)
	SEC				; YES, SHOW THEY WERE
	RETURN

10$:	MOV	PC,R2			; DON'T SUPPRESS LEADING ZEROS
	CALL	$CBOMG			; CONVERT BINARY TO OCTAL MAGNITUDE
	SUB	#3,R0			; POINT TO START OF ASCII STRING
	CALL	$CAT5			; CONVERT ASCII TO RAD50
	CLC				; SHOW SUCCESS
	RETURN

	.SBTTL	C5TA - CONVERT RAD50 TO BINARY VALUE
;+
;
; C5TA - Convert RAD50 to binary value.
;
; Inputs:
;	R0 = String address (scratch).
;	R1 = RAD50 value to convert.
;
; Outputs:
;	R1 = Binary value.
;	R0, R3, R4, and R5 preserved.
;	R2 is altered.
;
;-
C5TB:	MOV	R0,-(SP)		; SAVE R0
	CALL	$C5TA			; CONVERT RAD50 TO ASCII
	CLRB	@R0			; INITIALIZE OUTPUT BUFFER
	SUB	#3,R0			; POINT TO START OF STRING
	CALL	$COTB			; CONVERT OCTAL TO BINARY
	MOV	(SP)+,R0		; RESTORE R0
	RETURN

	.SBTTL	TMPDIR - TEMPORARY DIRECTORY LOGIC

	.SBTTL	TDRINI - INITIALIZE THE TEMPORARY DIRECTORY
;+
;
; TDRINI - Initialize the temporary directory.
;
; This routine will first delete the old temporary directory if it
; exists, and then create a new temporary directory.
;
; Outputs:
;	C clear/set = success/failure.
;	All registers are preserved.
;
;-
TDRINI:	CALL	TDRDEL			; DELETE / INIT TEMP DIRECTORY
	BCS	10$			; IF CS, FAILURE
	CALL	$SAVAL			; SAVE ALL REGISTERS
	CLR	-(SP)			;
	MOV	#ATTBLK,-(SP)		; ATTRIBUTE BLOCK ADDRESS
	MOV	#TDRFDB+F.FNB+N.DID,-(SP) ; ADDRESS OF DIRECTORY ID
	MOV	#TDRFDB,R0		; ADDRESS OF THE FDB
	MOV	#IO.CRE,R1		; SET FUNCTION TO CREATE
	MOV	#3,R2			; # OF OPTIONAL PARAMETERS
	MOV	SP,R3			; ADDRESS OF QIO PARAMETERS
	CALL	.XQIO			; CREATE THE FILE
	MOV	(SP)+,R1		; CLEAN UP THE STACK
	MOV	(SP)+,R1		;   USING MOVES TO
	MOV	(SP)+,R1		;     PRESERVE CARRY
10$:	RETURN

	.SBTTL	TDRDEL - DELETE THE TEMPORARY DIRECTORY
;+
;
; TDRDEL - Delete the temporary directory file.
;
; This routine deletes the temporary directory file if it exists
; and initialize the FDB in preparation for creating a new one,
;
; Outputs:
;	C clear/set = success/failure.
;	All registers are preserved.
;
;-
TDRDEL:	CALL	$SAVAL			; SAVE ALL REGISTERS
	MOV	#TDRFDB,R0		; ADDRESS OF TEMPORARY FDB
	MOVB	.TRLUN,F.LUN(R0)	; FILL IN THE LOGICAL UNIT #
	TST	F.FNB+N.DID(R0)		; IS THE DIRECTORY ID IS SET ?
	BEQ	10$			; IF EQ, NO (DOESN'T EXIST)

; Mark the file for delete.

	MOV	#TDRFDB+F.FNB+N.DID,-(SP) ; ADDRESS OF FILE ID
	MOV	#IO.DEL,R1		; SET FUNCTION TO DELETE
	MOV	#1,R2			; # OF QIO PARAMETERS
	MOV	SP,R3			; ADDRESS OF PARAMETERS
	CALL	.XQIO			; DO THE DELETE
	MOV	(SP)+,R1		; CLEAN UP THE STACK
10$:	ROL	R2			; SAVE THE CARRY BIT
	TST	F.DVNM(R0)		; IS THE FDB INITED ?
	BNE	20$			; IF NE, YES (DEVICE NAME IS SET)
	MOV	#1,F.EFBK+2(R0)		; INIT END OF FILE BLOCK
	MOV	#TDRFDB+F.FNB,R1	; SET FNB ADDRESS
	MOV	#TDRNAM,R2		; DEVICE, DIR, & NAME DESCRIPTORS
	CLR	R3			; NO DEFAULT FILE NAME BLOCK
	CALL	.PRSDV			; PARSE THE DIRECTORY NAME
	BCS	30$			; IF CS, F.ERR = ERROR
20$:	CLR	F.FNB+N.DID(R0)		; CLEAR THE DIRECTORY ID
	ROR	R2			; RESTORE THE CARRY BIT
30$:	RETURN

	.SBTTL	TDRENT - ENTER FILE IN TEMPORARY DIRECTORY
;+
;
; TDRENT - Enter file in temporary directory.
;
; Inputs:
;	R1 = FNB of entry to make.
;
; Outputs:
;	C clear/set = success/failure.
;	All registers are preserved.
;
;-
TDRENT:	CALL	$SAVAL			; SAVE ALL REGISTERS
	MOV	#TDRFDB+F.FNB,R2	; COPY ADDRESS OF FNB
	MOV	#S.NFEN/2,R3		; SIZE OF FILE NAME BLOCK
10$:	MOV	(R1)+,(R2)+		; COPY TO TEMPORARY FNB
	SOB	R3,10$			; AND LOOP TILL DONE
	MOV	#TDRFDB,R0		; ADDRESS OF FDB
	MOVB	.TRLUN,F.LUN(R0)	; FILL IN THE LUN
	MOV	#TDRFDB+F.FNB,R1	; ADDRESS OF FNB
	CALL	.ENTER			; TRY TO ENTER FILE
	RETURN				; RETURN C CLEAR/SET

	.END
