C	PROGRAM TO REPORT CONTENTS OF TTYLOG DATA FILE
C
C	VERSION TO REPORT ON ONE TERMINAL ONLY, REPORT IN HISTOGRAM
C	STYLE AVERAGED OVER SEVERAL DAYS
C
	INTEGER*2 REPTIM(8),RUNTIM(40),SWATIM(40),WAITIM(40),REP(24)
	DIMENSION RUN(24),SWA(24),WAI(24)
	CHARACTER*46 BARGRA,BAR
	CHARACTER*42 NAME
C	CONTENTS OF TTYLOG DAT FILE
C       FIRST RECORD = 8-WORD GTIM$ RETURN, (YR,MO,DA,HR,MIN,SEC,TIC,TPS)
C       FOLLOWED BY 40. WORD RUN-TIME COUNTER,
C       SECOND RECORD = 40. WORD SWAP TIME COUNTER, 40.WORD WAIT TIME COUNTER
C
	BAR(1:46)='!....!....!....!....!....!....!....!....!....!'
	DAYS=0.
	OPEN (UNIT=3,NAME='LB:[1,100]TTYLOG.DAT',ERR=1000,
	1 STATUS='OLD',ACCESS='SEQUENTIAL',FORM='UNFORMATTED',
	2 RECORDTYPE='VARIABLE')
C
C	INPUT REPORT TIME LIMITS
C
        WRITE (5,100)
  100	FORMAT ('$START DATE (MO,DA,YR) ')
	READ (5,110) IMO,IDA,IYR
  110	FORMAT(3I8)
        WRITE (5,115)
  115	FORMAT ('$STOP  DATE (MO,DA,YR) ')
	READ (5,110) JMO,JDA,JYR
	WRITE(5,120)
  120	FORMAT ('$TERMINAL NUMBER (OCT) ')
	READ (5,125) ITI
  125	FORMAT(O6)
C
C	GET USER NAME AND LOCATION
C
	OPEN (UNIT=4,NAME='LB:[1,100]LOGTTY.DAT',ERR=129,
	1 STATUS='OLD',ACCESS='SEQUENTIAL',
	2 RECORDTYPE='VARIABLE')
 126	READ(4,127,END=128) JJ,NAME(1:42)
 127	FORMAT(O2,1X,A42)
	IF (ITI.EQ.JJ) GOTO 129
	GOTO 126
 128	NAME(1:42)='                                          '
 129	CLOSE(4)
C
C	START READING FILE
C
  130	READ (3,END=1000) (REPTIM(I),I=1,8),(RUNTIM(I),I=1,40)
	READ (3) (SWATIM(I),I=1,40),(WAITIM(I),I=1,40)
	IF (REPTIM(1).LT.IYR) GOTO 130
	IF (REPTIM(1).GT.JYR) GOTO 1000
	IF (REPTIM(2).LT.IMO) GOTO 130
	IF (REPTIM(2).GT.JMO) GOTO 1000
	IF (REPTIM(3).LT.IDA) GOTO 130
	IF (REPTIM(3).GT.JDA) GOTO 1000
C
C	FOUND ONE WANTED, ADD IT TO TOTALS
	J=REPTIM(4)
	REP(J)=J
	IF(J.NE.8) GOTO 140
C
C	FIRST REPORT FOR A DAY
C
	DAYS=DAYS+1.
	PRERUN=0.
	PRESWA=0.
	PREWAI=0.
 140	RUN(J)=RUN(J)+FLOAT(RUNTIM(ITI))-PRERUN
	PRERUN=FLOAT(RUNTIM(ITI))
	SWA(J)=SWA(J)+FLOAT(SWATIM(ITI))-PRESWA
	PRESWA=FLOAT(SWATIM(ITI))
	WAI(J)=WAI(J)+FLOAT(WAITIM(ITI))-PREWAI
	PREWAI=FLOAT(WAITIM(ITI))
	GOTO 130
C
C	IF DONE, DO HISTOGRAM REPORT
C
 1000	WRITE(6,200) ITI, IMO,IDA,IYR,JMO,JDA,JYR,NAME(1:42)
  200	FORMAT(/,' FOR TT',O2,' FOR ',I2,'/',I2,'/',I2,
	1 ' TO ',I2,'/',I2,'/',I2,1X,A42)
	WRITE(6,210)
  210	FORMAT(' TIME   RUN     SWAP    WAIT   0   05   10',
	1 '   15   20   25   30   35   40   45')
	WRITE(6,220)
  220	FORMAT(' ----  ------  ------  ------  ')
	DO 500 I=1,24
	IF (REP(I).EQ.0) GOTO 500
	BARGRA(1:46)=BAR(1:46)
	FRUN=RUN(I)/(DAYS*10.)
	IRUN=IMIN0(45,IFIX(FRUN))+1
	BARGRA(IRUN:IRUN)='R'
	FSWA=SWA(I)/(DAYS*10.)
	ISWA=IMIN0(45,IFIX(FSWA))+1
	BARGRA(ISWA:ISWA)='S'
	FWAI=WAI(I)/(DAYS*10.)
	IWAI=IMIN0(45,IFIX(FWAI))+1
	BARGRA(IWAI:IWAI)='W'
	WRITE(6,250) I,FRUN,FSWA,FWAI,BARGRA(1:46)
  250	FORMAT(I4,'   ',3(F6.1,'  '),A46)
	IF (I.NE.18) WRITE(6,251)
  251	FORMAT(' ')
  500	CONTINUE
	CLOSE (3)
	CALL EXIT
	END
