
#include	"sysdef.h"

/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/
/*	The information in this  software  is  subject  to	*/
/*	change  without notice and should not be construed	*/
/*	as a commitment by the author.				*/
/*								*/
/*								*/

#include	"scerrd.h"
#include	"tempio.h"

#define	CR	015
#define	LF	012


/*	Define the mechanism for indexing into the window pointers	*/
/*	First, the fast way for virtual 32 bit systems like VMS.	*/
/*	See TEMPIO.C for details					*/

#if	VAXVMS
#define	_gworkpt(offset) workpt+offset
#endif

#if	RSX
extern struct tempindex *mapwin() ;
#define	_gworkpt mapwin
#endif




/*	Insert lines into the work file
	If input is from a file, it's assumed that INPLUN is
	the correct  LUN and that  the file has already been
	opened.
	Routine  is exited when EOF (or any other error) has
	occurred.
*/
	
cinsert(lun)
int lun ;
{
	extern struct	tempindex  *workpt ;
	extern struct	textline   inline ;
	extern int	curbucket[],curmode[],linecount[],*maxline ;
	extern int	lowlim,highlim,w ;
	int		lineno,save1,save2,status ;
	register char	*cp,*oldcp ;
	register int	curlen,i ;


	findline(1) ;
	linecount[w] = 0 ;
	save1 = findline( lowlim ) ;
	curmode[w] = ST_INSERT ;
	save2 = (_gworkpt(curbucket[w]))->lcount ;
	saveline( 0,save1 ) ;
	if ( lun == kb_lun ) then xprintf("Type control Z to exit\n");
	status = sys_normal ;
	lineno = lowlim ;
	while ( status == sys_normal ) {

	  if (testcc() == true) then break ;
	  if (lun == kb_lun) then xprintf("%6d )",lineno++) ;
	  status = getline(lun,inline.c,&inline.len);
	  if (status != sys_normal) then break ;
	  curlen = 0 ;
	  cp = inline.c ;
	  oldcp = cp ;
	  for (i=inline.len; i>0; i--)
		if (*cp++ == LF)
		  then	{
			ins_line(oldcp,++curlen) ;
			curlen = 0 ;
			oldcp = cp ;
			(*maxline)++ ;
			}
		  else	curlen++ ;
	  if ( curlen )
	    then {
		 ins_line( oldcp,curlen ) ;
		 (*maxline)++ ;
		 }
	}
	saveline( save1,save2 ) ;
	ins_lnks() ;
}
	  

cadd(lun)
int lun ;
{
	extern int lowlim,*maxline ;

	lowlim = *maxline ;
	cinsert(lun) ;
}



cchange(lun)
int lun ;
{
	extern int lowlim,highlim ;
	register int status ;

	status = sys_normal ;
	if ( checkdelete() )
	  then	{
		if ( (status=delblock(lowlim,highlim)) != 0 ) ;
		  then status = cinsert(lun) ;
		}
	return( status ) ;
}


cdelete(lun)
int lun ;
{
	extern int kblun,filopen,lowlim,highlim,*maxline ;
	register int status ;
	extern struct	textline *textpointer() ;
	register struct	textline *tp ;

	status = sys_normal ;
	if ( checkdelete() )
	  then	{
		if ( lun != kblun ) then clist(lun) ;
		status = delblock(lowlim,highlim) ;
		}
	return( status ) ;
}


cundel()
{
	extern int lowlim ;

	undelline(lowlim) ;
}





delblock(low,high)
int low,high;
{
	register int i,status ;

	for (i=low; i <= high && (status=delline(low)) == true; i++);
	return(status) ;
}


delline(linenumber)
int linenumber ;
{
	extern struct	textline *textpointer() ;
	register struct	textline *tp ;
	extern struct	deltype   lastdeleted ;
	extern struct	textwindow *windpt ;
	extern int	curmode[],*maxline,read_only,w ;
	register char	*cp, *dp ;
	register int	*lenp ;
	int		i,temp ;

	if ( read_only ) then return(0) ;
	if ( *maxline == 2 )
	  then	{
		tp = textpointer(1) ;
		tp->len = 2 ;
		tp->c[0] = CR ;
		tp->c[1] = LF ;
		txtmod() ;
		return(1) ;
		}
	if ( linenumber >= 1 && linenumber < *maxline && *maxline > 2 )
	  then	{
		if ( curmode[w] != ST_UPDATE ) curmode[w] = ST_DELETING ;
		temp = findline(linenumber);
		dp = lastdeleted.lastline.c ;
		cp = windpt->lines[temp].c ;
		lenp = &windpt->lines[temp].len ;
		lastdeleted.lastline.len = 0 ;
		lastdeleted.lastline.partial = 0 ;
		for (i=0; i < (*lenp) && isdelimiter(*cp)==0 ; i++) {
			*dp++ = *cp++ ;
			lastdeleted.lastline.len++ ;
			}			
		*lenp = 0 ;		
		curmode[w] = ST_UPDATE ;
		putback() ;
		(*maxline)-- ;
		return(true) ;
		}
	  else	return(false) ;
}

undelline(lineno)
int lineno ;
{
	extern struct	deltype   lastdeleted ;
	register int size ;

	size = lastdeleted.lastline.len ;
	lastdeleted.lastline.c[size++] = CR ;
	lastdeleted.lastline.c[size++] = LF ;
	return( doinsert(lineno,lastdeleted.lastline.c,size) ) ;
}

doinsert(lineno,s,len)
char *s ;
int len ;
int lineno ;
{
	extern int	curbucket[],curmode[],linecount[],*maxline,w ;
	register int	save1,save2 ;
	extern struct	tempindex *workpt ;

	if ( lineno < 1 || lineno > *maxline ) then return(0) ;
	linecount[w] = 0 ;
	save1 = findline( lineno ) ;
	curmode[w] = ST_INSERT ;
	save2 = (_gworkpt(curbucket[w]))->lcount ;
	saveline( 0,save1 ) ;
	ins_line( s,len ) ;
	(*maxline)++ ;
	saveline( save1,save2 ) ;
	ins_lnks() ;
	return(1) ;
}





clist(lun)
{
	extern int lowlim,highlim ;
	listlines(lowlim,highlim,lun) ;
}

listlines(low,high,lun)
int low,high,lun;
{
	extern int p_lines,sts_one ;
	extern struct textline *textpointer();
	struct textline *tp ;
	register int i,status ;

	enabuffering() ;
	status = 1 ;
	for (i=low; i <=high ; i++) {
		if ( (sts_one & ed_end) == 0 )
		  then
		    if ( testcc() )
			then	{
				status = 0 ;
				break ;
				}
		if (p_lines && lun == kb_lun) then plinenumber(i) ;
		tp = textpointer(i) ;
		if ( (status = putline(lun,tp->c,tp->len)) == 0 ) then break ;
		}
	disbuffering() ;
	return(status) ;
}


static checkdelete()
{
	extern int lowlim,highlim,*maxline ;
	register int junk ;

	if ( highlim-lowlim > 15 )
	  then	{
		junk = getyesno("Really delete that many lines <NO> ? ","N") ;
		if ( junk == 1 )
		  then return(1) ;
		  else return(0) ;
		}
	  else return(1) ;
}		
