/*)BUILD
	$(PROGRAM)	= PHELP
	$(TKBOPTIONS) = {
		STACK=2000
		TASK=...PHE
		UNITS=16
		ACTFIL=16
		ASG=LB:1:2:3:4:5
		ASG=LB:6:7:8:9:10
		ASG=LB:11:12:13:14:15
		ASG=LB:16
		}
	$(LIBS) = {
		LB:[300,23]TGBCLIB/LB,LB:[1,1]CU/LB
		}
*/



/*
 *			PHELP
 *
 *	This program makes pretty help files from the system help files.
 *
 */
#include <stdio.h>

#define TERMINATORS "\12\13\14"

char *outfile;		/* output file-name */
char header[132];	/* subject title */
char *title[9];		/* char **'s to various levels in header */
int pplvl,plvl,clvl;	/* current, previous, and pre-previos level numbers */
char acnt[10];		/* global account */
int fcount=0;		/* keeps count of the number of files processed */
int lincou=0;		/* keeps track of the line number */
FILE *ofp;		/* output file descriptor */
int lflag=0;		/* flag to indicate a listing */
int fpage=0;		/* first page */
int lpage=0;		/* last page */
int page=0;		/* current page */
char docname[20];	/* document name (supplied by user) */
int cflag=0;		/* continue on file not found */
int plevel=1;		/* level to page at */
int sflag=1;		/* perforation skip flag (defult - yes) */

main(argc,argv)
int argc;
char **argv;
{
	int b,i;
	char *bb;

	/* if not enough arguments then error() */
	if (argc < 3) {
		fprintf(stderr,"\nPHELP: error - invalid command line\n");
		error("Format: PHELP <infile> <outfile>\n");
	}

	/* assign outfile, and get document name */
	toups(argv[1]);
	outfile=argv[1];
	b=inchr(outfile,']')+1;
	if ((i=inchr(outfile,'.'))==-1)
		i=strlen(outfile);
	strncpy(docname,outfile+b,(i-b)+1);

	/* if can't oen output file then error() */
	if (!(ofp = fopen(argv[2],"w")))
		error("\nPHELP: Can't open output file\n");

	/* if an account specified, then rember it */
	if ((b=inchr(argv[1],']'))!=-1)
		strncpy(acnt,argv[1],b+1);

	/* check for any flags */
	if (argc>3) {
		for (i=3 ; i<argc ; i++) {


			for(bb=argv[i] ; (bb=index(bb,'-')) ; ) {
				bb++;
				printf("DBG 2>bb<%o>\n",bb);
				switch(*(bb)) {
					case 'l': lflag=1;
						  break;
					case 'f': fpage=atoi(bb+1);
						  break;
					case 'e': lpage=atoi(bb+1);
						  break;
					case 's': sflag=0;
						  break;
					case 'p': plevel=atoi(bb+1);
						  break;
					case 'c': cflag=1;
						  break;
					default : fprintf(stderr,"\nPHELP: bad switch specification <%s>\n",argv[i]);
						  exit();
						  break;
				}
			}
		}
	}

	title[1]=title[2]=title[3]=header;			/* set up the first few header pointers */
	lincou=1;					/* assume top of page */
	newpage();						/* top of page */
	pplvl=plvl=clvl=1;					/* initialize level numbers */
	process(argv[1]);       				/* go off & throw it at the output */
	fclose(ofp);						/* close the output file */
	fprintf(stderr,"\nPHELP: Finished - %d files processed\n",fcount);
} /* end of main */




process(infile)
char *infile;
{
	FILE *ifp;
	char line[133];
	int findcr;
	int fgetflg;

#ifdef debug
	puts("DBG 1> process()\n");
#endif
	/* open the input file - if cant do that then try appending other garbage
	   to get a better file name */
	if ((findcr=inchr(infile,'\n'))!=-1)		/* get rid of any cr's */
		*(infile+findcr)=0;
	if (!(ifp = fopen(infile,"r"))) {		/* if cant open the file then add a .hlp to it */
		if (inchr(infile,'.')==-1)
			strcat(infile,".HLP");
		if (!(ifp=fopen(infile,"r"))) {		/* if still can't open the file then add an account number */
			if (inchr(infile,'[')==-1) {
				strcpy(line,acnt);
				strcat(line,infile);
				strcpy(infile,line);
			}
			if(!(ifp = fopen(infile,"r"))) {		/* this is if cflag specified. */
				if (cflag) {
					printf("PHELP: Can't open input file <%s> -- Skipping\n",infile);
					fputs("see ",ofp);
					linout(infile);
					return(0);
				} else {
					error("\nPHELP: Can't open input file <%s>\n",infile);
				}
			}
		}
	}
	printf("PHELP: processing file <%s>\n",infile);
	zero(line,132);
	fgetflg = fgets(line,132,ifp);
	while (fgetflg) {				/* loop while u can still get data from the file */
		if (!lflag) {					/* do the help file procesing if not a listing */
			while (*line == '!')
				fgetss(line,132,ifp);
			switch (*line) {
				case '*': *line = 32;		/* if next level specifier then set the next level */
					  clvl=plvl=pplvl+1;	/* and check paging and then underline the title */
					  if (clvl <= plevel)
						newpage();
					  if (clvl == plevel+1)
						print("\n\n");
					  print("\n");
					  underline(line);
					  *(line)=0;
					  break;
				case '/': clvl = plvl+1;	/* if a specifier then set the next sub-level */
					  if (clvl <= plevel)	/* then check paging an do underlining */
						newpage();
					  if (clvl == plevel+1)
						print("\n\n");
					  print("\n");
					  underline(line);
					  *line=0;
					  break;
				case '1':			/* if a specific level specifier then set that level */
				case '2':			/* and check paging then do underlining */
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
					  clvl=plvl=pplvl=*line-48;
					  if (clvl<=plevel)
						newpage();
					  if (clvl == plevel+1)
						print("\n\n");
					  print("\n");
					  *line=32;
					  underline(line);
					  *line=0;
					  break;
				case '@': process(line+1);		/* if indirect file specification then call this */
					  *line=0;			/* proceedure again recursivly to process the next file */
					  break;
				case '#': underline(line+1);
				default : break;
			}
		}
		if(*line)						/* if anything there then print it */
			print(line);
		zero(line,132);
		fgetflg = fgets(line,132,ifp);
	}
	fclose(ifp);							/* close the input file */
	fcount++;							/* increment the file counter */
}




print(line)					/* print the passed text, accounting for form feeds */
char *line;
{
	int b;
	char buff[132];

	if ((b = inchr(line,'\14')) != -1) {	/* find any form feed, and print before that then call newpage() */
		strncpy(buff,line,b);
		if (*buff)
			prnoff(buff);
		newpage();
		print(line+b+1);		/* then recurr and print the remainder of 
						   the line, accounting for further ff's */
	} else {
		prnoff(line);			/* if no ff's then print it normaly */
	}
}



prnoff(line)						/* this prints text that is gaurenteed not to contain form feeds */
char *line;
{
	int p,u,b;
	char buf[132];

	p=b=0;
	while ((u = inchr(line+b,'\n')) != -1) {	/* loop, printing the lines and counting each line. if new page is */
		b += u;					/* neaded then call newpage() */
		strncpy(buf,line+p,b-p);
		linout(buf);
		p=++b;
	}
	if (*(line+p))					/* if a line is left over then print that */
		linout(line+p);
}




linout(line)						/* print the line, count it and page if nesacery */
char *line;
{
		fputss(line,ofp);
		if ((++lincou > 62) && sflag)
			newpage();
}




newpage()						/* give new page */
{
	int i;

	/* stuff arround if page numbers specified */
	if (++page == fpage)
		freopen(outfile,"w",ofp); /* first page */
	if (page+1 == lpage){	/* a rather rude exit */
		fclose(ofp);
		printf("\nPHELP: Finished - processed %d files\n",fcount);
		exit();
	}

	/* normal paging operations */
	if(sflag) {
		i=(68-lincou);
		lincou = 3;
	} else {
		i=(66-lincou);
		lincou = 1;
	}
	for ( ; i ; i--) {				/* count backwards, giving a linefeed for each line */
		putc('\n',ofp);
	}
	if (!lflag) {
		fprintf(ofp,"                       -- %s Documentation --             PAGE %4d\n\n",docname,page);
		lincou++;
	}
}


underline(text)						/* print out a line, with underline */
char *text;
{
	int d;
	char c,buf[132];

	if(lincou>57)					/* If title will be lonley, new page */
		newpage();
	strncpy(buf,text,inchr(text,'\n'));		/* get until the first <cr> */
	title[clvl+1]=cpystr(title[clvl],buf);		/* place that on the title string */
	fputss(header,ofp);				/* write that line out */
	for (d=0 ; (*(header+d)==' ') ; d++)		/* move the pointer to the first character */
		putc(' ',ofp);
	for ( ; (c=*(header+d)) ; d++)			/* underline the rest of the line */
		putc('~',ofp);
	putc('\n',ofp);					/* new line */
	if (((lincou+=2)>60) && sflag)			/* count that up and page if neaded */
		newpage();
}




toups(line)
char *line;
{
	char *start;

	start=line;
	while (*line) {
		*line=toupper(*line);
		line++;
	}
	return(start);
}
