/*
 *			s q u e e z e . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	squeez	Remove White From String
index		remove white from String

synopsis

	char *
	squeeze(string)
	 char *string;	/* pointer to string to be squeezed */

description

	squeeze() removes all white spaces from a null-terminated string.
	Returns a pointer to the string.

bugs

author

	Machiavelli Systems

#endif




squeeze(string)
char	*string;
{
	char *p;	/* destination */
	char *q;	/* source */

	/* source & destination start @ the same place */
	p = q = string;

	/* loop arround until the end-of-string is found */
	while (*q) {

		/* if it's not a whitespace, then move it to the next
		   destination pos */
		if (!iswhite(*q)) {
			*p++ = *q;
		};

		/* examine the next character */
		q++;
	};

	/* put an end-of-string on the end  */
	*p = 0;

	/* return a pointer to the new string (which is actually where
	   the old one was ) */
	return(string);
}
