/*
 *			g e t g r o u p . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	getgro	Get a Group of Characters
index		get a Group of characters

synopsis

	int
	getgroup(ccp, dest, openchar, closechar)
	 char **ccp;		/* pointer to buffer pointer */
	 char *dest;		/* pointer to destination buffer */
	 char openchar;		/* start character */
	 char closechar;	/* end character */

description

	Get a group of characters from a string. Its extent is determined
	by the openchar, and closechar characters.  If ccp contains nothing 
	then NULL is returned.  If the brackets don't exist in ccp, then
	the string passed is copied into the destination buffer.
	Nothing is returned.

bugs

author

	Machiavelli Systems

#endif

#include "symbols.h"



getgroup(ccp, dest, openchar, closechar)
char *dest;
char **ccp;
char openchar;
char closechar;
{
	int count;

	count = 0;
	while (**ccp != openchar && **ccp != ENDSTRING) {
		*(*ccp)++;
	};
	while (**ccp != ENDSTRING)
	{
		if (**ccp == openchar)
			count++;
		if (**ccp == closechar)
			count--;
		*dest++ = *(*ccp)++;
		if (count == 0) break;
	};
	if (**ccp == ENDSTRING && count !=0 )
		zerror ("\7 someone stuffed up (not me mind you)\7\7");
	*dest = ENDSTRING;
}





