/*
 *			f o p e n x . c
 */

/*)LIBRARY
*/

#ifdef DOCUMENTATION

title	fopenx	Open a Fixed File for Update
index		open a Fixed File for update

synopsis

	FILE *
	fopenx(filnam,recz)
	 char *filnam;		/* pointer to name of file to open */
	 unsigned recz;		/* record size of file being opened */

description

	fopenx() opens the specified fixed length file for update.
	The pointer to the file descriptor is returned, of 0 for error.
	If an error occurs, $$ferr is set.

bugs

author

	Machiavelli Systems

#endif


#define _production

#include <stdio.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>

#define	FDBOFF	024		/* where the fdb really is in FILE struct */




FILE	*fopenx(filnam,recz)	/* open(update) named file for random access with given record size */
char		*filnam;
unsigned	recz;		/* record size (bytes) */
{
	FILE	*ioptr;

	/* attempt to open the file */
	ioptr = fopen(filnam,"an");

	/* if if worked, then set up random access, record size */
	if (ioptr) {
		ranacc(ioptr);		/* random access */
		recsiz(ioptr,recz);	/* set record size */
	};

	return	(ioptr);	/* return NULL, $$ferr if failed */
}
