/*	THE STANDARD STANDARD HEADER that makes things UNIXy
 *	copyright (C) 1983 Design Aids
 *	all rights reserved
 */

#ifdef	DOCUMENTATION
title	fit.h	the STANDARD standard header
index	fit.h
Usage:
	_#include _<fit.h_>
Description:
	This follows a blend of Whitesmiths C and BDS C and UNIX.
	Since the other Cs are very UNIXy only the Whitesmiths stuff is needed.
	Note that even names like _<stdio.h_> are NOT standard so
	_#include _<fit.h_> will subsume _#include _<stdio.h_>.
	.s
	typedef ... ALIGN;	specifies most restrictive type
	for aligning unions.
	.s
	typedef ... FILEP;	specifies what to pass to I/O routines
	because the C systems won't ever agree on what 'FILE' means.
	The Whitesmiths' C stuff has mostly gone away with time.
Internal:
	Vogon Poetry Detected in Whitesmiths' C.
#endif

/*--------------------- begin DECUS stdio.h -------------------*/
/*
 *			s t d i o . h
 */

#ifdef	DOCUMENTATION

title	stdio	Definitions for standard i/o library
index		Definitions for standard i/o library

Synopsis

	#include <stdio.h>

Description

	<stdio.h> should be included in the assembly of all C programs
	that use the standard i/o library (fopen(), getc(), printf(), etc.)
	.s
	It defines the following:
	.s
	  FILE	The  i/o  routines  use  and  return pointers to
		objects of this type.
	.s
	  NULL	I/O routines signal "rejection" by  returning  a
		pointer to a null object.
	.s
	  EOF	The get character routine returns this value  to
		signal end of file.
	.s								
	stdin	The "standard" input file.  Normally the  user's
		terminal; it may be redirected.
	.s
	stdout	The "standard" output file.  Normally the user's
		terminal; it may be redirected.
	.s
	stderr	The "error" output file.  It will  always  write
		to the user's terminal.
Bugs

	This version of stdio.h also defines TRUE, FALSE, and EOS
	(end of string) which are not transportable to other
	C systems.

#endif

/*
 * )EDITLEVEL=01
 * Edit history
 * 01 13-Aug-79 MM	Defined IOV to match the RSX package
 * 02 18-Mar-80	MM	Redefined everything for the new library
 * 03 14-May-80 MM	Do not define things twice
 * 04 13-Jun-80 MM	Define fwild stuff
 * 05 01-Aug-80 MM	Flag changes (IOV Version 08)
 * 06 15-Sep-80 RBD	Add cell for UIC under RSX.
 * 07 22-Sep-80 MM	Added VF$WLD
 * 08 25-Sep-80 MM	Removed VF$BAD
 * 09 17-Feb-81 MM	Added VMS runoff hack flag
 * 10 08-Oct-81 MM	Nothing special
 * 11 10-Mar-82 MM	Added documentation header
 */

#ifndef	IO_OPN
/*	#ifdef	rsx	*/

typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_uget;	/* Unget char storage	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	char	*io_rbuf;	/* Record buffer start	*/
	int	io_rbsz;	/* Record buffer size	*/
	char	*io_bbuf;	/* Block buffer start	*/
	char	*io_wild;	/* Wildcard lookup buf	*/
	int	io_uic;		/* File's UIC in binary	*/
	int	io_iosb[2];	/* I/O status block	*/
	int	io_fdb[0];	/* File data block	*/
} FILE;

/*   #endif	*/

/*
 * Bits in iov.io_flag.
 *
 * These could be redone as
 *
 *	extern	VF$OPN;
 *	#define	IO_OPN	((int)(&VF$OPN))
 *
 * etc.
 */

#define	IO_OPN	0100000		/* Open file		*/
#define	IO_REC	0040000		/* Record device	*/
#define	IO_TTY	0020000		/* Console terminal	*/
#define	IO_EOF	0010000		/* EOF seen		*/
#define	IO_ERR	0004000		/* Error seen		*/
#define	IO_FIL	0002000		/* Disk file		*/
#define	IO_NOH	0001000		/* No newlines by fopen	*/
#define	IO_NOS	0000400		/* No newlines needed	*/
#define	IO_UBF	0000200		/* User does buffering	*/
#define	IO_BZY	0000100		/* Buffer busy (RT11)	*/
#define IO_WF1	0000040		/* fwild first flag	*/
#define IO_VER	0000020		/* fwild: ;0 or ;-1	*/
#define IO_VM1	0000010		/* fwild: version ;-1	*/
#define IO_WLD	0000004		/* fwild: wildcard file	*/
#define	IO_MOD	0000003		/* File open mode 	*/
				/* 0    means read	*/
				/* 1    means write	*/
				/* 2    means append	*/
				/* != 0 means output	*/

#define EOF	(-1)		/* End of file by getc	*/
#define NULL	0		/* Impossible pointer	*/
#define TRUE	1		/* if (TRUE)		*/
#define FALSE	0		/* if (!TRUE)		*/
#define EOS	0		/* End of string	*/
 
extern	FILE	*stdin;		/* Standard input file	*/
extern	FILE	*stdout;	/* Standard output file	*/
extern 	FILE	*stderr;	/* Standard error file	*/
extern	int	$$ferr;		/* Error codes set here	*/

#endif
/*---------------------- end DECUS stdio.h --------------------*/

typedef	char		TINY;
typedef	int		VOID;
typedef	int		COUNT;
#define UCOUNT unsigned
typedef	int		ALIGN;		/* most restrictive alignment */
typedef	FILE		*FILEP;		/* standard way to get at file */
typedef char 		*STRING;

#define	YES	1
#define	NO	0

/* the end */
