/* xtractrec.c - extract contiguous group of records from file */
/* ufilter2.c - prototype filter program - line (actually record) oriented */
#include <stdio.h>
#include <algol68.h>
#define BUFSIZ 32769
char buffer[BUFSIZ];
extern int $$ferr;
char help[] = "usage: XTRACTREC <stdin >stdout 1st.recnum last.recnum\n\
record numbers are 0-origin\n\
extracts a contiguous group of records from 1st to last inclusive\n";
long	first;
long	last;
long	recnum;
main(argc,argv)
char **argv;
BEGIN
register int	howlong;	/* char length of this record */

	stdin  -> _flag |= IO_NOS | _IONBF;
	stdout -> _flag |= IO_NOS | _IONBF;

	IF	(argc!=3)
	THEN	fprintf(stderr,"%s",help);
		exit(2);
	FI
	sscanf(argv[1],"%ld",&first);
	sscanf(argv[2],"%ld",&last);
	recnum = 0L;
	WHILE	(!feof(stdin))
	DO	howlong = fget(buffer,BUFSIZ,stdin);
		IF	(ferror(stdin))
		THEN	error("read failure $$ferr=%oo\7\n",$$ferr);
		FI
		IF	(feof(stdin))
		THEN	exit();
		FI
		IF	(recnum>last)
		THEN	break;
		FI
		IF	(recnum>=first)
		THEN	fput(buffer,howlong,stdout);
			IF	(ferror(stdout))
			THEN	error("write failed $$ferr=%oo\7\n",$$ferr);
			FI
		FI
		recnum += 1;
	OD
END
/* end: ufilter2.c */
/* end: xtractrec.c */
