/* 2ascii.c - convert each byte in file from ebcdic to ascii
   note: no change in record lengths */

/*
 * history
 *
 *	this used to be modelled on ufilter2.c, which uses stdin.
 *	but stdin proved to eliminate nulls in fget() . WHY??!!
 *	so I changed it to ufilter.c model, which honours record lengths.
 */

#include <stdio.h>
#include <algol68.h>
#include <cx.h>
#include <nboff.h>
#include <fdoff.h>
#include <ascii.h>

#define BUFSIZ 4096
char buffer[BUFSIZ];
FILE	*inf;
FILE	*ouf;
extern int $dsw;
extern int $$ferr;
FDB * fdbp;

char	* p;		/* tracks each char in record		*/
char	* nd;		/* marks end of record			*/

main(argc,argv)
char **argv;
BEGIN
register int	howlong;	/* char length of this record */
	IF	((inf=fopen(argv[1],"ur"))==NULL)
	THEN	error("can't find %s\7\n",argv[1]);
	FI;
	IF	((ouf=fopen(argv[2],"uw"))==NULL)
	THEN	error("can't make %s\7\n",argv[2]);
	FI;
	fdbp = ouf -> io_fdb;
	fdbp -> f_fatt . f_ratt |= fd_cr;	/* force fd.cr */
	WHILE	(!feof(inf))
	DO	howlong = fget(buffer,BUFSIZ,inf);
		IF	(ferror(inf))
		THEN	error("read failure $$ferr=%oo\7\n",$$ferr);
		FI;
		IF	(feof(inf))
		THEN	break;
		FI;
		nd = buffer + howlong;
		FOR	(p=buffer;	p<nd;	p++)
		DO	* p = ascii[*p&0xFF];
		OD
		fput(buffer,howlong,ouf);
		IF	(ferror(ouf))
		THEN	error("write failed $$ferr=%oo\7\n",$$ferr);
		FI;
	OD;
	IF	(fclose(ouf))
	THEN	error("Can't close\n");
	FI;
END

/* end: 2ascii.c */
