/*				R E O D E R				*/
/*									*/
/*  REODER reads records from stdin and writes out specified fields	*/
/*  to stdout.								*/
/*									*/
/*		REODER sf1 sf2 ...					*/
/*									*/
/*  sfn is either a switch or a field descriptor.			*/ 
/*									*/
/*  Valid switches are :						*/
/*									*/
/*	-w  If you want to be warned about search failures (default)	*/
/*	-s  If you want search failures to be silent			*/
/*	-f  If you want search failures to be fatal (default)		*/
/*	-c  If you want to continue after a search failure		*/
/*									*/
/*  Field specifers are standard field specifiers (see XFIELD		*/
/*  documentation for details)						*/

/*)BUILD	$(PROGRAM)	= reoder
		$(FILES)	= { reoder xfield }
		$(TKBOPTIONS)	= {
			TASK	= ...REO
		}

*/

/*
 *		E D I T   H I S T O R Y
 *
 * 8May85 PF001	reset switch defaults before each read-crunch-write cycle
 *		change defaults to (warn,fatal) to agree with
 *		various documentation extant: detecting and changing all
 *		documentation would be hard to do!
 *
 */

/*
 *		B U G S
 *
 *		include DECUS C standard documentation: see REODER.RNO
 *
 */

#include <algol68.h>
#include <stdio.h>

#define BUFSIZ 4096

main(argc,argv)
int argc;
char **argv;
BEGIN
  bool sfwarnp;			/* Warn user on search failure */
  bool sffatalp;		/* Fall over on search failure */
  char *buffer;			/* Buffer for input line */
  char *obf;			/* Buffer for created fields */
  bool haderrp;			/* XFIELD returns its error status */
  int i,j;
  char c,*bp;

  /* Give user (minimal) help if (s)he just types program name */

  IF (argc<=1)
  THEN
    fprintf(stderr,"USAGE: REODER field-def1 field-def2...\n");
    exit();
  FI;

  /* Well the user at least gave us a command (boy will he be sorry) */

  /* Create buffer for input line */

  buffer=malloc(BUFSIZ);
  IF (buffer==0)
  THEN
    error("REODER - Could not allocate input buffer -- FATAL");
  FI;

  /* Until we reach end of file, read each line from stdin into buffer */

  WHILE	((c=getchar())!=EOF) DO

    /* Put in defaults */	/*$PF001*/
    sfwarnp=TRUE;	/*$PF001*/	/* warn user if search missed */
    sffatalp=TRUE;	/*$PF001*/	/* and fall over */

    /* No errors so far this line */
    haderrp=FALSE;
    /* Read in a whole line */
    bp=buffer;
    WHILE (c!='\n' && c!=EOF) DO
      *bp++=c;
      c=getchar();
    OD;
    *bp='\0';
    /* We now wash the current line (buffer) against each field */
    /* descriptor in the user's command line */
    FOR(i=1; !haderrp && i<=argc-1; i++) DO
      IF (argv[i][0]=='-')
      THEN
        /* Here to process a switch */
        FOR (j=1; argv[i][j]!='\0'; j++) DO
          switch (tolower(argv[i][j]))
          BEGIN
            case 'f' : sffatalp=TRUE; break;
            case 'c' : sffatalp=FALSE; break;
            case 'w' : sfwarnp=TRUE; break;
            case 's' : sfwarnp=FALSE; break;
            default : fprintf(stderr,"REODER - Invalid switch -- FATAL\n");
                      exit();
          END;
        OD;
      ELSE
        /* Here to process a non-switch (ie a real field descriptor) */
        obf=xfield(argv[i],buffer,TRUE,TRUE,1,buffer,
                   sfwarnp,sffatalp,&haderrp);
        IF (!haderrp)
        THEN
          printf("%s",obf);
          mfree(obf);
        FI;
      FI;
    OD;
    printf("\n");
  OD;
END
