/* OSCPM.H : #include me in CPM version of CPM.c */
/* I am the Operating-system dependant part of CPM.c */

/* BDS C CP/M-80 version */

#include "bios.h"
#include "bdos.h"

int	cdrive;		/* diskette drive for CPM (foreign) diskette */
int	sdrive;		/* BDOS' opinion of current CP/M drive */
			/* in both above: 0==A: 1==B: 2==C: .... */

/* first we fight the BDOS: save & restore context */

csave()			/* save BDOS state (BDOS is always in a state!) */
BEGIN
	sdrive=bdos(BDOS_RCD);
END

crestore()		/* restore BDOS state */
BEGIN
	bios(SELDSK,sdrive);
END

/* these are the basis for the rest of CPM.c */

cbegin()
BEGIN
	cdrive = tolower(*diskette) - 'a';
	sdrive = bdos(BDOS_RCD);
	bdos(BDOS_RD,1<<cdrive);
	bdos(BDOS_SD,cdrive);		/* sniff density etc */
	bdos(BDOS_SD,sdrive);		/* as you were ! */
END

cend()
BEGIN
END

cgetsec(secnum,sector)	/* read a sector */
int	secnum;		/* 0-org sector number
			   0th sector is the 1st director sector
			   i.e. skip boot tracks */
char	sector[128];
BEGIN
int	sect;		/* sector within track: 0:25 */
int	cylinder;	/* track */

	csave();
	sect		= cxlate(secnum%26);
	cylinder	= secnum/26 + 2;
/*
printf("secnum=%d. sect=%d.",secnum,sect);
*/
	bios(SETDMA,	sector);
	bios(SELDSK,	cdrive);
	bios(SETTRK,	cylinder);
	bios(SETSEC,	1+sect);
	bios(READ	);

/*
int	i;
FOR	(i=0;	i<128;	i++)
DO	IF	(!(i&0x1F))
	THEN	printf("\n");
	FI
	printf("%2x",sector[i]);
OD
printf("\n");
*/

	crestore();
END

cputsec(secnum,sector)	/* write a sector */
int	secnum;		/* 0-org sector number
			   0th sector is the 1st director sector
			   i.e. skip boot tracks */
char	sector[128];
BEGIN
int	sect;		/* sector within track: 0:25 */
int	cylinder;	/* track */

	csave();
	sect		= cxlate(secnum%26);
	cylinder	= secnum/26 + 2;
	bios(SETDMA,	sector);
	bios(SELDSK,	cdrive);
	bios(SETTRK,	cylinder);
	bios(SETSEC,	1+sect);
	bios(WRITE	);
	crestore();
END


char	ibuf[BUFSIZ];
char	obuf[BUFSIZ];

int	oscreate(fname)		/* TRUE if OK */
char	*fname;
BEGIN
/*
printf("OSCREATE: fname=\"%s\"\n",fname);
*/
	return	( fcreat(fname,obuf)!=ERROR );
END

osput(c)			/* output 1 char */
char		c;
BEGIN
	IF	(putc(c,obuf)<0)
	THEN	printf("\7out of disk space\n");
		exit();
	FI
END

osafcreate()
BEGIN
	putc(CPMEOF,obuf);
	fclose(obuf);
END

int	osopen(fname)		/* TRUE if OK */
char	*fname;
BEGIN
int	fff;

	fff = fopen(fname,ibuf);
	return	( fff!=ERROR );
END

int	osget()			/* input 1 char */
BEGIN
int	c;

	c = getc(ibuf);
	IF	(c==ERROR || c==CPMEOF)
	THEN	c = -1;
	ELSE	c = c & 0xFF;
	FI
/*
printf("c=%xx\n");
*/
	return(c);
END

osafopen()
BEGIN
	fclose(ibuf);
END


/*  OH NO! not the WILD CARDS! */

#define	FCB_SIZE 33	/* no random access */

char	fcb[FCB_SIZE];
char	dma[128];
char	bdosstatus;

char	wilds[64][11];
int	wp;		/* number of next wild file to deliver */
			/* 0:63 */

wildmake()		/* in:	wname
			   do:	set up for wild carding
			   out: nothing
			   kill:wname
			*/
BEGIN
char		*p;
char		*q;

	zero(fcb,FCB_SIZE);
	FOR	(p=fcb+1,q=wname;	q<wname+11;	p++,q++)
	DO	*p = *q ? *q : '?' ;
	OD
	/* one day we will allow user > 0 */	/************************/
	bdos(BDOS_SDA,dma);
	bdosstatus = bdos(BDOS_SFF,fcb);
	wp=0;
	zero(wilds,64*11);
	WHILE	(bdosstatus<4)
	DO	copy(&wilds[wp++][0],dma+(bdosstatus<<5)+1,11);
		bdos(BDOS_SDA,dma);
		bdosstatus = bdos(BDOS_SFN,fcb);
	OD
	wp=0;
END

wilddebug()
BEGIN
int	i;

	printf("sts=%xx fcb=",bdosstatus);
	FOR	(i=0;	i<33;	i++)
	DO	printf("%2x",fcb[i]);
	OD
	FOR	(i=0;	i<128;	i++)
	DO	IF	(!(i&0x1F))
		THEN	putchar('\n');
		FI
		printf("%2x",dma[i]);
	OD
	putchar('\n');
END

int	wildnext()	/* in:	
			   do:	find next wild-carded file
			   out:	infilnam	print name of file
				wname		FCB name of file
						i.e. trail spaces in name,type
			   ret:	TRUE if we got another file
			*/
BEGIN
char		*i;	/* infilnam */
char		*w;	/* wname */
int		retval;	/* returned value */

	IF	(retval=(wp<64&&wilds[wp][0]))
	THEN	copy(wname,&(wilds[wp++][0]),11);
		FOR	(i=infilnam,w=wname;	w<wname+8;	w++)
		DO	IF	(*w!=' ')
			THEN	*i++=*w;
			FI
		OD
		*i++='.';
		FOR	(	;	w<wname+11;	w++)
		DO	IF	(*w!=' ')
			THEN	*i++=*w;
			FI
		OD
		*i++=0;
	FI
/*
printf("retval=%xx infilnam=\"%s\"\n",retval,infilnam);
*/
	return(retval);
END
