/* putbit.c - set bits in bit array		*/

/*)LIBRARY
*/

#include <algol68.h>

#ifdef	DOCUMENTATION
title	Putbit	Set bit in bit vector
index	Bit vector
index	Getbit()
index	Putbit()
usage
	 int	abit;		/* 1 or 0 */
	 char bits[...];	/* bit vector */
	 
	 putbit(bits,bitnumber,abit);
	 
description
	The complement of Getbit() is Putbit(). Together
	they define a way of handling bit vectors that is
	somewhat independent of your computer architecture.

	Putbit() sets a nominated bit to 1 or 0. The first
	bit of the bit vector is ordinated 0.
internal
bugs
#endif

#define BITSPERCHAR (8)	/* bits per char		*/

int	putbit(where,bitnumber,wot)
char *	where;		/* bit vector			*/
int	bitnumber;	/* bit number			*/
int	wot;		/* new bit value		*/
BEGIN
int	mask;
char *	p;

	p     = where +	(bitnumber / BITSPERCHAR) ;
	mask  = 1 << 	(bitnumber % BITSPERCHAR) ;

	IF	(wot&1)
	THEN	*p |=   mask ;	/* 1			*/
	ELSE	*p &= (~mask);	/* 0			*/
	FI

END

/* end: putbit() */
