/* getbit.c - extract bits from bit array		*/

/*)LIBRARY
*/

#include <algol68.h>

#ifdef	DOCUMENTATION
title	Getbit	Extract bit from bit vector
index	Bit vector
index	Getbit()
index	Putbit()
usage
	 int	result;		/* 1 or 0 */
	 char bits[...];	/* bit vector */
	 
	 result = getbit(&bits,bitnumber);
	 
description
	The complement of Getbit() is Putbit(). Together
	they define a way of handling bit vectors that is
	somewhat independent of your computer architecture.

	Getbit() returns the value of the Nth bit in a bit vector.
	The first bit in the vector is ordinated 0.
internal
bugs
#endif

#define BITSPERCHAR (8)	/* bits per char		*/

int	getbit(where,bitnumber)
char *	where;		/* bit vector			*/
int	bitnumber;	/* bit number			*/
BEGIN
	return ( (	(where[bitnumber/BITSPERCHAR])
		  &	(1<<(bitnumber%BITSPERCHAR))
		 )
		 ? 1 : 0
	       );
END

/* end: getbit() */
