/* kbd.c - keyboard input server */

#include <algol68.h>
#include <stdio.h>
#include <cx.h>
#include <qiofun.h>
#include <qiottd.h>

#define	E1	4
#define	E2	5
#define E3	9

#define	LUN	1

int	dswrvb;
int	dswmrkt;
int	dswwtlo;
int	dswcmkt;
int	dswkil;
int	dswclef;
int	isbrvb[2];
int	isbkil[2];
int	prl[6];
char	buf[2];

int	gimme()
BEGIN
register	int	retval;
/*
 * in:	event flags E1 and E2 may be anything, but both will be knocked down
 * out: event flags E1=down, e2=?
 */
	prl[0] = buf;
	prl[1] = 1;
	check("rvb", dswrvb = qio(IO_RLB|TF_RNE|TF_RAL,LUN,E1,isbrvb,0,prl));
	check("mrkt", dswmrkt = mrkt(E2,5,2,0));
	check("wtlo", dswwtlo = wtlo0(030));
	check("cmkt", dswcmkt = cmkt(E2,0));
	check("kil", dswkil =  qio(IO_KIL,LUN,E3,isbkil,0,prl));
	check("clef", dswclef = clef(E1));
	IF	(dswclef!=IS_SET && dswclef!=IS_CLR)
	THEN	panic();
	FI
	IF	(dswclef == IS_SET  &&  (isbrvb[0]&0xFF)<0x80)
	THEN	retval = buf[0]&0xFF;
	ELSE	retval = -1;
	FI
	return(retval);
END

panic()
BEGIN
	fprintf(stderr,"\7dsws: rvb=%o mkrt=%o wtlo=%o cmkt=%o kil=%o clef=%o\n"
			, dswrvb, dswmrkt, dswwtlo, dswcmkt, dswkil, dswclef );
	fprintf(stderr,"prl= %oo %oo %oo %oo %oo %oo\n",
			prl[0], prl[1], prl[2], prl[3], prl[4], prl[5]);
	fprintf(stderr,"isbs: rvb=%oo%oo kil=%oo%oo  buf=%oo%oo"
			, isbrvb[0], isbrvb[1], isbkil[0], isbkil[1]
			, buf[0], buf[1]);
	exit(42);
END

check(y,i)
char *	y;
int	i;
BEGIN
	IF	(i<0)
	THEN	fprintf(stderr,"failed in %s\n",y);
		getchar();
		panic();
	FI
END

int	isbatt[2];
int	dswatt;

main()
BEGIN
register	int	i;

	dswatt = qiow(IO_ATT,LUN,E3,isbatt,0,prl);
	WHILE	((i=gimme())!='q')
	DO	printf("%oo\n",i);
		IF	(i=='s')
		THEN	sleep(10);	/* test typeahead */
		FI
	OD
END
