/*)BUILD
	$(TKBOPTIONS) = {
		STACK = 2000
		TASK = ...ADA
	}
*/
/*
 * given input:
 * file_path+
 * archive_name=
 * file_name
 * file_name ...
 * archive_name=
 * file_name ...
 *
 * add all files to the previously named archive, all files found at
 * path (e.g. [333,333]+ means fred.dat is read as [333,333]fred.dat
 */

#include <stdio.h>
main (argc, argv)
int argc;
char **argv; {
	long timval;
	char *timetext, *argp;
	char inline [100], path [100], archive [100], filename [30];
	char newname [100], data [1000];
	FILE *arcf, *inf;

	if (argc > 1) {
		printf ("%s: I pack files onto archives rapidly\n", *argv);
		printf ("useage: %s <control_file\n", *argv);
		printf ("\tfilename reads a file\n");
		printf ("\tpath+ establishes a new default path for files\n");
		printf ("\tfile= starts on a new archive file.arc\n");
		printf ("\t1 cmd/line, .arc's are in current path\n");
		printf ("\tuse PIP or SRD with TECO to make control file\n");
		exit (0);
	}
	time (&timval);
	timetext = ctime (&timval);
	argp = timetext + strlen (timetext);
	while (argp > timetext && *--argp <= ' ')
		;
	argp [1] = EOS;
	*path = EOS;
	arcf = NULL;
	while (gets (inline)) {
		argp = &inline [strlen (inline) - 1];
		if (*argp == '+') {
			strcpy (path, inline);
			path [strlen (path) - 1] = EOS;
			fprintf (stderr, "[Read from %s]\n", path);
		} else if (*argp == '=') {
			strcpy (archive, inline);
			archive [strlen (archive) - 1] = EOS;
			strcat (archive, ".arc");
			fprintf (stderr, "[Arc %s]\n", archive);
			if (arcf)
				fclose (arcf);
			if ((arcf = fopen (archive, "a")) == NULL) {
				fprintf (stderr,
					"%%Can't open %s, ignoring files\n",
					archive);
			}
		} else {
			strcpy (newname, path);
			strcat (newname, inline);
			if ((inf = fopen (newname, "r")) == NULL) {
				fprintf (stderr, "%%%s missing, ignored\n",
					newname);
				continue;
			}
			argp = index (inline, ';');
			if (argp)
				*argp = EOS;
			if (arcf) {
				fgetname(inf, filename);
				fprintf(arcf, "-h- %s\t%s\t%s\n", inline,
					timetext, filename);
				while (fgets (data, sizeof (data), inf)) {
					fputs (data, arcf);
				}
			}
			fclose(inf);
		}
	}
	if (arcf)
		fclose (arcf);
}
