.;
.; Command file to compile C programs.
.;
.enable substitution
.if p1 = "?" .goto help
.;	break out switches
.parse p1 "/" arg0 arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10 arg11
.if arg0 <> "" .goto gotnam
.;	get name from TECF00.TMP if none given
.testfile tecf00.tmp;1
.if <filerr> ne 1 .goto nofile
.openr tecf00.tmp;1
.read tecfil
.close
.test tecfil ".C"
.setn teclen <strlen>
.if teclen = 0 .goto nofile
.sets arg0 tecfil[1:teclen-1]
.test tecfil
.if <strlen> < 1 .goto nofile
.if <strlen> = teclen+1 .goto oldnam
.;	here with no name and no .C file in TECF00.TMP
.nofile:
;
; I need a filename, or a .C file in "TECF00.TMP".
; Type  @'p0' ?  for help.
;
.exit 2
.;	here with a name, so write it into TECF00 for next time
.gotnam:
.open tecf00.tmp;1
.data 'arg0'.C
.close
.oldnam:
.;	set up to compile one file
.sets name0 arg0
.sets name1 ""
.;	initialise all switch values
.sets debug ""
.sets dtoa ""
.sets map ""
.sets stb ""
.sets buildr "FTB"
.sets xas "-a"
.sets librf ""
.sets linkf ""
.sets name arg0+"XX"
.sets name "..."+name[1:3]
.sets stack "STACK = 1000"
.sett compil
.setf bench
.setf keeptb
.setf verbos
.setf cref
.;	loop through each switch (or option, or qualifier, or...)
.setn option 1.
.oploop:
.;	while (option < 10 && *arg[option]) {
.if option > 10 .goto optend
.if arg'option' = "" .goto optend
.;	break out the arguments to the switch
.parse arg'option' ":" opt0 opt1 opt2 opt3 opt4 opt5 opt6 opt7 opt8 opt9 opt10
.sets switch opt0+" "
.sets switch switch[1:2]+","
.;	here with <char><char><comma>, now see if we know it
.test "BM,CC,DB,FI,FP,KT,LK,LB,MA,NA,QU,SP,ST,SY,TB,VE," switch
.if <strlen> > 0 .goto goodsw
;
; Unknown switch /'opt0' ignored,
; Type  @'p0' ?  for help
;
.goto nextsw
.goodsw:
.sets switch switch[1:2]
.;	execute code relevent to that switch
.gosub sw'switch'
.nextsw:
.inc option
.;	}
.goto oploop
.;	below are all of the switch handlers
.;	here to allow benchmarks				BM
.swbm:
.ift verbos ; Benchmarking enabled
.sett bench
.return
.;	here to compile all other arguments as C files		CC
.swcc:
.ift verbos ; Compiling other arguments as C files
.setn file 1.
.setn parm 2.
copylp:
.if arg'file' = "" .goto copyfn
.sets name'file' p'parm'
.inc file
.inc parm
.goto copylp
.copyfn:
.sets name'file' ""
.sets p2 ""
.return
.;	here to set up for debugging				DB
.swdb:
.sets stb name0
.sets debug "[1,1]ddt/da,"
.if opt1 NE "" .sets debug "[1,1]'opt1'/da,"
.ift verbos ; Linking in debugger as 'debug'
.if buildr <> "FTB" .goto swdb1
.ift verbos ; forcing taskbuilder from 'buildr' to TKB
.sets buildr "TKB"
.;								DB1
.swdb1:
.ift verbos ; forcing a map, with cross-reference
.gosub swma
.sett cref
.return
.;	here to link other files				FI
.swfi:
.setn file 0.
.;	here to get next `other file` to link in		FILP
.swfilp:
.inc file
.if opt'file' = "" .return
.sets linkf linkf+opt'file'+".OBJ,"
.iff verbos .goto swfilp
.sets tempry opt'file'
; Linking in 'tempry'.OBJ
.goto swfilp
.;	here to allow floating point				FP
.swfp:
.sets dtoa "lb:[1,1]atod,lb:[1,1]dtoa,lb:[1,1]atof,"
.ift verbos ; Linking floating-point code in
.return
.;	here to keep task build file				KT
.swkt:
.sett keeptb
.ift verbos ; Taskbuild file 'name0'.TKB will be retained
.return
.;	here to use libraries					LB
.swlb:
.setn file 0.
.;	here to get next `other file` to search			LBLP
.swlblp:
.inc file
.if opt'file' = "" .return
.sets tempry "opt'file'"
.sets tempry 'tempry'
.testfile 'tempry'.olb
.if <filerr> eq 1 .goto swlb1
; library 'tempry'.OLB absent: we will continue without it
.goto swlblp
.;	here to add another library file to TKB command		LB1
.swlb1:
.sets librf librf+"'<filspc>'"+"/LB,"
.ift verbos ; We will search '<filspc>'
.goto swlblp
.;	here skip the C compile pass				LK
.swlk:
.setf compil
.ift verbos ; Compilation phase skipped
.return
.;	here to change the name of the task			NA
.swna:
.sets opt1 opt1+"XXX"
.sets name "..."+opt1[1:3]
.ift verbos ; Task name set to 'name'
.return
.;	here to force a map file				MA
.swma:
.if opt1 = "CR" .sett cref
.sets map name0+"/-sp"
.return
.;	here to prevent progress reports			QU
.swqu:
.enable quiet
.return
.;	here to flag separate compile/assemble			SP
.swsp:
.sets xas ""
.ift verbos ; Separate compile and assemble
.return
.;	here to change stack size				ST
.swst:
.sets stack "STACK = 2000"
.if opt1 NE "" .sets stack "STACK = "+opt1
.ift verbos ; 'stack'
.return
.;	here to force symbol table				SY
.swsy:
.sets stb name0
.return
.;	here to change our taskbuilder				TK
.swtb:
.sets buildr "TKB"
.if opt1 NE "" .sets buildr opt1
.ift verbos ; Using 'buildr' as taskbuilder
.return
.;	here to be noisy					VE
.swve:
.sett verbos
; Verbosity runs rampant
.return
.;	here with options done, start compiling if needed
.optend:
.ift cref .sets map map+"/cr"
.ift cref .if buildr = "FTB" .sets buildr "TKB"
.iff compil .goto nocc
.ifnins ...xcc ins $cc
.if <exstat> ne 1 .goto needcc
.ifnins ...xas ins $as
.if <exstat> ne 1 .goto needcc
.setn file 0.
.;	loop through here, compiling each C file as needed
.ccloop:
.ift bench .gosub time
.if name'file' = "" .goto nocc
.sets afile name'file'
xcc 'afile'.C 'xas' >'afile'.elg
.if <exstat> ne 1 .exit <exstat>
.if xas ne "" .goto nocc
.ift bench .gosub time
xas -d 'afile'.s
.if <exstat> ne 1 .exit <exstat>
.inc file
.goto ccloop
.;	here with C compile(s) done, make taskbuilder file
.nocc:
.open 'name0'.tkb
.enable data
'name0'/CP,'map','stb'='name0'.OBJ,
'linkf'
'librf'
lb:[1,1]pflib/lb,cu/lb,'dtoa'C/LB,cx/lb,'debug'
/
TASK = 'name'
LIBR = FCSRES:RO
'stack'
.disable data
.if name1 ne "" .goto nopt
.data 'p2'
.data 'p3'
.data 'p4'
.data 'p5'
.data 'p6'
.data 'p7'
.data 'p8'
.data 'p9'
.nopt:
.data //
.close
.;	do the taskbuild
.ifnins ...'buildr' ins $'buildr'RES
.ifnins ...'buildr' ins $'buildr'
.ifnins ...'buildr' .goto needcc
.ift bench .gosub time
'buildr' @'name0'.TKB
.if <exstat> ne 1 .exit <exstat>
.ift bench .gosub time
.ift verbos ; Default task name set to "'name'".
.;	done taskbuild, now clean up after us
.iff keeptb pip 'name0'.TKB;/de
.iff compil .goto dedun
.setn file 0.
.deloop:
.if name'file' = "" .goto dedun
.sets afile name'file'
pip 'afile'.OBJ;/de
pip 'afile'.ELG;/de
.inc file
.goto deloop
.dedun:
.;	Here after deleting any .elg, .obj that we compiled.
.exit <succes>
.;
.; Here to print time-and-date
.;
.time:
.open ti:
.data Time is '<date>' '<time>'.
.close
.return
.;
.; Here to give good help
.;
.help:
;
; This command file compiles C programs. Invoke it as:
;	@'p0' {filename}{/switches} {tkb_option(s) | c-files}
; If no filename is given, it is read from TECF00.TMP;1. If one is given
;   it is written into TECF00.TMP;1 and used.
; Available switches are:
; /BM			benchmark (print time) at each step
; /CC			use remaining arguments as C files not TKB options
; /DB{:debugger}	allow use of DDT or other debugger (changed from /DE)
; /FI{:file(s)}	select other (.OBJ) files to build with
; /FP			use floating point (link in DTOA, ATOD, ATOF)
; /KT			keep taskbuilder file
; /LB:lnam:lnam ...	libraries to search
; /LK			skip the compile & just link (taskbuild)
; /MA			get a MAP file from the taskbuilder
; /NA{:name}		use other than default of 1st 3 letters of src
; /QU			quiet run (don''t echo commands)
; /SP			run xcc and xas as separate passes (no -a in xcc)
; /ST{:value}		expand runtime stack to 2000 or given value
; /SY			get a symbol file from the taskbuilder
; /TB{:builder}	select TKB or named builder instead of FTB
; /VE			verbose compilation
.exit 0
.;
.; Here without a neccesary task
.;
.needcc:
;
; I need the following tasks to run:
; Installed	or Filename
; XCC		$XCC
; XAS		$XAS
; 'buildr'		$'buildr'
;
; Invoke me as
; @'p0' ?
; for a help message
;
.exit 2
