/*
 *	n e t u t l - netio
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

Title	netio	network io routines for use with netlnk
Index	netio	network io routines for use with netlnk

synopsis
	.s.nf
	  get_net(buf, len, iovp)
	  char *buf;		/* buffer to read into */
	  int len;		/* size of buffer */
	  NIOV *np;		/* ptr to NIOV of open link */
	.s
	  put_net(buf, len, iovp)
	  char *buf;
	  int len;
	  NIOV *np;
	.s
	  gta_net(buf, len, np, ast)
	  char *buf;
	  int len;
	  NIOV *np;
	  int (*ast)();
	.s.f
Description

	These routines provide network IO calls similar to the 
	file system fget() and fput() calls.
	.s
	The NIOV pointers are similar to file pointers and are
	returned by con_net() or acc_net() calls.
	.s
	Get_net() and put_net() return the number of bytes received
	or sent. On error, both return NULL, the error code is in
	$$nerr.
	.s
	Both routines are synchronous, they don't return until
	the get or put completes. Note that if you call get_net()
	and the other node is also waiting for you to send data,
	both tasks will stall forever.
	.s
	Gta_net() allows specifying an ast function to be called
	when the network receive completes. This function returns
	immediately. If the read is successfully started, 1 is 
	returned, on error, 0 is returned with the error code in
	$$nerr.
	

Implementation Details

	Derived from the original netutl routines. These routines
	use the NIOV structure defined in <stdnet.h>.

Bugs

	Until all current tasks are converted, there will be
	two versions of the netutl functions around, with the
	expected confusion.

edit history
	.nf .s
	01 13-mar-86 hjj get_net() and put_net() really return
			NULL on error. Previously returned iosb[1]
			on error.
#endif

#include <stdio.h>
#include <cx.h>
#include <stdnet.h>

extern int $$nerr;


get_net(buf, len, np)
char *buf;
int len;
NIOV *np;
{
  if ((np->status & LINKUP) == 0) {
    $$nerr = IE_NLN;
    return(NULL);
  }
  $$nerr = recwnt(np->lun, np->efn, np->iosb, 0, buf, len);
  if ($$nerr < 0) return(NULL);

  if (($$nerr = np->iosb[0]) < 1) return(NULL);
  else return(np->iosb[1]);
}

put_net(buf, len, np)
char *buf;
int len;
NIOV *np;
{
  if ((np->status & LINKUP) == 0) {
    $$nerr = IE_NLN;
    return(NULL);
  }
  $$nerr = sndwnt(np->lun, np->efn, np->iosb, 0, buf, len);
  if ($$nerr < 0) return(NULL);

  if (($$nerr = np->iosb[0]) < 1) return(NULL);
  else return(np->iosb[1]);
}

gta_net(buf, len, np, ast)
char *buf;
int len;
NIOV *np;
int (*ast)();
{
  if ((np->status & LINKUP) == 0) {
    $$nerr = IE_NLN;
    return(NULL);
  }
  $$nerr = recnt(np->lun, np->efn, np->iosb, ast, buf, len);
  if ($$nerr < 0) return(NULL);

  $$nerr = np->iosb[0];
  return(1);
}
