C****************************************************************
C* 								*
C*								*
C*	DIGITAL EQUIPMENT CORPORATION ASSUMES NO RESPONSIBILITY *
C*	EITHER FOR THE CREATION OR FOR THE CLINICAL EFFICACY	*
C*	OF THIS PROGRAM. USERS MUST ASSUME FULL RESPONSIBILITY	*
C*	FOR ANY RESULTS OR DIAGNOSES OBTAINED FROM THE USE	*
C*	OF THIS PROGRAM. QUESTIONS ON THE EXECUTION OF THIS	*
C*	PROGRAM MUST BE REFERRED BACK TO THE ORIGINAL AUTHOR.	*
C*								*
C* AUTHOR:	SALLY FORSTER					*
C*		C/O DEPARTMENT OF NUCLEAR MEDICINE		*
C*		GUY'S HOSPITAL				*
C*		LONDON, ENGLAND					*
C*								*
C*		TEL: 01-407-7600 EXT 2583/4			*
C*								*
C****************************************************************
	FUNCTION LINREG(I,J)
C*****X CO-ORD IN CURVE2
C*****Y CO-ORD IN CURVE 1
C*****	FITS X,Y CO-ORDS TO Y=MX+C
	IMPLICIT LOGICAL*1 (A)
	IMPLICIT INTEGER*2(D-Z)
	COMMON//SAVDES(256),CURVE1(512),CURVE2(512)
	COMMON/WINDOW/FST,LST
	COMMON/FIT/CGRAD,CINT,CORR
	EXTERNAL CLIN
	REAL*8 CSUMX,CSUMY,CVXY,CVX,CVY,CX,CY,CN,CXBAR,CYBAR
	REAL*4 CYHMAX,CYMAX
	DATA CYHMAX,CYMAX/1E18,1E36/
	LINREG=1
	CSUMX=0
	CSUMY=0
	CVXY=0
	CVX=0
	CVY=0
	CN=DBLE(FLOAT(J-I+1))
	DO 100 N=I,J
	CSUMX=DBLE(CURVE2(N-FST+1))+CSUMX
	CSUMY=DBLE(CURVE1(N))+CSUMY
	IF(CSUMY.GT.CYMAX)GOTO 300
100	CONTINUE
	CXBAR=CSUMX/CN
	CYBAR=CSUMY/CN
	DO 200	N=I,J
	CX=DBLE(CURVE2(N-FST+1))
	CY=DBLE(CURVE1(N))
	CSUMX=CX-CXBAR
	CVX=CVX+CSUMX**2
	CSUMY=(CY-CYBAR)
	IF(DABS(CSUMY).GT.CYHMAX)GOTO 300
	CVY=CVY+CSUMY**2
	CVXY=CVXY+CSUMX*CSUMY
200	CONTINUE
	CGRAD=SNGL(CVXY/CVX)
	CINT=SNGL(CYBAR-CGRAD*CXBAR)
	CORR=SNGL(CVXY/DSQRT(CVX*CVY))
C*****RECONSTRUCT CURVE
	CALL RECONS(CLIN)
	RETURN
300	WRITE(7,400)
	LINREG=-1
	RETURN
400	FORMAT(1X,'FIT OVERFLOW')
	END
