C****************************************************************
C* 								*
C*								*
C*	DIGITAL EQUIPMENT CORPORATION ASSUMES NO RESPONSIBILITY *
C*	EITHER FOR THE CREATION OR FOR THE CLINICAL EFFICACY	*
C*	OF THIS PROGRAM. USERS MUST ASSUME FULL RESPONSIBILITY	*
C*	FOR ANY RESULTS OR DIAGNOSES OBTAINED FROM THE USE	*
C*	OF THIS PROGRAM. QUESTIONS ON THE EXECUTION OF THIS	*
C*	PROGRAM MUST BE REFERRED BACK TO THE ORIGINAL AUTHOR.	*
C*								*
C* AUTHOR:	SALLY FORSTER					*
C*		C/O DEPARTMENT OF NUCLEAR MEDICINE		*
C*		GUY'S HOSPITAL				*
C*		LONDON, ENGLAND					*
C*								*
C*		TEL: 01-407-7600 EXT 2583/4			*
C*								*
C****************************************************************
	FUNCTION LINEAR()
C*****CONVERTS BUFFER DATA TO ACTIVITY/TIME CURVE
C*****STANDARDISING TO THE FRAME RATE OF THE FIRST GROUP.
C*****TO REVERT TO NORMAL THE SAVE AREA MUST BE READ AGAIN.
C*****RETURNS LINEAR=-1 IF THE SAVE AREA NOT OPEN.
	IMPLICIT LOGICAL*1 (A)
	IMPLICIT INTEGER*2 (D-Z)
	COMMON//SAVDES(256),CURVE1(512),CURVE2(512),ICS,ICB
	DIMENSION CX(13)
C*****
	LINEAR=0
	IF(SAVDES(118).EQ.1)RETURN
	CX(1)=FLOAT(SAVDES(123))/FLOAT(SAVDES(122))
C*****CALCULATE SCALE FACTOR FOR EACH GROUP
	DO 10 I=2,SAVDES(118)
	J=122+(I-1)*5
	K=J+1
	CX(I)=CX(1)*FLOAT(SAVDES(J))/FLOAT(SAVDES(K))
	SAVDES(J)=SAVDES(122)
	SAVDES(K)=SAVDES(123)
C*****CORRECT TIME AXES IN SAVDES
10	CONTINUE
C******
	DO 40 H=1,SAVDES(184)+1
	I=H-1
	II=I*2
	IF(II.EQ.0)GOTO 25
	IF(SAVDES(183+II).LT.0)GOTO 40
25	IF(ICVG(I).LT.0)GOTO 100
C*****MISS FIRST GROUP KK TAKES POINT  NUMBER
	KK=SAVDES(119)+1
C*****J TAKES GROUP NUMBER
	DO 30 J=2,SAVDES(118)
C*****K TAKES FRAME WITHIN GROUP
	DO 30 K=1,SAVDES(119+(J-1)*5)
	CURVE1(KK)=CURVE1(KK)*CX(J)
30	KK=KK+1
	IF(ICVS(I).LT.0)GOTO 100
40	CONTINUE
	RETURN
100	LINEAR=-1
	RETURN
	END
