/*
 *			_ s p u t c h a r . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	_sputc	Put A Character to the Terminal
index		Put a character to the terminal

synopsis

	int
	_sputchar(c)
	 char c;		/* chacacter to be displayed */

description

	_sputchar() displays a character on the screen at the current
	cursor position.

bugs

author

	Machiavelli Systems

#endif

#include <qiottd.h>
#include <cx.h>
#include <stdio.h>
#include <qiofun.h>
#define LUNSNATCH 1
#define EFNSNATCH 10


_sputchar(c)
char	c;
{
	int isb[2];
	int prl[6];	/* qiow's parameted list */
	int dsw;	/* directive status word */

	fflush(stdout);		/* clear the ti: output buffer */

	prl[0] = &c;		/* pass the pointer to the char	*/
	prl[1] = 1;		/* display 1 character		*/
	prl[2] = 0;		/* no vertical format control	*/

	dsw = qiow(IO_WAL,LUNSNATCH,EFNSNATCH,isb,0,prl);	/* qio a write_all to ti: lun */

	if ( (dsw&0xFF)!=IS_SUC || (isb[0]&0xFF)!=IS_SUC )	/* is everything ok ? */
		{
		error("\7Can't write to TI: dsw=%oo isb=%oo %oo\n",dsw,isb[0],isb[1]); /* if not, then screw up */
		};
}
