/* demo kbd asts & timeout asts, with a common event flag */

#include <cx.h>
#include <qiofun.h>
#include <qiottd.h>
#include <algol68.h>
#include <rb.h>

#define EFN (7)

struct rb	r;
#define	NUM (40)
#define SIZ (2)
char	rngbuf[NUM*SIZ];

BOOL	quit;

int	esbuf[8];	/* emitted status buffer		*/
int	senbuf[13];	/* something to send			*/
long	tsknam;		/* name of worker task			*/



astems()	/* emitted status */
BEGIN
int *	ip;
	astset();
	ip = gtdp(0);
	printf("WORKER emitted status %d.\n",*ip);
	work();	/* make the bastard do it again */
	beep('w');
	setf(EFN);
	astx(1);
END

astkbd()
BEGIN
int ch;
	astset();
	ch = gtdp(0) & 0x7F;
	IF	(!rbin(&r,&ch))
	THEN	exst(42);
	FI
	setf(EFN);
	beep('k');
	astx(1);
END

asttim()
BEGIN
int efn;

	astset();
	efn = gtdp(0);
	printf("Beep\07  EFN = %d\n", efn);
	beep('t');
	quit = TRUE;
	astx(1);
END

spew()
BEGIN
int	x;
	WHILE	(rbout(&r,&x))
	DO	printf("%6o\n",x);
	OD
END


int	par[6];
int	dsw;
int	isb[2];
#define LUN (4)

main()
BEGIN
	rbnew(&r,rngbuf,SIZ,NUM);
	ascr50(6,"...wor",&tsknam);	/* try for generic name		*/
	puts("Hello");		/* Say hello				*/
	mrkt(5,10,2,asttim);	/* Kick off a 10 sec mrkt on EFN 5	*/
	par[0] = astkbd;	/* ordinary keyboard ast		*/
	par[1] = 042;		/* terminal identifier			*/
	par[2] = 0;		/* no special AST for ^C		*/
	IF	((dsw=alun(LUN,'TI',0))!=IS_SUC)
	THEN	error("\7ALUN dsw=%oo",dsw);
	FI
	IF	((dsw=qiow(IO_ATT|IQ_X|TF_AST|TF_XCC,LUN,EFN,isb,0,par))!=IS_SUC)
	THEN	error("\7IO_ATT dsw=%oo isb=%oo%oo",dsw,isb[0],isb[1]);
	FI
	/*
	 * here sucking visciously on our terminal, remove TF_XCC in real thing
	 */
	work();	/* kickstart background worker */
	FOR	(clef(EFN),quit=FALSE; !quit; clef(EFN))
	DO	stse(EFN);
		beep('.');
	OD
	spew();
	puts("Bye");                        /* Say byebye */
END

beep(b)
int	b;		/* beep: 1 char to send to screen	*/
BEGIN
	par[0] = &b;
	par[1] = 1;
	IF	((dsw=qiow(IO_WVB,LUN,EFN,isb,0,par))!=IS_SUC)
	THEN	error("\7IO_WVB dsw=%oo isb=%oo%oo",dsw,isb[0],isb[1]);
	FI
END

work()
BEGIN
	IF	((dsw=sdrc(&tsknam,senbuf,9,astems,esbuf))!=IS_SUC)
	THEN	error("\7SDRC dsw=%oo",dsw);
	FI
END
