/* demo kbd asts & timeout asts */

#include <cx.h>
#include <qiofun.h>
#include <qiottd.h>
#include <algol68.h>
#include <rb.h>

struct rb	r;
#define	NUM (40)
#define SIZ (2)
char	rngbuf[NUM*SIZ];

astkbd()
BEGIN
int ch;
	astset();
	ch = gtdp(0) & 0x7F;
	IF	(!rbin(&r,&ch))
	THEN	exst(42);
	FI
	astx(1);
END

asttim()
BEGIN
int efn;

	astset();
	efn = gtdp(0);
	printf("Beep\07  EFN = %d\n", efn);
	astx(1);
END

spew()
BEGIN
int	x;
	WHILE	(rbout(&r,&x))
	DO	printf("%6o\n",x);
	OD
END


int	par[6];
int	dsw;
int	isb[2];
#define EFN (7)
#define LUN (1) /* stderr is always ti: */

main()
BEGIN
	rbnew(&r,rngbuf,SIZ,NUM);
   puts("Hello");                      /* Say hello */
	mrkt(5,10,2,asttim);	/* Kick off a 10 sec mrkt on EFN 5	*/
	par[0] = astkbd;	/* ordinary keyboard ast		*/
	par[1] = 042;		/* terminal identifier			*/
	par[2] = 0;		/* no special AST for ^C		*/
	IF	((dsw=qiow(IO_ATT|IQ_X|TF_AST|TF_XCC,LUN,EFN,isb,0,par))!=IS_SUC)
	THEN	error("\7IO_ATT dsw=%oo isb=%oo%oo",dsw,isb[0],isb[1]);
	FI
   stse(5);                            /* Stop on the event flag */
	spew();
	puts("Bye");                        /* Say byebye */
END
