/* cspawn.c - another *** gangway - spawn made easy for RSX DECUS-C */


/*
	status = cspawn ( task , command , eventflag ) ;

	status:		directive status word : panic if it is not 1
			1 == IS_SUC

	task:		string (char *)
			name of task to spawn
			may be lower case

	command:	command line to task
			string (char *)
			THIS MUST END IN '\r\n'
			a null command will cause instant sucess
				except RSX won't run your task (!!)
			may be lower case
			if you end in '\033' then no ">" will be
			given on task completion, so endin in '\033'
			is the normal way to do this

	eventflag:	the number of the event flag to use
			THIS MUST NOT BE 1 because RSX borrows
			event flag 1.

*/

/*	function:

			spawn the task

			wait for the task to exit
			or for the task to emit status

			only then, return to caller
*/

/* read cx.doc for wtse() spwn() */


#include <cx.h>				/* define IS_SUC */

int	cspawn(task,command,efn)
char	*task;
char	*command;
int	efn;
{
 long	tsk;				/* rad50 task name */
 int	dsw;				/* directive status word */

	tsk = 0;
	ascr50(min(strlen(task),6),task,&tsk);
					/* convert at most 6 chars
					   of task name to rad50 */

	dsw = spwn(&tsk,0,efn,0,0,command,strlen(command));

	if	(dsw != IS_SUC)	return(dsw);

	return ( wtse(efn) );
}

/*	and now for the testing ...	*/

#undef	testing	!	/* define to assemble a main() to test */
			/* undefine to just use as a library module */

/*
	to build:

	>#C CSPAWN
	>#T CSPAWN

*/

#ifdef testing

main()
{
	char		task[20];	/* task name */
	char		cmd[100];	/* the command to the spawned task */
	int		efn;		/* event flag number for SPWN$ */

/*	recommended demo options:

	efn = 12
	task = mcr...
	cmd = dir
*/

	printf("efn (decimal) :");
	gets(cmd);
	sscanf(cmd,"%d",&efn);
	printf("efn = %d.\n",efn);

	printf("task name:");
	gets(task);
	printf("task name = \"%s\"\n",task);

	printf("command to the task :");
	gets(cmd);
	strcat(cmd,"\033");
	printf("command = \"%s\"\n",cmd);

	printf("cspawn returned %oo\n",cspawn(task,cmd,efn));
}

#endif


/* end: cspawn.c */
