/* sfuic.c - show RSX/M(+) some UIC details */
/* written to demo gin() and $sfuic function on RSX11M+ */
/* also written to debug concepts for network file servers that were
   getting up themselves because of wrong assumptions about nodes & uics.
   Yes, I KNOW we should buy DECnet, but try explaining why you should
   expend money to a computer salesman! */

#include <algol68.h>
#include <cx.h>

#define	BUFWDS	(13)		/* number of words in buffer */
#define BUFWDS	(32)		/* BUT this flavour of drgin\$sfuic is greedy */
				/* if we don't let it use this much, it is shy
				   about information - like the rest of DEC */
#define DPBWDS	(4)		/* number of words in dpb */

word	buf[BUFWDS];		/* info lands here */
word	parameters[DPBWDS];	/* DPB */
int	dsw;			/* result: directive status word */

main(argc,argv)
int	argc;
char **	argv;
BEGIN
char * r50long();

	IF	(argc<1)
	THEN	error("usage %s\7",*argv);
	FI

	parameters[0] = DPBWDS<<8;	/* length of dpb */
	parameters[1] = 1;	/* SFFTK get task info */
	parameters[2] = buf;	/* address of buffer */
	parameters[3] = BUFWDS;	/* size of buffer */
	dsw = gin(parameters);
	printf("dsw=%oo\n",dsw);

	IF	(dsw>0)
	THEN	uic("sysuic",		buf[0]);
		uic("libuic",		buf[1]);
		uic("current uic",	buf[2]);
		uic("protection uic",	buf[3]);
		uic("login uic",	buf[4]);
		uic("terminal uic",	buf[5]);
		name("cli task name",	buf+6);
		printf("%.2s%.2s%.2s\t\tsystem name\n",buf+8,buf+9,buf+10);
		uic("network uic",	buf[11]);
		printf("system size (mapping units e.g. %d. bytes) = %d.\n"
				,64,buf[12]);
	FI
END

uic(wot,u)
char *	wot;	/* what does it all mean? */
unsigned u;	/* the uic */
BEGIN
	printf("[%3o,%3o]\t%s\n",(u>>8)&0xFF,u&0xFF,wot);
END

name(wot,n)
char *	wot;	/* what does it all mean? */
address n;	/* address of two words of rad50 */
BEGIN
	printf("%s\t\t%s\n",r50long(n),wot);
END

char * r50long(x)	/* 2 rad50 words => give a string(no trailing blanks) */
address	x;
BEGIN
static char c7[7];

	c7[6] = 0;
	r50toa(c7,x,2);
	$_$rtb(c7);
	return (c7);
END

/* end: sfuic.c */
