/* feature.c - show RSX/M(+) user what features are in exec */
/* written only to test gin() */

#include <algol68.h>
#include <cx.h>

word	buf[9];		/* info lands here */
word	parameters[4];	/* DPB */
int	dsw;		/* result */
char *	f1[] =	{
			"22-bit",
			"multi-user protection",
			"20k exec supported",
			"loadable drivers",
			"plas",
			"dynamic checkpoint allocation",
			"i/o packet preallocation",
			"extend task directive",
			"lsi-11",
			"parent/offspring",
			"full duplex tt:",
			"x.25 cex loaded",
			"dynamic memory allocation",
			"com exec loaded",
			"mcr exits after each command",
			"logins disabled",
			""
		};
char *	f2[] =	{
			"kernal data space",
			"supervisor mode libraries",
			"multiprocessing",
			"event trace",
			"cpu accounting",
			"shadow recording",
			"secondary pools",
			"secondary pool file windows",
			"seperate directive partition",
			"install run & remove",
			"group global event flags",
			"receive/send packet",
			"alt. header refresh area",
			"round robin scheduling",
			"executive level disk swapping",
			"event flag mask in TCB",
			""
		};
char *	f3[] =	{
			"spontaneous crash",
			"xdt crash",
			"requires EIS",
			"set system time",
			"user data space",
			"proto TCBs in sec pool",
			"external task headers",
			"ast",
			"11S",
			"multiple CLI",
			"seperate terminal driver pool",
			"pool monitoring",
			"watchdog timer",
			"rms record lock",
			"shuffler",
			"?",
			""
		};
char *	f4[] =	{
			"comm exec deallocated",
			"?XT",
			"?Error Logging",
			"?PTY",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			""
		};
char *	h[] =	{
			"unibus map",
			"EIS",
			"?Qbus",
			"?",
			"?",
			"?",
			"?",
			"CIS",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"?",
			"No FPU",
			""
		};

main()
BEGIN
	parameters[0] = 4<<8;	/* length of dpb */
	parameters[1] = 3;	/* get features */
	parameters[2] = buf;	/* address of buffer */
	parameters[3] = 9;	/* size of buffer */
	dsw = gin(parameters);
	printf("dsw=%oo\n",dsw);
	printf("feature masks %oo %oo %oo %oo\n",buf[0],buf[1],buf[2],buf[3]);
	mask(buf[0],f1);
	mask(buf[1],f2);
	mask(buf[2],f3);
	mask(buf[3],f4);
	printf("hardware feature mask %oo\n",buf[4]);
	mask(buf[4],h);
	printf("base level %oo %oo \"%.4s\"\n",buf[5],buf[6],buf+5);
	printf("system version %oo %oo \"%.4s\"\n",buf[7],buf[8],buf+7);
END

mask(m,text)		/* sorry about the BASIC(k) accent! */
unsigned	m;
char * text[];
BEGIN
unsigned	b;
unsigned	i;
	FOR	(i=0;	i<16;	i++)
	DO	b = 1<<i;
		IF	((b&m) || !streq("?",text[i]))
		THEN	printf("%s%s\n",b&m?"Yes ":"No  ",text[i]);
		FI
	OD
END
