.PS 60,75
.NF;.NJ;.NAP

Problems with DECUS C runtime system I/D space.

			... DEAN ELSNER 09-322-6048

All the good noise is in eg [273,14] [273,15].

You just replace the supplied modules (which typically just change
the .psect names around so data lives in data space and instructions
live in instruction space).

Problems are:

(1)	I haven't changed profile code ($$trace() and friends).
	Would somebody like to fix it using Move from Inst Space
	directives? 

(2)	Taskbuilder is capable (and indeed eager) to build an I/D C task 
	[with or without Supervisor Mode libraries] [with or without
	clustering] which has a screwed up 1st block. windows I think.
	When you run the task, and it does an EXTK$ (which it must do
	to parse your command line) wonderful things happen.
	First, exec says it gave you the memory. True, but you can't
	write to that memory, it is supplied read-only.
	OK, so you use version 999999 of $$init [273,15]init.mac and use
	$$wank to patch around, by pre-reserving some space and avoiding 
	at all costs any EXTK$.

	Now, for all you clumsy people who feel a need to delete evidence 
	(smooth hackers don't create it in the first place) here is a tip 
	to scramble RSX exec space. (Works on VMS4 also, but who needs
	this trick to prang VMS?) (How can you tell when VMS is dead?)
	You do an I/D task, do an EXTK$, and make
	sure the task is marked PMD (post-mortem dump). In other words
	build a simple I/D task (echo.c is fine) and run echo/pmd=yes.
	The C runtime system will do EXTK$, write to it, trap on write
	protect, and start the PMD. At this point RSX has exec kernel
	instruction space and data space mapping mixed up. It discovers
	all these interesting TCBs etc (which used to be exec instructions 
	before they got mapped into data space) and modifies selected
	bits in these instructions. Worse, it intertwines lists of data
	items across both instruction space and data space. (PMD meanwhile
	gets your task's address space right, but usually the exec croaks
	before PMD can finish!) The way I do it is
		quiesce the system (abo *.*)
		run your task
		watch the pretty messages
		listen to the disk receive the PMD
		type a command, any command, anywhere
		when you hit return, MCR is scheduled, follows all those
			beautiful pointers, and the exec will crash.
		should you take a crash dump (usually possible) the CDA
			will choke. I have NEVER got CDA to decode the
			mess. 

	Ok, enough of the war story. I have traced the problem to one or
	more of:
		exec is gullible and believes taksbuilder's mapping in 1st
			block of your task. I noticed confusion between
			windows 0 (data) and 1 (inst) in XDT, but I read
			the code and it should work.
		MCR may have a bug. But I can do this trick without MCR.
		The EXTK$ and I/D is critical.

	I haven't rassled this bug down, because RSX84 (USA) submissions
	imply TKB is the culprit. Why else would they suddenly invent
	things like TIZ (task image zapper) to modify the way TKB maps
	your task?

	I expect wise men from USA to fix this, (not you Bezerredy! some
	damn user!) I haven't had the interest.

***	Fear not, I have used I/D in shared clusterd supervisor tasks,
	weirdly mapped regions, with swapping back out to disk, and have
	had NO bugs yet.

	I get my tasks flying by using $$wank (preferred method)
	and use ident 999999 of $$init. Read [273,15]init.mac & wank.mac.
	I also use sleazy things like $$ngmc and initd.mac to build tasks
	that NEVER use malloc() and they do alright too. Remember malloc() 
	is used a lot before main() is even called.

	You see, malloc() calls sbrk() which does EXTK$, but when malloc()
	presumes to write in the new memory, your task dies. Great for
	improving response times and reducing thrashing.

	Dean Elsner, Violent Ward, Somewhere in Perth WA.
