
#include	"sysdef.h"

/*								*/
/*	Copyright Notice					*/
/*								*/
/*								*/
/*	C version Copyright (C) 1984 Change Software, Inc.	*/
/*	Copyright (C) 1978 1979 1980 1981 1982 1983 1984 by	*/
/*		      Change Software, Inc.			*/
/*								*/
/*								*/
/*	This software is furnished under a license and may	*/
/*	be  used  and  copied  only in accordance with the	*/
/*	terms of such license and with  the  inclusion  of	*/
/*	the  above copyright notice.  This software or any	*/
/*	other copies thereof may not be provided or other-	*/
/*	wise made available to any other person.  No title	*/
/*	to and ownership of the software is hereby  trans-	*/
/*	ferred.							*/
/*								*/
/*	File related (and not oft used) screen editor routines		*/
/*	Also some word processing type stuff like PARAGRAPH and FILL	*/


#include	"scerrd.h"
#include	"tempio.h"

#define	then
#define	CR	015
#define	LF	012
#define	RUB	0177

static char rubstr[] = { RUB,0 } ;

extern char *strcpy() ;



vtopfile()
{

	char f[100] ;
	extern char *infile[] ;
	register int status ;
	int len ;
	extern int kblun,*loclow,w ;
	

	movel24() ;
	ceol24() ;
	status = 0 ;
	if ( (len = lgetbin(f,"File to insert ? ")) > 0 )
	  then	{
		f[len] = 0 ;
		if ( w ) then strcpy(infile[w],f) ;
		if ( (status=scinsfile(f)) == sys_normal )
		  then	{
			rstpage(*loclow) ;
			ref_screen() ;
			}
		}
	goback() ;
	return( status ) ;

}


scinsfile(f)
char *f ;
{
	extern struct textline inline ;
	extern char *strcpy(),workbuffer[] ;
	extern int *curline,worklength,inlun ;
	char s[100] ;
	register char *cp,*oldcp ;
	register int i,curlen ;
	int oldcurline,status ;

	if ( (i=strlen(f)) > 100 ) then i = 100 ;
	i = trimjunk(strcpy(s,f),i) ;
	s[i] = 0 ;
	if ( (status = openfi(s,inlun)) != sys_normal )
	  then	{
		scwarning(w_fnf) ;
		return(status) ;
		}
	scunloadline() ;
	oldcurline = *curline ;
	scwarning(w_work) ;
	while ((status=getline(inlun,inline.c,&inline.len))==sys_normal) {
		curlen = 0 ;
		cp = inline.c ;
		oldcp = cp ;
		for (i=inline.len; i>0; i--)
		if (*cp++ == LF)
		  then	{
			doins(oldcp,++curlen) ;
			curlen = 0 ;
			oldcp = cp ;
			}
		  else	curlen++ ;

		if ( curlen )
		  then 	doins( oldcp,curlen ) ;
		}
	closef(inlun) ;
	if ( status != er_eof ) then return( status ) ;
	*curline = oldcurline ;
	scwarning(w_clear) ;
	scloadline() ;
	return( sys_normal ) ;
}


static doins(s,len)
char *s;
int len;
{
	extern int *curline,worklength ;
	extern char workbuffer[] ;
	register char *wp ;
	register int i ;

	ins_scline() ;
	scloadline() ;
	wp = workbuffer ;
	for ( i=0; i<len; i++ ) *wp++ = *s++ ;
	worklength = len ;
	txtmod() ;
	scunloadline() ;
	(*curline)++ ;
}
	


#define	SPACE	040
static	int	lpt ;

vtparagraph()
{
	extern struct textline inline,txtsave ;
	extern int *curline,*loclow,*maxline,outlun,rept,rightmargin ;
	extern int worklength ;
	extern char workbuffer[] ;
	register char *cp,*savecp ;
	register int ch ;
	int fillsize ;

	int i,nlines,oldcurline,status ;
	int mark,offset,oldnlines;
	char lastch ;
	char f[64] ;
	
	if ( (fillsize = rept ) == 0 ) then fillsize = rightmargin ;
	getuniquefile(f) ;
	lpt = 0 ;
	if ( (status = openfi(f,outlun)) != sys_normal )
	  then	return(status) ;
	  else	{
		scwarning(w_work) ;
		oldcurline = *curline ;
		scunloadline() ;
		scloadline() ;
		creset() ;
		ch = 0 ;
		nlines = 0 ;
		while ( ++(*curline) < *maxline && atcrlf() == 0 && ch != ' ') {
			nlines++ ;
			scloadline() ;
			ch = workbuffer[0] ;
			}
		oldnlines = nlines ;
		*curline = oldcurline ;
		scloadline() ;
		svinsert(0,rubstr,1) ;
		mark = 0 ;
		offset = 0 ;
		txtsave.len = 0 ;
		cp = txtsave.c ;
		*cp = 0 ;
		savecp = inline.c ;
		*savecp = 0 ;
		lastch = 0 ;
		while ( (ch = pgetch(&nlines)) != -1 ) {
			if ( ch == SPACE )
			  then	{
				savecp = inline.c ;
				mark = offset ;
				}
			if ( !(ch == SPACE && lastch == SPACE ))
			  then	{
				*savecp++ = ch ;
				*savecp = '\0' ;
				*cp++ = ch ;
				offset++ ;
				}
			lastch = ch ;
			if ( offset >= fillsize )
			  then	{
				if ( mark == 0 ) then mark = offset ;
				txtsave.len=lnfill(txtsave.c,mark,fillsize) ;
				txtsave.c[txtsave.len++] = CR ;
				txtsave.c[txtsave.len++] = LF ;
				for ( i=txtsave.len,cp=txtsave.c; i > 0; i-- )
				  if ( *cp == RUB ) *cp++ = ' '; else cp++ ;
				putline( outlun,txtsave.c,txtsave.len ) ;
				cp = txtsave.c ;
				savecp = inline.c ;
				offset = 0 ;
				if (*savecp == SPACE) then savecp++ ;
				while (*savecp != '\0') {
					*cp++ = *savecp++ ;
					offset++ ;
					}
				savecp  = inline.c ;
				*savecp = '\0' ;
				mark = 0 ;
				}
			}
		*cp++ = CR ;		/* dump partial buffer out please */
		*cp++ = LF ;		/* without filling the last line  */
		putline( outlun,txtsave.c,offset+2 ) ;
		*curline = oldcurline ;
		scloadline() ;
		closef(outlun) ;
		for (ch=0;ch<oldnlines;ch++) delline(*curline) ;
		scinsfile(f);
		delfile(f) ;
		}
	rstpage(*loclow) ;
	*curline = *loclow ;
	ref_screen() ;
	scwarning(w_clear) ;
	scmove() ;
}





static pgetch(nlines)
int *nlines ;
{
	register char ch ;
	ch = getch( nlines ) ;
	while ( ch == CR ) ch = getch(nlines) ;
	if ( ch == LF ) then return(' ') ; else return(ch) ;
}

	
static getch(nlines)
int *nlines ;
{
	extern int *curline,worklength ;
	extern char workbuffer[] ;

	if ( *nlines == 0 ) then return(-1) ;
	if ( lpt >= worklength )
	  then	{
		if ( --(*nlines) == 0 ) then return(-1) ;
		lpt = 0 ;
		(*curline)++ ;
		scloadline() ;
		}
	return(workbuffer[lpt++]) ;
	
}







vtfsave()
{
	register int len,status ;
	extern char *infile[] ;
	extern int  *maxline,outlun,w ;
	char f[_FILESIZE] ;

	strcpy(f,infile[w]) ;
	if ( f[0] == 0 )
	  then {
		movel24() ;
		ceol24() ;
		len = trimjunk(f,lgetbin(f,"Filename ? ")) ;
		goback() ;
		f[len] = 0 ;
		if ( f[0] == 0 ) then return(0) ;
		} ;

	if ( (status = openfi(f,outlun)) != sys_normal )
	  then	scerrtxt("Can not open file\015\012") ;
	  else	{
		scunloadline() ;
		ceol24() ;
		rvon() ;
		putbin("Writing ",0) ;
		putbin(infile[w],0) ;
		rvoff() ;
		listlines(1,*maxline-2,outlun) ;
		closef(outlun) ;
		scwarning(w_clear) ;
		status = sys_normal ;
		scloadline() ;
		}
	return( status ) ;
}


vtfwrite()
{
	char f[_FILESIZE] ;
	register int len,status,lastline ;
	extern int outlun,*curline,cut_st,read_only ;
	

	if ( cut_st == 0 || cut_st > *curline )
	  then	{
		scwarning(w_nocu) ;
		return(0) ;
		}

	movel24() ;
	ceol24() ;
	status = 0 ;
	if ( (len = trimjunk(f,lgetbin(f,"Filename ? "))) > 0 )
	  then	{
		f[len] = 0 ;
		if ( (status = openfi(f,outlun)) != sys_normal)
		  then	scerrtxt("Can not create the file") ;
		  else	{
			if ( --(*curline) - cut_st <= 0 ) then (*curline)++ ;
			lastline = (read_only) ? (*curline)-1:(*curline) ;
			scunloadline() ;
			scwarning(w_work) ;
			listlines(cut_st,lastline,outlun) ;
			closef(outlun) ;
			scwarning(w_clear) ;
			scloadline() ;
			status = sys_normal ;
			}
		}
	cut_st = 0 ;
	ledoff(l_select) ;
	goback() ;
	return( status ) ;
}
	



vtfque()
{
	register int len,status ;
	extern int outlun,*curline,cut_st ;
	char f[64] ;
	

	if ( cut_st == 0 || cut_st > *curline )
	  then	{
		scwarning(w_nocu) ;
		return(0) ;
		}

	movel24() ;
	ceol24() ;
	status = 0 ;
	getuniquefile(f) ;
	if ( (status = openfi(f,outlun)) != sys_normal)
	  then	scerrtxt("Can not create work file") ;
	  else	{
		scunloadline() ;
		scwarning(w_work) ;
		listlines(cut_st,*curline,outlun) ;
		closef(outlun) ;
		quefile(f) ;
		scwarning(w_clear) ;
		scloadline() ;
		status = sys_normal ;
		}
	cut_st = 0 ;
	ledoff(l_select) ;
	goback() ;
	return( status ) ;
}
	

