.;
.;	QMGSTART.CMD
.;
.;	Command file to initialise QMG and the print and batch queues.
.;	This command file is executed every time the system is booted.
.;	The CLI should be MCR.
.;
.;----------------------------------------------------------------
.;
.;	Steve Thompson
.;	School of Chemical Engineering
.;	Olin Hall
.;	Cornell University
.;	Ithaca NY 14853
.;
.;
	.ENABLE SUBSTITUTION
	.DISABLE LOWERCASE
.;
.; Set up the directories where we will find logfiles and the tasks
.; BAP.TSK and QMGCLI.TSK. Make sure that the logfile directory
.; actually exists. The group and member numbers for the logfile
.; directory should each have 3 octal digits.
.;
	.SETS LOGDIR "[001,071]"	; UFD for log files (on LB:)
	.SETS BAPDIR "LB:[10,104]"	; UFD for batch tasks
.;
	.SETS LOGGRP LOGDIR[2.:4.]
	.SETS LOGMBR LOGDIR[6.:8.]
	.TESTFILE LB:[0,0]'LOGGRP''LOGMBR'.DIR
	.IF <FILERR> NE 1 .IFNINS ...UFD INS $UFD
	.IF <FILERR> NE 1 UFD LB:'LOGDIR'
.;
.; Make sure virtual terminal driver is loaded. This ensures that the
.; database is loaded (If the database is not loaded, the Queue
.; Manager will reject all attempts to initialize batch processors).
.;
	.IFNLOA VT: LOA VT:
.;
.; Main print queues. DEV can be changed if the line printer is out
.; of action. For example, to use TT10: instead, specify TT10 in
.; response to the prompt. You will need to correctly set the position
.; of the top of the page.
.; The despooler task is assumed to be LB:[10,207]LPP40.TSK.
.;
	.IFNINS QMG... INS $QMG
	QUE /START:QMG
	.IFNINS ...QUE INS 'BAPDIR'QMGCLI/TASK=...QUE
	.IFNINS ...PRI INS 'BAPDIR'QMGCLI/TASK=...PRI
	.IFNINS ...SUB INS 'BAPDIR'QMGCLI/TASK=...SUB
.;
	.ASKS DEV Print Device (Default is LP0)
	.PARSE DEV ":" DEV JUNK
	.IF DEV = "" .SETS DEV "LP0"
	.IFNINS 'DEV' INS LB:[10,207]LPP40/TASK='DEV'
	.SETS TTY DEV[1:2]
	.IF TTY EQ "TT" SET /SLAVE='DEV':
	.IF TTY EQ "TT" SET /LINES='DEV':66.
	.IF TTY EQ "TT" SET /NOBRO='DEV':
	QUE 'DEV':/CR:P/NM
	QUE 'DEV':/SPOOL/FLAG:1/FORM:0
	QUE 'DEV':/ASSIGN:PRINT
	.IF TTY EQ "TT" QUE LA36Q:/CR:P/NM
	.IF TTY EQ "TT" QUE 'DEV':/ASSIGN:LA36Q
.;
.; Commands to dispose of existing log and history files during a
.; system restart after a crash. This command file cannot deal with
.; logfiles in user directories (jobs submitted with the /NOPRINTER
.; qualifier), since there is no way of knowing where the logfiles
.; are.
.;
	.SETS UICSAV <UIC>
	SET /UIC='LOGDIR'
	PIP LOG.DIR=*.*;*/FU
.;
.; Read the logfile directory and issue the appropriate PRINT commands.
.;
	.OPENR #0 LOG.DIR
	.IF <FILERR> NE 1 .GOTO OPNERR
	.READ #0 LINE
.RDEDIR:
	.READ #0 LINE1
	.IFT <EOF> .GOTO EOFDIR
	.READ #0 LINE2
	.IFT <EOF> .GOTO EOFDIR
.;
.; Extract filename from directory file; ignore files not of type LOG
.;
	.PARSE LINE1 ".; " FILNAM FILTYP FILVER DUMMY
	.IF FILTYP NE "LOG" .GOTO RDEDIR
	.TEST FILNAM
	.SETS FILNAM FILNAM[3:<STRLEN>]		; Remove <CR><LF>
	.PARSE LINE2 "[]" DUMMY  OWNER  DUMMY
	.SETS LOGSPC "LB:"+LOGDIR+FILNAM+".LOG;"+FILVER
	.SETS HSTSPC "LB:"+LOGDIR+FILNAM+".HST;"+FILVER
.;
.; Append history file to logfile; then delete history file. The
.; append will produce a "conflicting attributes" message from PIP,
.; but the append will work anyway.
.;
	SET /UIC=[1,1]
	PIP 'LOGSPC'/AP='HSTSPC'
	PIP 'HSTSPC'/DE
.;
.; Append the crash processing text to the logfile.
.;
	.OPENA #1 'LOGSPC'
	.DATA #1	
	.DATA #1	****************************************************
	.DATA #1	****************************************************
	.DATA #1	
	.DATA #1	BATCH SYSTEM CRASH PROCESSING '<TIME>' '<DATE>'
	.DATA #1	BATCH SYSTEM CRASH PROCESSING '<TIME>' '<DATE>'
	.DATA #1	BATCH SYSTEM CRASH PROCESSING '<TIME>' '<DATE>'
	.DATA #1	
	.DATA #1	*****************************************************
	.DATA #1	*****************************************************
	.DATA #1	
	.DATA #1	If there is no End-of-Job display immediately above, this
	.DATA #1	job probably ended prematurely due to a system fault.
	.DATA #1	The output (if any) that appears above may not be a
	.DATA #1	complete record of what the job did.
	.DATA #1	
	.DATA #1	If the normal end-of-job display does appear above, please
	.DATA #1	ignore this message.
	.DATA #1	
	.DATA #1	****************************************************
	.DATA #1	****************************************************
	.DATA #1	
	.CLOSE #1
.;
.; Print logfile.
.;
	SET /UIC=['OWNER']
	PRI 'FILNAM'/-FL='LOGSPC'/DE
	.GOTO RDEDIR
.;
.; End of logfile directory has been reached.
.;
.EOFDIR:
	.CLOSE #0
	SET /UIC='LOGDIR'
	PIP LOG.DIR;*/DE
	SET /UIC='UICSAV'
.OPNERR:
.;
.; Set up Batch Queues (driver is already loaded). This part will need
.; modification for a different queue arrangement.
.;
	QUE SYSQ:/CR:B/NM
	QUE TAPEQ:/CR:B/NM
	QUE LONGQ:/CR:B/NM
.;
.; Make sure all batch processors are installed.
.;
	.IFNINS BAP0 INS 'BAPDIR'BAP/TASK=BAP0
	.IFNINS BAP1 INS 'BAPDIR'BAP/TASK=BAP1
	.IFNINS BAP2 INS 'BAPDIR'BAP/TASK=BAP2
	.IFNINS BAP3 INS 'BAPDIR'BAP/TASK=BAP3
.;
.; Initialize batch processors.
.;
	QUE BAP0:/BA
	QUE BAP1:/BA
	QUE BAP2:/BA
	QUE BAP3:/BA
.;
.; Make sure queues are started/stopped as appropriate.
.;
	QUE TAPEQ:/STO:QUE/NM
	QUE SYSQ:/STA:QUE/NM
	QUE BATCH:/STA:QUE/NM
	QUE LONGQ:/STA:QUE/NM
.;
.; Assign queues to processors.
.;
	QUE BAP0:/AS:SYSQ
	QUE BAP1:/AS:SYSQ
	QUE BAP2:/AS:SYSQ
	QUE BAP3:/AS:SYSQ
.;
	QUE BAP0:/AS:TAPEQ
.;
	QUE BAP1:/AS:BATCH
	QUE BAP2:/AS:BATCH
	QUE BAP3:/AS:BATCH
.;
	QUE BAP3:/AS:LONGQ
.;
.; That's it.
.;
	.EXIT
