c------------------------------------------------------------------------
c
c	Type file contents in double-wide on 132-char screen
c
c	Declarations:
c
	include '($ssdef)/nolist'	! Define ss$_normal (and a whole lot more)
c
	include 'comdtc.inc/list'	! Get common file
	include 'escdtc.inc/list'	! Frequently-used escape sequences
c
c Initialize common declared above
c
	byte ln1			! first character of line
	integer*2 ln2			! first two characters of line
	character*84 comlin /' '/
	character*17 fnamech /'SYS$LOGIN:DTC.DAT'/
	data fname(18) /0/,		! Make FORTRAN OPEN happy
	1    fnsz /17/,			! Length of default value
	2    comlen /0/, comidx /0/	! Length, location in command line
c
	equivalence (comlin, line, ln1, ln2),
	1	    (fname, fnamech)
c
	data homescrn /'[H'/, clrscrn /'[J'/,
	1    dhdw1 /'#3'/, dhdw2 /'#4'/, dwide /'#6'/,
	2    resetvattr /'[m'/, revattr /'[7m'/
c
c End common initialization

	byte buf(79)
c
	integer*4 lib$get_foreign	! Get DCL command line, unparsed
c
	include 'stmtfunc.for/list'	! Get useful statement functions
c
c first set up default data filename
c
	CALL ASSIGN(iterm, 'TT:')
c
c Escape sequences used:
c
c	<ESC>7		Save cursor and video attributes
c	<ESC>8		Restore ...
c	<ESC><		Exit ATS mode
c	<ESC>>		Keypad numeric mode (Exit Alternate Keypad mode)
c	<ESC>[?4l	Reset scroll mode (jump)
c	<ESC>[?6l	Reset origin mode (absolute)
c	<ESC>[r		Set top/bottom margins (default - 1:24)
c	<ESC>[m		Graphic rendition = primary (default)
c	<ESC>[H		Set cursor at home position (upper left)
c	<ESC>(B		G0 (SI/^O) = US ASCII
c	<ESC>)0		G1 (SO/^N) = Special graphics
c	^O		Shift In (Select G0 (US ASCII))
c
c
c	First time, get the MCR line, then parse and process it:
c
c INIT	exflag=.false.				! Assume terminal input
c
	istat=lib$get_foreign(comlin,,comlen)
	if (istat .ne. ss$_normal) go to 999

	if (comlen .eq. 0) then
	    write(iterm,60)
 60	    format('+_File: ',$)
	    read (iterm,4,end=999) comlen, line
	    if (comlen .eq. 0) go to 999
	end if
	
	Open (unit=1,file=line,READONLY,form='FORMATTED',
     1  status='OLD', err=9)

	write (iterm,100)	! Clean up terminal
	1 esc,'<', esc,'>',
	2 esc,'[?4l', esc,resetvattr,		! [m
	3 esc,'(B', esc,')0', esc,'[?3h',
	4 esc,'[?6l', si

	write (iterm,150) esc,dwide, (line(i), i = 1,comlen)

	write(iterm, 6) esc,'[3;24r', esc,'[?6h'
c
 100	format ('+', 17a, $)			! Escape sequences
 150	format('+', 2a, '*** File: ', <comlen>a1, ' ***')

 10	write (iterm,100), esc,homescrn, esc,clrscrn

	Do i=1, 21
	    Read(1,4,end=5) ibln, buf
	    if (ibln .ne. 0) then
		write (iterm,6) esc,dwide, (buf(j), j=1,min0(66,ibln))
	    else
		write (iterm,6) esc,dwide
	    end if
	end do

	read (iterm,4,end=15) comlen, line

	go to 10
c
 4	format(q,100a1)
 6	format(x,100a)
c
 5	write (iterm,77) esc,dwide
 77	format(/,x,2a,'         *** EOF ***')

	read (iterm,4,end=15) comlen, line
 15	write(iterm,66) esc,'[?3l', esc,'[?6l', esc,'[r'
 66	format('+', 6a, $)
	go to 999

 9	write(iterm, 99) (line(i), i = 1,comlen)
 99	format(' File ', <comlen>a1, ' not found')

999	continue

	end
