/*
 * RSX11M V3.2 System Definition Headers for C.
 *
 * Structures and definitions for 'gtsk' function.
 * See the RSX-11M exec reference manual sec. 6.3.36
 *
 * Bob Denny
 *  3-Jun-80
 *
 */

struct	tparbf	{
		struct rad50 g_tstn;	/* RAD50 task name */
		struct rad50 g_tspn;	/* RAD50 part. name */
		int	g_udf1;		/* Undefined */
		int	g_udf2;		/* Undefined */
		int	g_tspr;		/* Task run priority */
		char	g_tsgc;		/* UIC group code */
		char	g_tspc;		/* UIC member code */
		int	g_tsnl;		/* Number of luns */
		int	g_udf3;		/* Undefined */
		int	g_udf4;		/* Undefined */
		ADDR	g_tsva;		/* SST vector addr. */
		int	g_tsvl;		/* SST vector length */
		int	g_tsts;		/* Task window 0 size */
		int	g_tssy;		/* Oper. system code */
		int	g_tsdu;		/* Protection UIC */
		};

/* Operating system codes */

#define		S_11D	0
#define		S_11M	1
#define		S_11S	2
#define		S_IAS	3
#define		S_RSTS	4
#define		S_VMS	5
#define		S_11MP	6
