/*
 * P$MUNPK - Unpack menu buffer
 */

#ifdef   DOCUMENTATION

title    p$munpk     Unpack Menu Buffer
index                Unpack Menu Buffer

synopsis

	 char *fid;          /* Field ID */
	 char *buf;          /* Field 'value' buffer */
	 int maxl;           /* Value buffer size */
	 char *keyw;         /* "DFLT" or "KEYWnn" */
	 int *p1, *p2;       /* Parameter(s) for above */
	 int stat[2];        /* 2-word status */

	 p$munpk(fid, buf, maxl, keyw, p1, p2, stat)

description

	The p$munpk directive unpacks(return information stored in) the static
	menu buffer This has restricted access. It handles only one field, thus
	requiring multiple calls.  Also, it doesn't support both 'DFLT' and 'KEYWnn'
	fields in the same call.
	.s
	The field ID, a string of six(max) uppercase characters, specifies
	one of the following field identifiers:

	 FID	        nn          Menu Field
	 ---            --          ----------
	 'TITL'			    title
	 'TEXTnn'     01,02,03      explanatory text
	 'GHLP'		            global help frame identifier
	 'PRMT'			    prompt text for line 21
	 'OPTNnn'     01 - 12       option text for option nn
	 'ACTNnn'     01 - 12       action string for option nn
	 'OHLPnn'     01 - 12       help frame ID for option nn

author

	 Bob Denny

#endif

extern munpk();

p$munpk(fid, buf, maxl, keyw, p1, p2, stat)
char *fid;                             /* Field ID */
char *buf;                             /* Field 'value' buffer */
int maxl;                              /* Value buffer size */
char *keyw;                            /* "DFLT" or "KEYWnn" */
int *p1, *p2;                          /* Parameter(s) for above */
int stat[2];                           /* 2-word status */
{
int fidl, keyl, bufl;

   fidl = strlen(fid);
   keyl = strlen(keyw);

   call(munpk, 10, stat, fid, &fidl, buf, &maxl, &bufl, keyw, &keyl, p1, p2);
   buf[bufl] = '\0';
   return(stat[0]);
   }

