/*
 * P$MPACK - Pack dynamic multiple choice menu
 */

#ifdef DOCUMENTATION

title p$mpack     Pack Multiple-Choice Menu
index             Pack Multiple-Choice Menu

synopsis

	 char *fid;        /* Field ID */
	 char *buf;        /* Field 'value' buffer */
	 int clear;        /* TRUE = clear dynamic buffer */
	 int stat[2];      /* 2-word status */

	 p$mpack(fid, buf, clear, stat)

description

	The p$mpack directive stores information in (packs) the multiple-choice
	menu buffer. This routine has restricted access: it handles only one
	field, thus requires multiple calls.  The field ID (FID), a string of
	six (max) uppercase characters specifies one a the following field
	identifiers:

 	 FID	        nn          Menu Field
	 ---            --          ----------
	 'TITL'			    title
	 'TEXTnn'     01,02,03      explanatory text
	 'GHLP'		            global help frame identifier
	 'PRMT'			    prompt text for line 21


author

	 Bob Denny

#endif

extern mpack();

p$mpack(fid, buf, clear, stat)
char *fid;                             /* Field ID */
char *buf;                             /* Field 'value' buffer */
int clear;                             /* TRUE = clear dynamic buffer */
int stat[2];                           /* 2-word status */
   {
   int fidl, bufl;

   fidl = strlen(fid);
   bufl = strlen(buf);
   call(mpack, (clear) ? 5 : 6, stat, fid, &fidl, buf, &bufl, "CLRB");
   return(stat[0]);
   }

