/*
 * lex library header file -- accessed through
 *	#include <lex.h>
 */

/*
 * Bob Denny 28-Aug-82  Remove reference to FILE *lexin to
 * eliminate dependency on standard I/O library. Only
 * lexgetc() used it, and it's there now.  Add EOF definition
 * for standalone uses.  Corrected comment for llnxtmax.
 *
 * Move NBPW from YYLEX.C to here, and make it 32 for VAX-11 (native) C
 * else 16.
 */

/*
 * Description of scanning
 * tables.
 * The entries at the front of
 * the struct must remain in
 * place for the assembler routines
 * to find.
 */
struct	lextab {
	int	llendst;		/* Last state number		*/
	char	*lldefault;		/* Default state table		*/
	char	*llnext;		/* Next state table		*/
	char	*llcheck;		/* Check table			*/
	int	*llbase;		/* Base table			*/
	int	llnxtmax;		/* Last in next table		*/

	int	(*llmove)();		/* Move between states		*/
	int	*llfinal;		/* Final state descriptions	*/
	int	(*llactr)();		/* Action routine		*/
	int	*lllook;		/* Look ahead vector if != NULL	*/
	char	*llign;			/* Ignore char vec if != NULL	*/
	char	*llbrk;			/* Break char vec if != NULL	*/
	char	*llill;			/* Illegal char vec if != NULL	*/
};

extern	struct	lextab	*_tabp;

#ifdef vax11c
#define NBPW 32
#else
#define NBPW 16
#endif

#define	lexval	yylval
#define	LEXERR	256
#define	LEXSKIP	(-1)
#define EOF (-1)
#define NULL (0)

/*
 * #define	LEXECHO(fp)	{lexecho((fp));}
 */
extern	int	lexval;
extern	int	yyline;

extern char llbuf[];
extern char *llend;
#define	lextext	llbuf
#define	lexlast llend
