	.ENABLE SUBSTITUTION
	.DISABLE LOWERCASE
	.ENABLE CONTROL-Z
	.ENABLE GLOBAL
	.ENABLE ESCAPE
	.;
	.; File:	BACKUP.CMD
	.; Date:	March 4, 1985
	.; Author:	Robin Miller
	.; Version:	1.0
	.;
	.; Description:
	.;
	.;	This command file is used to backup RL02 disks to magtape.
	.;
	.; Modification History:
	.;
	.;-----------------------------------------------------------------
	.;
	.; Inputs:
	.;	P1 = The backup set name.
	.;	P2 = The magtape device mnemonic.
	.;	P3 = The disk device mnemonic.
	.;
	.SETF $DLG			! Set for short dialogue.
	.SETF DEBUG			! Debug flag to control quiet.
	.SETS DEFMAG "MM0:"		! Set the default magtape drive.
	.SETS DEFSYS "DL0:"		! Set the default system disk.
	.SETF ALLMAG			! Presume the devices
	.SETF ALLSYS			!    are not allocated.
	.SETS CUSNAM "Unknown"		! Define the customer name.
	.IFNINS ...BRU INS $BRU
;
;	Disk Backup Procedure started at '<TIME>' on '<DATE>'
;
	.IF P1 <> "" .GOTO DL10		! If NE, customer site specified.
	.GOTO DLG
.DLGH:
;
;	Long dialogue results in a short explanation being displayed
;	before asking each question.  If you answer no, help is still
;	available on a per question basis by pressing the escape key.
;
.DLG:	.ASK $DLG Do you want long dialogue (<Escape> for explanation)
	.IFT <EOF> .GOTO ABORT		! If true, user typed CTRL/Z.
	.IFT <ESCAPE> .GOTO DLGH	! If true, give user some help.
	.IFF $DLG .GOTO C10		! If false, skip long dialogue.
;
;	This command procedure is used to backup an RL02 to magtape.
;
;	Press the escape key to get help for a particular question.
;
;------------------------------------------------------------------------------
.DL10:	.SETS CUSNAM "'P1'"		! Copy the customer site name.
	.IF P1 <> "" .GOTO C20		! If NE, customer site specified.
	.IFF $DLG .GOTO C10		! If false, skip long dialogue.
.CHELP:
;
;	The next question requests the backup set name to be used on the
;	magtape.  This name should be unique for each disk backed up.
;
.C10:
	.ASKS [1:12.] CUSNAM Enter the backup set name
	.IFT <EOF> .GOTO ABORT		! If true, user typed CTRL/Z.
	.IFT <ESCAPE> .GOTO CHELP	! If true, give user some help.
.C20:	.TEST CUSNAM			! Test the customer site name.
	.IFT <ALPHAN> .GOTO C30		! Ensure label is alphanumeric.
;
;	Please use only alphanumeric characters for the customer name.
;
	.GOTO C10			! Request the customer name again.
.C30:	.SETS MAGTAP "'P2'"		! Copy the magtape device mnemonic.
	.IF P2 <> "" .GOTO M20		! If NE, magtape was specified.
	.IFF $DLG .GOTO M10		! If false, skip long dialogue.
.MHELP:
;
;	The next question requests the magtape device mnemonic to backup
;	the disks to.  If you press the return key, the default device
;	name of "'DEFMAG'" is used.
;
.M10:
	.ASKS [2:4:"'DEFMAG'"] MAGTAP Enter the magtape device name
	.IFT <EOF> .GOTO ABORT		! If true, user typed CTRL/Z.
	.IFT <ESCAPE> .GOTO MHELP	! If true, give user some help.
.M20:	.SETS DEVICE "'MAGTAP'"		! Copy the magtape device name.
	.GOSUB CHKDEV			! Check the device status.
	.IFF STATUS .GOTO M10		! If false, we have a problem.
	.SET'ALLFLG' ALLMAG		! Copy device allocated flag.
	.SETS MAGTAP "'DEVICE'"		! Copy device name (with colon).
	.SETS SYSDEV "'P3'"		! Copy the system disk mnemonic.
	.IF P3 <> "" .GOTO D20		! If NE, system disk specified.
	.IFF $DLG .GOTO D10		! If false, skip long dialogue.
.DHELP:
;
;	The next question requests the device mnemonic of the disk to
;	be backed up.  If you use press the return key, the default
;	device name of "'DEFSYS'" is used.
;
.D10:
	.ASKS [2:4:"'DEFSYS'"] SYSDEV Enter the system disk device name
	.IFT <EOF> .GOTO CLEAN		! If true, user typed CTRL/Z.
	.IFT <ESCAPE> .GOTO DHELP	! If true, give user some help.
.D20:	.SETS DEVICE "'SYSDEV'"		! Copy the system disk name.
	.GOSUB CHKDEV			! Check the device status.
	.IFF STATUS .GOTO D10		! If false, we have a problem.
	.SET'ALLFLG' ALLSYS		! Copy device allocated flag.
	.;
	.; Rewind and copy the system disk to the magtape.
	.;
	BRU /REWIND/DENS:1600/BAC:'CUSNAM' 'DEVICE' 'MAGTAP'
	.IFF DEBUG .ENABLE QUIET
	DMO 'DEVICE'			! Dismount and
	.IFT ALLSYS DEA 'DEVICE'	!   deallocate the system disk.
	DMO 'MAGTAP'/LOCK=U		! Dismount/unload and
	.IFT ALLMAG DEA 'MAGTAP'	!   deallocate the magtape.
	.DISABLE QUIET
;
;	Backup of saveset "'CUSNAM'" completed at '<TIME>' on '<DATE>'
;
	.EXIT
	.;
	.; We come here if the user typed CTRL/Z to a disk name question.
	.;
.CLEAN:	.IFF DEBUG .ENABLE QUIET
	DMO 'MAGTAP'/LOCK=U		! Dismount/unload and
	.IFT ALLMAG DEA 'MAGTAP'	!   deallocate the magtape.
.ABORT:	.DISABLE QUIET
;
;	Customer backup of "'CUSNAM'" aborted at '<TIME>' on '<DATE>'
;
	.EXIT
	.;
	.; This subroutine does various syntax checks on a particular device.
	.; The following steps are performed:
	.;
	.; 	o  Check for device existance.
	.;	o  Check for device driver loaded.
	.;	o  Check for device marked offline.
	.; 	o  Check for device allocated to another terminal.
	.;	o  Check for device allocated by another task.
	.; 	o  Check for device mounted as files-11 disk.
	.;	o  Check for device already mounted foreign.
	.;	o  Attempt to allocate and/or mount the device.
	.;
	.; Inputs:
	.;	Symbol DEVICE contains device to check.
	.;
	.; Outputs:
	.;	Symbol STATUS = True/False for Success/Failure.
	.;	Symbol ALLFLG = True/False for allocated/already allocated.
	.;
.CHKDEV:
	.SETF STATUS			! Presume failure.
	.SETF ALLFLG			! Presume device already allocated.
	.TEST DEVICE			! Get the string length.
	.SETS LAST DEVICE[<STRLEN>:<STRLEN>] ! Copy the last character.
	.IF LAST <> ":" .SETS DEVICE "'DEVICE'"+":" ! Append colon (if needed).
	.TESTDEVICE 'DEVICE'		! Get the device characteristics.
	.SETS STATS "'<EXSTRI>'"	! Copy the device characteristics.
	.TEST STATS "NSD"		! Does the device exist ?
	.IF <STRLEN> = 0 .GOTO CH10	! If EQ, yes.
;
;	Device "'DEVICE'" does not exist, please try again.
;
	.RETURN				! Return failure ...
.CH10:
	.TEST STATS "UNL"		! Is the device driver unloaded ?
	.IF <STRLEN> = 0 .GOTO CH16	! If EQ, no (driver is loaded).
;
;	Device driver for "'DEVICE'" is not loaded, attempting to load it.
;
	.SETS DEV DEVICE[1:2]		! Copy the device mnemonic.
	.IFF DEBUG .ENABLE QUIET
	LOA 'DEV':/PAR=GEN/HIGH		! Attempt to load the driver.
	.DISABLE QUIET
	.IF <EXSTAT> = 1 .GOTO CH14	! If successful, continue ...
;
;	Device driver for "'DEVICE'" could not be loaded, please try again.
;
	.RETURN				! Return failure ...
.CH14:	.TESTDEVICE 'DEVICE'		! Get the device characteristics.
	.SETS STATS "'<EXSTRI>'"	! Copy the device characteristics.
.CH16:
	.TEST STATS "OFL"		! Is the device marked offline ?
	.IF <STRLEN> = 0 .GOTO CH18	! If EQ, no (device is online).
;
;	Device "'DEVICE'" is marked offline, please try again.
;
	.GOTO CFAIL			! Go display the device status.
.CH18:
	.TEST STATS "ALO"		! Device allocated to someone else ?
	.IF <STRLEN> = 0 .GOTO CH20	! If EQ, no.
;
;	Device "'DEVICE'" is allocated to another terminal, please try again.
;
	.GOTO CFAIL			! Go display the device status.
.CH20:
	.TEST STATS "ATT"		! Device attached by another task ?
	.IF <STRLEN> = 0 .GOTO CH30	! If EQ, no.
;
;	Device "'DEVICE'" is attached by another task, please try again.
;
	.GOTO CFAIL			! Go display the device status.
.CH30:
	.TEST STATS "MTD"		! Is device already mounted ?
	.IF <STRLEN> = 0 .GOTO CH100	! If EQ, no.
	.TEST STATS "FOR"		! Is device mounted foreign ?
	.IF <STRLEN> <> 0 .GOTO CH120	! If NE, yes.
;
;	Device "'DEVICE'" is mounted as a files-11 disk, please try again.
;
	.GOTO CFAIL			! Go display the device status.
.CH100:
	.TEST STATS "ALU"		! Device allocated to this terminal ?
	.IF <STRLEN> <> 0 .GOTO CH110	! If NE, yes.
	.SETT ALLFLG			! Show we allocated the device.
	.IFF DEBUG .ENABLE QUIET
	ALL 'DEVICE'			! Try to allocate this device.
	.DISABLE QUIET
	.IF <EXSTAT> = 1 .GOTO CH110	! If success, continue ...
;
;	Device "'DEVICE'" could not be allocated, please try again.
;
	.SETF ALLFLG			! The device is not allocated.
	.RETURN				! Return failure ...
.CH110:
	.IFF DEBUG .ENABLE QUIET
	MOU 'DEVICE'/FOR		! Try to mount device foreign.
	.DISABLE QUIET
	.IF <EXSTAT> = 1 .GOTO CH120	! If success, continue ...
	.IFF DEBUG .ENABLE QUIET
	DEA 'DEVICE'			! Deallocate the device.
	.DISABLE QUIET
;
;	Device "'DEVICE'" could not be mounted foreign, please try again.
;
	.RETURN				! Return failure ...
.CH120:
	.SETT STATUS			! Set successful status.
	.RETURN				! All done for now ...
.CFAIL:
;	The following is the status of device "'DEVICE'"
;
	.IFF DEBUG .ENABLE QUIET
	.SETS DEV DEVICE[1:2]		! Copy the device mnemonic.
	DEV 'DEV':			! Display the device status.
	.DISABLE QUIET
	.RETURN				! Return failure ...
