/*
 *    ***************
 *    *  N S P . H  *
 *    ***************
 *
 * This file contains symbolic and structure definitions
 * for use with the CN Library functions.
 *
 * **NOTE**
 *
 *    INCLUDE CX.H PRIOR TO THIS FILE
 *
 *
 * Edits:
 *
 * 01 27-Feb-83 RBD  Initial edit
 */


/*
 * Get Local Node Information data block
 */
struct gln_dat {
               char     g_lnod[6];     /* Local node name, ASCII blank filled */
               word     g_lseg;        /* Default NSP segment size, bytes */
               };


/*
 * Transmitted connect block (used with netcon())
 */
struct t_conb  {
               /*
                * Destination descriptor
                */
               char     n_rnd[6];      /* Remote node name, blank filled */
               byte     n_rfm;         /* Descriptor format (0 or 1) */
               byte     n_rot;         /* Remote object type (0-255.) */
               word     n_rdec;        /* Remote task name length, bytes */
               char     n_rde[16];     /* Remote task name, ASCII */
               /*
                * Access control information
                */
               word     n_ridc;        /* Byte count of req. user ID */
               char     n_rid[16];     /* Requesting user ID, ASCII */
               word     n_rpsc;        /* Byte count or req. password */
               char     n_rps[8];      /* Requesting task password, ASCII */
               word     n_racc;        /* Account number byte count */
               char     n_rac[16];     /* Account number, ASCII */
               };


/*
 * Received (mailbox) connect block
 */
struct r_conb  {
               word     n_ctl;         /* Mailbox message queue link */
               word     n_segsz;       /* NSP segment size */
               /*
                * Destination descriptor
                */
               byte     n_dfm;         /* Descriptor format (0 or 1) */
               byte     n_dot;         /* Remote object type (0-255.) */
               word     n_ddec;        /* Remote task name length, bytes */
               char     n_dde[16];     /* Remote task name, ASCII */
               /*
                * Source descriptor
                */
               char     n_snd[6];      /* Source node name, blank filled */
               byte     n_sfm;         /* Descriptor format (0 or 1) */
               byte     n_sot;         /* Remote object type (0-255.) */
               word     n_sdec;        /* Remote task name length, bytes */
               char     n_sde[16];     /* Remote task name, ASCII */
               /*
                * Access control information
                */
               union {
                     struct{           /* If no access verification */
                           word     n_cidc; /* Byte count of req. user ID */
                           char     n_cid[16]; /* Req. user ID, ASCII */
                           word     n_cpsc; /* Byte count or req. password */
                           char     n_cps[8]; /* Req. task password, ASCII */
                           word     n_cacc; /* Account number byte count */
                           char     n_cac[16]; /* Account number, ASCII */
                           } novfc;
                     struct{           /* If access verification performed */
                           char     n_cdev[2]; /* Default device name, ASCII */
                           byte     n_cuni; /* Default device unit # */
                           byte     n_xx1;  /* Unused */
                           word     n_cuic; /* Login UIC */
                           byte     n_xx2[40]; /* Unused */
                           } vfc;
                     } accdat;
               /*
                * Optional data (always present when using CN-Library)
                */
               word     n_cdac;        /* Byte count of opt. message */
               char     n_cda[16];     /* Optional message buffer */
               };

/*
 * Symbolic definitions.  Extracted from NSDEF$ macro expansion
 */

/*
 * Known object number codes ((*) = Added by Bob Denny. Non-std codes)
 *
 * This list contains all known DECnet objects currently assigned.
 * Some are obsolete.
 */
#define NO_TAS 0	/* GENERAL TASK, USER PROCESS */
#define NO_FA1 1	/* FILE ACCESS LISTENER (FAL-V1) */
#define NO_URS 2	/* (*) UNIT RECORD SERVICES (URDS) */
#define NO_ATS 3	/* (*) APPLICATION TERMINAL SERVICES (ATS) */
#define NO_CTS 4	/* (*) COMMAND TERMINAL SERVICES (CTS) */
#define NO_TC1 5	/* RSX-11M TASK CONTROL LISTENER (TCL-V1) */
#define NO_OSI 6	/* (*) OPERATOR SERVICES INTERFACE */
#define NO_NRM 7	/* (*) NETWORK RESOURCES MANAGER */
#define NO_327 8	/* (*) IBM 3270-BSC GATEWAY */
#define NO_278 9	/* (*) IBM 2780-BSC GATEWAY */
#define NO_379 10	/* (*) IBM 3790-BSC GATEWAY */
#define NO_TPS 11	/* (*) TPS APPLICATION */
#define NO_DBL 12	/* (*) RT-11 DIBOL APPLICATION */
#define NO_T2T 13	/* (*) TOPS-20 TERMINAL HANDLER */
#define NO_T2S 14	/* (*) TOPS-20 REMOTE SPOOLER */
#define NO_TCL 15	/* RSX-11M/M+ TASK CONTROL LISTENER (TCL-V2) */
#define NO_TLK 16	/* RSX-11M/M+ TALK UTILITY (LSN) */
#define NO_FAL 17	/* FILE ACCESS UTILITY (FAL/DAP - V4 AND LATER) */
#define NO_RTL 18	/* RSX-11S REMOTE TASK LOADER (HLD) */
#define NO_NCU 19	/* NETWORK MANAGEMENT LISTENER (NML/NICE) */
#define NO_RFT 20	/* (*) RSTS/E MEDIA TRANSFER PROGRAM (NETCPY) */
#define NO_RTM 21	/* (*) RSTS/E TO RSTS/E NET COMMAND TERMINAL HANDLER */
#define NO_NML 22	/* (*) MAIL LISTENER (DECNET ELEC. MAIL SYSTEM) */
#define NO_REM 23	/* (*) REMOTE TERMINAL HANDLER - HOST SIDE (REMACP) */
#define NO_RMH 24	/* (*) REMOTE TERMINAL HANDLER - TERMINAL SIDE (RMHACP) */
#define NO_MIR 25	/* (*) LOOPBACK MIRROR OBJECT (MIR) */
#define NO_EVL 26	/* (*) EVENT RECEIVER (EVR) */
#define NO_VML 27	/* (*) VMS PERSONAL MAIL UTILITY */
#define NO_FTS 28	/* (*) FILE TRANSFER SPOOLER (FTS) */
#define NO_PHO 29	/* (*) VMS PHONE UTILITY */
#define NO_DMF 30	/* (*) DISTRIBUTED DATA MANAGEMENT FACILITY (DDMF) */
#define NO_X25 31	/* (*) X.25 GATEWAY ACCESS SERVER */
#define NO_DTR 63	/* DECNET TEST RECEIVER (DTR) */

/*
 * Network data (mailbox) message type codes
 */
#define NT_CON 01	/* CONNECT */
#define NT_INT 02	/* INTERRUPT MESSAGE */
#define NT_DSC 03	/* USER SYNCHRONOUS DISCONNECT */
#define NT_ABT 04	/* USER ABORT */
#define NT_ABO 05	/* NETWORK ABORT */
#define NT_EVT 06	/* NETWORK EVENT */
#define NT_VFY 07	/* NETWORK VERIFICATION EVENT */
#define NT_MOP 010	/* MOP EVENT */
#define NT_NSP 010	/* NSP EVENT (CCB ONLY). SAME AS NT_MOP */

#define VS_NPV 01	/* VERIFIED, NON-PRIVILEGED USER */
#define VS_PRV 02	/* VERIFIED, PRIVILEGED USER */
#define VZ_NVD 00	/* NO VERIFICATION PERFORMED */
#define VE_FAI 0177777	/* VERIFICATION FAILED */

/*
 *	Phase III session control error reason codes returned
 *	with reject (REJ) or disconnect (DSC)
 */
#define NE$RES 1	/* RESOURCE ALLOCATION FAILURE (REJ) */
#define NE$NOD 2	/* DEST. NODE NAME DOES NOT MAP TO NODE ADDRESS (REJ) */
#define NE$NSR 3	/* REMOTE NODE SHUTTING DOWN (REJ) */
#define NE$UOB 4	/* DESTINATION PROCESS DOES NOT EXIST (REJ) */
#define NE$FMT 5	/* INVALID FORMAT FOR OBJECT SPECIFICATION (REJ) */
#define NE$MLB 6	/* MAILBOX FULL FOR QUEUING MESSAGE TO OBJECT  */
	 		/*  OR TOO MANY CONNECTS TO OBJECT (REJ) */
#define NE$ABM 8	/* LINK ABORTED BY MANAGEMENT (DSC) */
#define NE$NNF 10	/* NODE NAME FORMAT ERROR (REJ) */
#define NE$NSL 11	/* LOCAL NODE SHUTTING DOWN (REJ) */
#define NE$ACC 34	/* ACCESS NOT PERMITTED - UNACCEPTABLE */
			/*  RQSTRID / PASSWORD ETC. (REJ) */
#define NE$ABO 38	/* NO RESPONSE FROM OBJECT (REJ/DSC) */
#define NE$COM 39	/* UNABLE TO COMMUNICATE WITH NODE (REJ/DSC) */
