/*
 * V4.0 style Task Control Block (TCB)
 *
 * INCLUDE CX.H PRIOR TO INCLUDING THIS FILE
 *
 * Include EXEDF.H for various symbolics
 *
 * Bob Denny
 * 19-Oct-82
 */
struct tcb     {
               address     t_lnk;      /* Utility link word */
               byte        t_pri;      /* Task priority */
               byte        t_ioc;      /* Outstanding I/O count */
               address     t_cpcb;     /* Checkpoint PCB */
               rad50       t_nam[2];   /* Task name (RAD50) */
               address     t_rcvl[2];  /* Receive Q listhead */
               address     t_astl[2];  /* AST Q listhead */
               word        t_eflg[2];  /* Local event flags */
               struct ucb *t_ucb;      /* TI: UCB address */
               struct tcb *t_tcbl;     /* Task list (TCB's) link */
               word        t_stat;     /* Status word (blocking bits) */
               word        t_st2;      /* Status word (state bits) */
               word        t_st3;      /* Status word (attribute bits) */
               byte        t_dpri;     /* Task default priority */
               byte        t_lbn[3];   /* LBN of task image */
               struct ucb *t_ldv;      /* UCB of load device */
               address     t_pcb;      /* Task PCB address */
               word        t_mxsz;     /* Maximum task size */
               struct tcb *t_actl;     /* Active task list link */
               address     t_sast;     /* Specified AST listhead */
               byte        t_res1;     /* Reserved */
               byte        t_tio;      /* Buffered I/O count */
               word        t_tksz;     /* Task size */
               address     t_att[2];   /* Attachment descriptor listhead */
               address     t_off;      /* Task image partition offset */
               byte        t_res2;     /* Reserved */
               byte        t_srct;     /* EFN count */
               address     t_rrfl[2];  /* Receive by reference listhead */
               address     t_ocbh[2];  /* Offspring control listhead */
               word        t_rdct;     /* Offspring count */
               word        t_eflm[2];  /* Event flag mask word */
               byte        t_hdln;     /* Task header length, 32-word blks */
               };
