@comment[	-*-Text-*-	]
@Part(CKMKER,root="KER:KUSER")
@string(-ckmver="@q<0.8(31)>")
@define(exx=example,above 2,below 1)
@Chapter<MACINTOSH KERMIT>

@Begin<Description,Leftmargin +12,Indent -12,spread 0>
@i(Program:)@\Bill Catchings, Bill Schilit, Frank da Cruz, Columbia
University.

@i(Language:)@\C (SUMACC)

@i(Documentation:)@\Frank da Cruz, Bill Schilit

@i(Version:)@\@value(-ckmver)

@i(Date: )@\June 13, 1985
@end<Description>

@index<Macintosh Kermit>
@index<CKMKER>
Macintosh Kermit, or @qq[MacKermit], is an implemtation of the Kermit file
transfer protocol for the Apple Macintosh (and Macintosh-XL) computer,
developed at Columbia University, based on C-Kermit (which also forms the
nucleus of Unix Kermit).

@subheading<MacKermit Capabilities At A Glance:>
@begin<format,leftmargin +2,above 1,below 1>
@tabclear()@tabset(3.5inches,4.0inches)
Local operation:@\Yes
Remote operation:@\Yes (server mode only)
Login scripts:@\No
Transfer text files:@\Yes
Transfer binary files:@\Yes
Wildcard send:@\No
File transfer interruption:@\Yes
Filename collision avoidance:@\Yes
Can time out:@\Yes
8th-bit prefixing:@\Yes
Repeat count prefixing:@\Yes
Alternate block checks:@\Yes
Terminal emulation:@\Yes (VT100,VT102)
Communication settings:@\Yes
Transmit BREAK:@\Yes
Support for dialout modems:@\No
IBM mainframe communication:@\Yes
Transaction logging:@\No
Session logging:@\No
Debug logging:@\No
Packet logging:@\No
Act as server:@\Yes
Talk to server:@\Yes
Advanced server functions:@\No
Local file management:@\Yes
Command/Init files:@\Yes
File attributes packets:@\No
Command macros:@\No
Raw file transmit:@\No
@end<format>

The main differences between MacKermit and other Kermit programs are:
@Begin(Itemize)
In MacKermit you are always connected via a terminal emulator (VT102).

MacKermit commands are issued by means of pull-down menus that overlay
your terminal session.  
@End(Itemize)

The major menus are @b(File), @b(Settings), @b(Remote), and @b(Transfer).  The
@b(File) menu invokes Kermit's file transfer functions, allows settings to be
saved and restored, and like most Macintosh applications, includes a "quit"
selection for leaving the program.

The @b(Settings) menu provides dialog boxes for file, communications, and
protocol settings.  The @b(Remote) menu has the commands that can be
sent to Kermit servers, as well as an option to turn Macintosh Kermit itself
into a server.  The @b(Transfer) menu gives you a standard Macintosh file box,
allowing you to transfer directly to the selected application.

@Section(The Macintosh File System)

The Macintosh file system consists of one or more disks, each disk containing
files.  All files on a disk must have a unique name.  Files may be
collected together into @qq[folders], but folders are not analogous to
directories on other file systems, and no two folders on the same disk may
contain files of the same name.  Macintosh file names may contain practically
any printable characters, including space and punctuation -- but colon (@qq[:])
should be avoided because it is used in device names.

@Section(File Transfer)

@i<Glossary>:

@Begin(Itemize)
@u<Mode> - Text or Binary.  Binary means the data is sent or stored without
modification. Text means that every carriage return character (CR) in a
Macintosh file is translated to a carriage-return-linefeed (CRLF)
sequence when sending, and every CRLF in an incoming file is turned into
a CR when stored on the Mac disk.  A text file is produced when you
save a file from MacWrite using the "text only" option; text files are
not associated with any particular Macintosh application and can be
sent in a useful fashion to other kinds of computers.

@u<Fork> - Data or Resource.  Macintosh files may have two "forks".  The data
fork contains data for an application; the resource fork contains icons,
strings, dialog boxes, and so forth.  For instance, a MacWrite document
contains text and formatting information in the data fork, and fonts in
the resource fork.  For applications, the executable code is stored in the
resource fork.
@End(Itemize)

Macintosh Kermit supports the standard Kermit commands for transferring
files -- Send, Receive, and Get.  Invocation of any of these commands
produces a MacKermit file dialog box in which you specify the file name, the
mode, and the fork.  Defaults are determined from the selected file or
taken from the current file settings, described below.

When you select the Send command, you get a MacKermit file open box, which
includes the standard Macintosh dialog items -- a file list, Disk and
Eject buttons, etc.  You can only send one file at a time, by clicking on
its name in the file list.  Clicking the Disk button will switch the file
list to another physical disk.  If desired, you can type an alternate name
to send the file under.  When you select a file, MacKermit examines its
type; if the type is APPL, then MacKermit expects to send the resource fork
in binary mode, otherwise the data fork in text mode.  The Mode and Fork
radio buttons will display these choices; you may change them before clicking
the Send button.  

You can receive or get multiple files, providing the opposite Kermit is
capable of sending multiple files in a single transaction (most are).  As
files arrive, they will be decoded according to the current mode (text or
binary), and stored in the default fork (data or resource) under either the
name they arrive with (overwriting existing files of the same names) or
under new unique names (when name conflicts occur), according to the current
default for name collisions.  You may also elect to perform an "attended"
receive, in which you have an opportunity to override all file defaults on a
per-file basis.  But this option must be used with caution -- if you take
too long (more than about a minute) to execute an incoming file's dialog
box, the opposite Kermit could time out and terminate the transaction.

The folder for new files is the same as the location of the settings file,
or if no settings file was used then the new files appear on the desktop.
If you are transferring a lot of files and want to keep them together,
create a folder, drag the settings file into it, and double click on the
settings file; all created files will appear in that folder.

File transfers can be cancelled by clicking on the Cancel File or Cancel
Group buttons.  These will always work when sending.  When receiving, they
will work if the opposite Kermit honors this (optional) feature of the
protocol.

In any case, an "emergency exit" from any protocol operation can be taken at
any time by typing "Command-@q(.)" -- that is, hold down the Command (Fan,
Cloverleaf) key and type period.

@section(Remote Commands)

The @b(Remote) menu allows you to send commands to a Kermit server.  The
response from these commands (if any) is displayed in a special pop-up
window.  Responses to multiple Remote commands are separated by a dashed
line.  The response window can be scrolled, sized, and positioned, and can
be hidden by clicking the menu item "Hide Response" or the window's go-away
box; all text remains intact and will be appended to the next time you do a
Remote command; it can also be brought to the foreground by clicking the
Show Response menu item.  Note that typein to the terminal emulator will not
take effect when the response window -- or any other window -- is up front.

If the response window gets too full (i.e. fills up the free memory
available to the MacKermit application), the program will probably bomb.

If the remote Kermit server is in binary mode, its responses to Remote
commands may look strange.  For instance, a Unix Kermit server
in binary mode will send lines of text separated by only linefeeds,
rather than CRLFs.

A Remote command can be cancelled by taking the Emergency Exit (Command-@q<.>).

@section(Settings)

You can change File, Communications, and Protocol settings by using the
Settings pull-@|down menu.  You can save and restore these settings by
invoking the appropriate selection in the File menu.  If the bundle bit
has been correctly set on your version of MacKermit you can double-@|click
on the resulting document to start MacKermit with those settings.

The File settings establish the defaults for file transfer:
@Begin(Itemize)
@u<Mode>: text or binary.  Used for received files only.  When sending,
MacKermit tries to figure out an appropriate mode for the file being
sent (but then lets you override it the Send File dialog).

@u<Fork>: which fork -- data or resource -- to send, or to store an incoming
file into.

@u<Naming>: Whether incoming files should supersede existing files of the same
name, or a new unique name should be assigned to them.  If the latter, the
new name is formed by adding a dot and a number to the end.  For instance,
if a file called FOO exists and a file called FOO arrives, MacKermit will
store the arriving file as FOO.1; if FOO.1 exists, then FOO.2, etc.

@u<Attended> versus @u<Unattended> operation for incoming files.
@End(Itemize)

The Communications settings allow you to set the baud rate (anywhere
between 300 baud and 57@q<.>6K baud), parity (odd, even, mark, space, or none),
and duplex (full - remote echo, half - local echo).

The Protocol settings allow you to set packet parameters for both incoming
and outbound packets.  These include the block check type (1 or 2
character checksum, 3-character 16-bit CRC-CCITT), line turnaround handshake
character (for file transfer with half duplex systems), packet start and end
characters, padding, packet length, timeout interval, and so forth
(Refer to Kermit User Guide).  Characters are specified by entering their
ASCII value in decimal, e.g. 1 for Control-A, 13 for Control-M (Carriage
Return), etc.

@Section<Terminal Emulation>

MacKermit provides a subset of the features of the DEC VT102 terminal; the
VT102 is a VT100 with line and character insert/@|delete
functions added.  The functions provided are sufficient to allow MacKermit
to act as a terminal for EMACS as it exists on the DEC-20, VAX (CCA EMACS on
VMS or UNIX), and for most host-@|resident display-oriented applications that
expect to do cursor positioning and editing on the VT100 screen.  MacKermit
does not currently support the following VT100/102 functions:
@Begin(Itemize,spread 0)
double height or double width lines

cursor position report

the VT100 graphics character set

autowrap control
@End(Itemize)
(this is not an exhaustive list)

The keyboard is set up by default as follows: The COMMAND (Fan, Cloverleaf) key
is used as the Control key.  The CAPS LOCK key forces all alphabetic characters
to upper case, and causes keys on the numeric keypad to send VT100 keypad
escape sequences.  The OPTION key is "Control-Meta" (explained below).  The
terminal emulator sends ESC (escape) when the @qq(`) key is pressed unshifted.
The character @qq(`) can be sent by typing Control (Command) and the same key.
The Backspace key sends a Delete (Rubout) and Control-@|Backspace sends a
Backspace.  The Enter key sends a "short" (250ms) BREAK signal.

MacKermit (V0.8 and later) comes with a separate key configuration program,
CKMKEY, which lets you change the behavior of the keys, define function keys,
and so forth.  CKMKEY is described in detail below.

MacKermit honors your parity communications setting by using built-in
functions of the Mac's serial i/o chip.  Unfortunately, the chip has an
unpleasant quirk -- arriving characters that do not have the specified
parity are discarded rather than passed to the requesting application.
Thus, if you are connected as a terminal using MacKermit to a device that
requires, say, odd parity on characters sent to it, but does not put odd
parity on characters it sends to you, then many incoming characters will
not appear on your screen.

Most VT100 character attributes (bold, underline, inverse) are honored.
However, they are not preserved after a window (e.g. the puzzle) has
overlaid the screen; the characters will still be there, but without any
special attributes.

To allow useful coexistence of desk accessories and Kermit, the terminal
emulation may be dragged using the drag bar.  A desk accessory that overlays
the Kermit window can be clicked upon to move it behind the Kermit window,
and then the Kermit window can be dragged to reveal the hidden desk accessory
so that it can be restored to the foreground.  The same thing can be done
with Kermit's own remote response window.  Note that Kermit's terminal
emulation window does not accept input when any other window is in the
foreground.

The following features are missing from the MacKermit terminal emulator,
and may be added in subsequent releases:
@Begin(Itemize,Spread 0)
capturing text from the screen (e.g. cutting to clipboard, saving off top)

screen rollback, sizing

modem or dialer control

login scripts

transmission of raw text to host (e.g. pasting to screen)

printer support
@End(Itemize)

MacKermit does not use XON/XOFF flow control during terminal emulation or file
transfer.  The terminal emulator can normally keep up at 9600 baud, but after
several continuous scrolling screens at this speed, some characters may be
lost.  In the present version, when running at high baud rates keep your
terminal in page mode, or use "more", or view text with a non-@|scrolling
screen editor.  Also, don't drag the terminal emulation window while characters
are arriving; if you do, the characters will be lost and the display will
become confused.

@Section<Installation>

MacKermit is distributed in source form for building on Unix (or VMS/Eunice)
systems that have the Stanford SUMACC Macintosh cross-@|development tools, in
@index<Binhex>
@q(.HQX) "binhex" form, and sometimes also as a binary resource file.  Those
who want to work from the source are referred to the file @q(CKMKER.BLD) for
instructions.

If you have the binary resource file available (its name will be
@q(CKMKER.RSRC), @q(ckmker.rsrc), @q(CKMKER.RSR), @q(ckmker.rsr), or some
variation on these, depending on what system it's stored on and how it got
there), AND if you have "MacPut" on your system and MacTerminal on your Mac,
AND if you have an 8-bit-wide (no parity) data path between your Mac and your
system, use MacPut to download the binary resource file to MacTerminal's XMODEM
@index<Setfile>
option on your Mac.  After doing this you must use SetFile on the Mac to set
the author to KERM, the type to APPL, and turn on the bundle bit.  For CKMKEY,
the author should be KERK.

If you have an earlier release of Columbia MacKermit, you may use Kermit in
place of MacTerminal and MacPut.

If you don't have the binary resource file available, you can download
the @q(CKMKER.HQX) file in the same manner, then run "binhex" (version 4) on
it.

@Section<CKMKEY - Macintosh Kermit's Keyboard Configurator>

This describes CKMKEY V0.8(0), May 1985.

@index<CKMKEY>
The version number of CKMKEY indicates compatability with the like version of
CKMKER -- Macintosh Kermit, referred to simply as "Kermit" from now on.
Edit numbers (within parentheses) may differ.  If Kermit is used with a
settings file containing a key configuration produced by an incompatible
version of CKMKEY, then that configuration will be ignored.

@SubSection<What is CKMKEY?>

CKMKEY is a keyboard configurator program for use with Macintosh Kermit
(versions 0.8 and greater). CKMKEY allows:
@Begin(Itemize)
Redefinitions of keys

Definitions of multicharacter function keys

Selection of long and short BREAK keys
@End(Itemize)

CKMKEY is a separate program from Kermit.  It may be thought of as an editor
for Kermit's terminal emulator key definition resource, which is kept in a
Kermit settings file.  Before you can use CKMKEY, you must already have used
Kermit to create a settings file to operate on.

The reason CKMKEY is separate from Kermit is that there is not enough room in
the memory of a 128K Macintosh to hold a program that can do both.  CKMKEY
displays and changes key settings, Kermit uses them.  Once you have started
Kermit with a given set of key definitions, there is no way to examine or
change them.

Some familiarity with the ASCII alphabet is assumed in the following
discussion.

@SubSection<Modifier vs Normal Keys>

The Macintosh keyboard is composed of normal keys and modifier keys.  Modifier
keys are SHIFT, CAPS LOCK, OPTION, and COMMAND (also known as APPLE, CLOVER, or
FAN).  Only one normal key can be selected at a time, but one or more modifier
keys can be depressed along with it.

@subSection<Key Maps>

When a key on the keyboard or numeric keypad is depressed the result is a scan
code -- a number between 0 and 127 (see Inside Mac Event Manager for details if
you're interested).  A table indexed by scan code resulting in the character to
be displayed or transmitted will be referred to as a "keymap" or "key mapping."

On the standard Mac many keymaps exist -- the modifier keys (such as SHIFT)
specify which keymap is selected.  For example, when no modifer keys are
depressed the keymap contains the lowercase alphabet, numbers and some
punctuation.  The keymap in use when the SHIFT modifer is depressed contains
the capital letters and special characters.

All in all it is possible to select 16 different keymaps by depressing from
zero to four modifier keys.  Normally however, 6 or so distinct keymaps will
suffice.

CKMKEY allows you to redefine 6 keymaps: shifted and unshifted combinations of
keymaps named "normal", "capslock", and "control".  These keymaps are
predefined with the expected values -- the control map is preloaded with
control codes, the capslock preloaded with the unmodifed keymap but with all
letters uppercase.

In this document modifier keys are written in capital letters and key map names
are written in lowercase.  SHIFT, CAPS LOCK, COMMAND, and OPTION are
modifier keys, "normal" "capslock" and "control" are key maps internal to
CKMKER.  Since one of the major functions of CKMKEY is to change maps
invoked by modifier keys, it is important to keep this distinction in mind.

@SubSection<What's in CKMKEY's Keymaps>

A keymap is a list of 128 numbers.  Which keymap is selected depends upon which
modifier keys are depressed, and the entry within the key map is determined by
the scan code.  A keymap entry is an 8-bit quantity:  if the high order bit is
0, then the entry is the 7-bit ASCII character to be transmitted through the
serial port; if the high bit is 1, then the remaining 7 bits
are an index into the function-key table.

Notice that only single 7-bit values can be directly translated through the
CKMKEY keymap.  If you want a single key to transmit multiple characters, then
you can designate that key to be a "function key", and the key map will contain
an indirect reference to the function-key table.  If you want a key to transmit
an 8-bit value, assign the "meta" operation to one of the modifier keys and use
the meta key together with the desired key (see below).

Functions are numbered 0-127 with the highest few being reserved for special
use.  Currently functions 126 and 127 send a short 250 millisecond BREAK signal
and a long 3.5 second BREAK respectively.  In the future more special functions
may be allocated so (since it is arbitrary anyway) please use low numbered
functions when defining your own.

@subSection<Menus>

CKMKEY has two menus, @b{File} and @b{Set}.  First you must use the @b{File}
menu to select and open a Macintosh Kermit settings file, which in turn has
been created using the Kermit Save Settings option from its own File menu.
Then use the @b{Set} menu to establish or alter key definitions, then use the
@b{File} menu again to save the settings file back for Kermit.  A variety of
Kermit settings files can be kept, each with its own collection of settings and
key definitions; Kermit can be started with the desired settings by double
clicking on one of these settings files from the Macintosh desktop.

Menus consist of options.  If an option is followed by an ellipsis (three
dots...) then clicking it will produce a dialog box of some kind; otherwise,
clicking it causes the indicated action to be performed immediately.  If an
option is dimmed then it is not available for some reason -- for instance, you
can't set any keys until you open a settings file.

@SubSection<MENU: Set>

The @b{Set} menu includes dialogs for setting keys, defining functions, and
reassigning modifier keys.

@Paragraph<DIALOG: Set Modifer Keys>

@i<Background>:

Skip ahead to the next section if you already know about things like SHIFT,
CAPS LOCK, CONTROL, and META.

On a typewriter the only modifier key is SHIFT.  Typing a character with no
modifier key depressed selects a lowercase letter or the character printed on
the lower face of the keytop (say, the digit "4").  Typing a character with
SHIFT depressed selects an uppercase letter or the character printed on the
upper face of the keytop (say, a dollar sign).  Some keyboards also have a
SHIFT LOCK key, which stays down once pressed and pops up the next time it's
pressed; its operation is equivalent to holding down SHIFT.  And some keyboards
have a CAPS lock key which operates like SHIFT LOCK, but only upon letters.

Computer terminals also have a modifier key called CONTROL (or CTRL).  Its
function is a little less obvious: it is intended to produce one of the 33
characters in the "control range" of the ASCII alphabet.  Control characters
are not graphic -- they are intended for use as format effectors (like carriage
return, formfeed, tab, backspace), for transmission control, or for device
control.  The remaining 95 characters -- letters, digits, and punctuation --
are the graphic characters.  When a character is typed with the CONTROL
modifier pressed, its "control equivalent" is transmitted.  By convention,
the control equivalent of A is Control-A, B is Control-B, etc, and there
are also seven special control characters generally associated with
punctuation characters or special keys.  For the "alphabetic" control
characters Control-A through Control-Z, SHIFT or CAPS LOCK modifiers are
ignored; for the others, operation varies from terminal to terminal.

The SHIFT and CONTROL modifiers allow all 128 ASCII characters to be sent from
a normal typewriter-like keyboard that has about 50 keys.  However, certain
host-resident computer applications -- notably the full screen text editor
EMACS and its descendents -- can be used to greater advantage with a 256
character alphabet (EMACS responds to single-character commands, and the more
characters a terminal can send, the more commands are directly available).
@index<META Key>
For this purpose, some terminals also provide a META modifier key.  This key
simply causes the high-order ("8th") bit of the selected ASCII value to be
set to 1 upon transmission.  META characters can only be transmitted when the
communication path allows all 8 bits to pass transparently; when this is not
possible, software like EMACS allows a sequence of two 7-bit ASCII characters
to represent a single meta character.  The advantage of having a real META
modifier key is that it can be held down while the actual key is struck
repeatedly or even autorepeats, whereas a use of a "meta prefix" requires much
more typing.  To illustrate, suppose META-F is the command to go forward one
word.  If you want to execute this operation repeatedly, just hold down META
and F and let it autorepeat.  If you don't have a META key, then you have to
use a "meta prefix" character (usually escape), and to enter META-F repeatedly
in this case, you'd have to type <escape>F<escape>F<escape>F...etc.

@i<Macintosh Kermit Modifier Keys>:

You can define the modifier key to keymap correspondence in CKMKEY by selecting
the "Modifer Keys..." menu item under SET, or by double clicking on a modifier
key while in the SET KEYS dialog.

The SET MODIFIERS dialog lets you define what map OPTION, CAPS LOCK and COMMAND
refer to.  Notice that SHIFT is missing -- SHIFT always references the shifted
equivalents to the normal, control and caps lock maps.

The dialog is layed out in columns with the three modifier keys as column
headings and the three map names below.  Also under each column is a "pseudo"
key map for "meta."

Meta is not a map, but an operation: it augments the value being transmitted
after it has been read from its map.  Meta can either be set to send a prefix
string before the character or to turn the high order (8th) bit on in the
transmitted character.  The default prefix for meta is set to be 033 (escape).
If a meta modifier key is depressed and the key results in a function reference
then no modification occurs; functions are not "metized".  However, functions
can be defined to include 8-bit values.

Notice that meta can be set in conjunction with a key map.  Since meta is an
operation as described above there is no ambiguity.  Consider for example
setting OPTION to reference the "control" map and selecting "meta" for this
modifier key as well.  The result is a control-meta key.  

@Begin(Quotation)
@i<@u(CAUTION)>: If you have used Kermit's communications settings menu
to select any parity other than "none", then any high order bits
that may be set by CKMKER's key mapping will be superseded when
Kermit applies the selected parity to outbound characters.
@End(Quotation)

The SET MODIFIER KEYS dialog also lets you select your meta preferences:
whether you want to use the 8th bit toggled on, or a prefix string.  The prefix
string is entered in the same manner as a function definition (backslash
followed by 3 octal digits for non-printable characters, see below).

Note that it is possible to cause ambiguities when selecting and using
modifier keys.  For example say you set OPTION to refer to the control map,
and you set CAPS LOCK to refer to the caps map; at this point if you hold
both OPTION and CAPS LOCK down it is unclear which map you want your
character to come from.  To try to prevent this type of ambiguity the SET
KEY dialog will beep when you are holding down or mousing an ambigous set
of modifier keys.

The Kermit code itself references maps in this precendence: if a control map
modifier is depressed then use control map, else if a capslock modifier is
depressed use capslock, otherwise use the normal map.

A sample modifier key configuration is shown in Figure @ref<-macmkey>.
@Begin(Figure, Use Example)
@bar()
@blankspace(1)
                 OPTION          COMMAND         CAPS LOCK

                 o  Normal       *  Normal       o  Normal
                 *  Control      o  Control      *  Control
                 o  Caps         o  Caps         o  Caps
                [X] Meta        [X] Meta        [ ] Meta
@caption(Macintosh Kermit Modifier Key Dialog)
@tag<-macmkey>
@bar()
@End(Figure)
Here the CAPS LOCK key is used to reference "control", the COMMAND key to do
the "meta" operation, and OPTION is "control-meta".  Holding down COMMAND and
CAPS LOCK together will also result in control-meta.

@Paragraph<DIALOG: Set Function Definitions>

@i<Background>:

Skip to next section if you know what function keys are.

Many popular terminals have "function keys" in addition to the alpabetic,
numeric, punctuation, and modifier keys described above.  Function keys are
usually labeled F0, F1, F2, ..., or PF1, PF2, ...  On some terminals, like the
DEC VT100, the function keys send predefined sequences of characters -- for
instance PF1 sends three characters: ESCAPE (ASCII 033), followed by "O", and
"P".  On others, the function keys may have arbitrary strings assigned to them.
For instance, if you find yourself typing "Aaaarrrgggghhh!!! Sigh..." a lot,
you can assign this string to function key F1, and then pressing the F1 key
will cause this entire character string to be transmitted.

@i<Macintosh Kermit Function Keys>:

The Macintosh has no physical function keys -- no keys are marked F0, F1,
F2, etc.  However, any key (modified by any combination of modifier keys) may
be designated as a "soft" function key.

Selecting "Function Definitions..." from the SET menu brings you to the SET
FUNCTIONS dialog (it would be nice if you could double click on a function
key in the SET KEYS dialog but that is not yet available).

Use SET FUNCTIONS to declare a function definition string.  Scroll through the
function definition list and select a function to define, preferably starting
with F0, though this is not required (high numbered functions are reserved for
special uses).  Type in the function definition; non printable characters must
be entered with a backslash ("\") followed by exactly (yes exactly) three octal
characters representing the ASCII value, for instance "\015" for carriage
return.  A backslash itself is entered as "\134".  The function definition has
to fit in the box.

Having defined a function, you must use SET KEYS to actually associate it with
a key.  Note that it is possible to associate a function with more than one
key.


@Paragraph<DIALOG: Set Keys>

Selecting the "Keys..." menu item under SET initiates the SET KEYS dialog
for redefining individual keys.

SET KEYS displays a picture of the keyboard.  You can either hold down the
modifier and key you wish to define or click on the displayed picture with the
mouse (double clicking on one of the modifier keys brings up the SET MODIFIER
KEYS dialog).  Once a key is selected, it and any modifiers are highlighted,
the name of the key and its value are displayed in the lower portion of the
dialog.  You may enter the new value in the little box by selecting the box
with the mouse and then typing a DECIMAL (yes decimal) number from 0 to 127.
Then you should click on either SET KEY or else SET FUNCTION KEY.  Clicking on
SET KEY means that the key should transmit the ASCII character corresponding to
the given value (subject to modification by the meta key); clicking SET
FUNCTION KEY means the number you entered in the box is a function number and
that the key should transmit the character string associated with that
function.

SET KEYS does not display a picture of the numeric keypad, but may be used with
the keypad anyway -- just select the desired key by pressing it and then define
it as above.


@SubSection<MENU: File>

The File menu must be used to Open a Kermit settings file before CKMKEY will
allow you do perform any other operations.  You may also Quit from CKMKEY
through the File menu, and you can save your work.  The Save option allows
you to save the settings file back under its own name, replacing the previous
copy.  If you need to make copies of settings files, you can use Kermit itself
to save them under different names, or else you can use the Finder.

There is also a Decompile option, that is of use only to programmers working
on Macintosh Kermit -- it decompiles the key definition resource into a form
that can be included in a C program.

@subSection<CKMKEY Known Limitations, Restrictions, Bugs>

@Begin(Itemize)
There is no picture of the numeric keypad in Set Keys.

In Set Keys, when you strike a key on the numeric keypad, its name is not
displayed.  You can still make assignments to the key.

You can't save from CKMKEY under a different name.  Use the Finder or Kermit
to do that.

You must use decimal numbers in the SET KEY dialog, and backslash followed
by 3 octal digits in function definitions, which can be confusing.

You may have problems on a 128K mac if you define many long functions.

CKMKEY doesn't deal with write protected diskettes very well.
@End(Itemize)

@subSection<Unlocking CAPS LOCK>

(Adapted from directions posted by David Chase @q(<rbbb@@rice>) on
@q(INFO-MAC@@SUMEX-AIM), Friday 14 December 1984.  Follow these instructions at
your own risk.  Not the authors, nor David Chase, nor Columbia University, nor
Rice University provide any warranty, nor acknowledge any liability or
responsibility for damage, injury, inconvenience, or loss of Apple or other
service warranty sufferred as a result of the publication of these directions.)

A major impediment to using the Macintosh as a terminal is that the CAPS LOCK
key is where you would normally expect to find the CONTROL key.  A key
redefinition package, such as CKMKEY, can assign the CONTROL function to the
COMMAND or OPTION keys but these keys are not easy to reach.  CONTROL can
also be assigned to the CAPS LOCK key using software, but the CAPS LOCK key
includes a mechanical locking device.  The following directions tell how to
remove the locking device so that the CAPS LOCK key will go up and down
like the other keys.  PROCEED AT YOUR OWN RISK.

Tools you'll need:
@Begin(Itemize,spread 0.25)
Phillips screwdriver for screws on bottom of the keyboard.

Solder sucker/wick.

Soldering iron.

Small prying tools (jewelers screwdrivers, small knife blade, etc).

Tweezers/small needlenose pliers.

Some paper clips or straight pins.
@End(Itemize)

Now follow these steps:
@Begin(Enumerate)
Remove the five screws.  The keyboard should fall into three pieces.

GENTLY pry off the Caps Lock keycap.  This takes a little patience.

Remove the restoring spring so it doesn't get in the way.

Locate the two connections to the Caps Lock key on the back of the PC
board, and remove all solder from them using wick or sucker.  Be
careful not to overheat the solder pads, since they can be damaged
(come loose from the PC board).

Pry back the plastic locking clips holding the key in, and remove it.
(All the keys are clipped into a metal frame.  Removing the metal frame
is not possible, since all the keys are soldered to the PC board, and
clipped to the frame.  The clips are located "north" and "south" of the
key, where the number row is "north" and the space bar "south".)
There are four clips holding the bottom of the key on; pry these back,
and, WHILE HOLDING THE KEY BOTTOM UP, remove the bottom of the key.
You may have to use some makeshift tools, like a couple of unbent paper clips,
to hold the four clips open.

Two pieces should be ready to fall out; a small piece of PC-board-like
material (about 7/16 by 3/32 inch, with two notches on one edge and a
tiny hole in the center), and a tiny piece of wire (a small, beefy
staple with short legs).  Let them fall out. (It may help to toggle the
key).  These two pieces are the locking device, they should be removed
and left out of the reassembly.

Replace the restoring spring, snap the key back into place, resolder
the two leads, screw the keyboard back together, and replace the key
cap.  You may wish to experiment with the spring to reduce the key's
springiness (this can be done with the keyboard assembled, though
removing the cap is more difficult).
@End(Enumerate)
