.m1 4
.m2 0
.m3 0
.m4 4
.#.pl 66
.pl 81
.rm 110
.rh
.fi
.na
.ce 6
LOADABLE DEVICE DRIVER DATA BASES
IN RSX11M SYSGEN

Carl T. Mickelson
Goodyear Aerospace Corporation
Akron, Ohio 44315
.sp 3
.rm 86
.rh
.in +24
.ce 1
.ul 1
ABSTRACT
In order to support multiple and differing configurations of peripherals on
different computer systems, a method for modifying RSX11M SYSGEN is discussed
that allows device drivers to be built with loadable, rather than resident,
device data bases.
System tailoring is done at VMR-time when the particular devices for each
configuration are included in the bootable system image.
The method allows the addition of new devices without a new SYSGEN.
.in -24
.rm 52
.rh
.sp 4
.ce 1
INTRODUCTION

What do you do when your OEM employer's business is growing and he acquires
a room full of new computer systems for a variety of different customers?
Each system has a different configuration of discs and terminal interfaces
and you are expected to
provide a consistent software development environment on all these
different systems so that user's may build programs on any development
system and move them to any test stand system to check out your
product hardware.
The users don't want to be confronted with different operating procedures
on each machine and would like to move even privileged tasks, when
possible, from system to system without re-building them.
In addition, you don't want to be confronted with performing a new system
generation for every new system as it arrives.

It would be much more convenient to maintain a system generated for each
generic processor (11/34, 11/24, 11/40, 11/70) and memory configuration
and simply build an operating system for a new computer by selecting an
existing pre-generated system and specifying what devices are in the
configuration at VMR time.
Further, the tailoring of the terminal driver for different systems raises
an additional complication for systems having the same processor but
differing terminal I/O controllers.

This paper discusses a method of achieving this degree of hardware/software
independence for RSX11M, and discusses how this goal to provide a common
operating environment was achieved.
It should be noted that privileged tasks that map over the Executive can
still only be ported between systems with the same or similar processors
and the same memory address range (18 bit or 22 bit).
This represents an improvement over "vanilla" RSX11M since device
configuration is no longer a consideration.

.ce 1
ISSUES NEEDING CONSIDERATION

The principal method needed to achieve the goals stated above is to modify
the RSX11M SYSGEN procedure to make all DEC supplied device drivers look
like user-written drivers, each task-built containing its own loadable
device data base structure.
By doing this, device data structures are no longer resident in the Executive
task image (RSX11M.TSK), and individual devices can be configured into a
system by loading their data bases, together with their driver code at VMR
time.
In fact, the only device drivers that need to be present in the bootable
system image are the boot device and terminal device drivers.
All others can be loaded into GEN with a /HIGH switch in the system
startup file.
The ability to add additional devices is also enhanced, since a SYSGEN can now
be avoided.
There are, however, a number of issues that must be addressed in order for this
technique to be successful.

.pl -22
First, all link time references to I/O data structure symbols must be
eliminated, since the I/O data structures are no longer resident in the
Executive.
Without doing this, the link time references to .TT0 and .CO0 in the
Executive (SYSCM) and any privileged tasks such as the Pool Monitoring
Task (PMT) and the Console Output Task (COT) will produce undefined
references when they are task-built.

This requirement is satisfied by adding some code to the Executive module
INITL.MAC to walk down the device DCB chain when the virgin executive is
initially started to locate .TT0, the console terminal UCB address,
and .CO0, the console output UCB address.
Once found, these addresses are loaded into the required fields of SYSCM,
and RSX11M continues as if the data bases were resident.
Similar code is added to PMT and COT at their entry points, and
the references to these symbols are made indirectly to local copies of the
addresses.
This isolates these privileged tasks from the actual locations of the data
structures.

Second, the Executive module SYSTB.MAC, generated by SYSGEN during the device
configuration phase, must be split into individual files (xxTAB.MAC), one for
each type of device selected for inclusion in the SYSGEN process.
The only data structures remaining in SYSTB are the pseudo-device structures
for SY:, LB:, etc, and the clock queue list-head.
The device data base files must later be assembled with the RSX11M driver
sources, so additional commands must be added to RSXDRVASM.CMD.
Also, the driver task build command file, RSXDRVBLD.CMD, must be modified to
task build each driver with its own local data base.

Finally, to support different configurations of terminal interfaces on
systems with similar processors, a method must be found to build
multiple versions of the terminal driver.
Each version of the driver must have a loadable data base
structured for that particular system so that the driver for the proper
terminal configuration can be loaded at VMR time.
It is assumed that the full-duplex terminal driver is the driver of choice for
this effort as it provides full system functionality for the user.

.pl +22
.ce 1
DEVELOPING THE CHANGES

Once it is understood what must be done, a method must be developed to
automatically apply the changes when a system is to be generated.
This method should be applied in two parts.

The first part applies the needed changes to SYSCM and the privileged tasks
to eliminate the link time references discussed earlier.
These changes are required for the SYSGEN changes to be successful, but they
can stand alone so that the tasks do not directly access I/O structures at
link-time.

The second part of the modification package should apply the changes to the
SYSGEN procedure files, and should only be applied if the first part changes
are made.
These modifications amend the SYSGEN procedure to achieve the functionality
described earlier.

In order the develop the changes, a number of utilities are necessary, among
them the standard utilities SLP, PIP, MAC, TKB, etc, and a DECUS supplied
disassembler DOB.
This utility is needed to disassemble certain modules, delivered only in
object format so that they may be modified in source form, re-assembled and
re-inserted into their appropriate object library.

A trial SYSGEN was performed, stopping at all end of section and end of
execution breakpoints to study the state of the files produced by
SYSGEN.
The SYSGEN command files themselves were examined to determine where changes
had to be made and a set of command procedure (.CMD) and source update (.SLP)
files were developed to apply the changes automatically.
The specific modifications made to the SYSGEN procedure are discussed below.

.ce 1
SYSGEN PROCEDURE CHANGES

The default option for all device drivers is set loadable, and this specific
question is eliminated from the SYSGEN dialogue.
The need for this is self-evident since the desired goal is to make a system
with loadable device data bases.
Also, the user is given the opportunity to include the Executive routines
$PTWRD and $GTWRD regardless of whether user-written device drivers are to
be included during the system generation.
This is done to insure that these routines are available if a user-written
driver will be incorporated at some future time.

Additional questions are added to the procedure to allow the user to establish
an identifier (xxx) for each specific version of the terminal driver and
system executive configuration being simultaneously generated for a common
processor type.
This identifier is appended to the terminal driver task and symbol table file
names, and to the Executive symbol table and bootable system file names to
designate the system configuration pertinent to each set of files.

A tailored system VMR command file (SYSVMRxxx.CMD) is generated for each
individual system configuration, and the user is given the opportunity to
specify the device drivers that should be included in the system image prior
to the first bootstrap.
The balance of the VMR file is tailored to install only those
privileged tasks needed for support of the devices loaded into the system
image.
Thus, if DUDRV is loaded, RCT is installed, and queue manager support is
included only if LPDRV has been loaded.

Finally, just before VMR is invoked to create a bootable image, the user is
permitted to select the version of the system and hence TTDRV version to be
used to create the bootable system image for the SYSGEN host system.

The modified procedure, when completed through Phase II creates a set of
virgin system (RSX11Mxxx.SYS) files that can be moved to another disc
medium and together with the drivers and privileged tasks in [1,54],
libraries in [1,1] and other system directories such as [1,2] can be used
to VMR another system for a different hardware configuration.
The resulting system can be booted on the new system configuration and
has the same Executive and resident library characteristics as the
originally VMR'ed system.

.ce 1
USING THE MODIFICATION KIT

The modifications described here are performed by a set of command procedures
that will be available on the RSX SIG tape from the New Orleans DECUS.
They should be used in accordance with the following procedure.

First copy the RSX11M baseline distribution kit to scratch media as
described in the RSX11M SYSGEN reference manual.
Then apply DEC's distributed Update D patch procedure to recreate the
RSX11M baseline kit against which these modifications are performed.
If the Able Computer Technology ENABLE Memory Management Unit (and Cache)
is to be installed in your host system, apply the Able supplied patches
next.
Remember that any system built with the ENABLE hardware support cannot be moved
to a system without the same hardware.
This is a restriction of the Able patches, and not the changes discussed here.
Finally, apply the procedure described in this paper by invoking the
DECUSMODS.CMD command procedure.

This command procedure supports all three types of RSX11M distribution kit and
will ask the user to specify which kit is in use.
The procedure will then ask the user to re-build the indirect command
processor (ICP) to enlarge its symbol table if a very large system
configuration is being generated.
This step should be taken, and the new ICP installed if the SYSGEN being
performed will generate a system with a very large number of devices.

DECUSMODS should be re-invoked to apply the modifications described here.
A set of hexadecimal modifications can be installed by this procedure if the
user wishes.
These hex modifications are discussed in the companion paper "RSX11M
Hexadecimal Command Line Numerics" presented at this DECUS symposium.
The next set of changes that can be applied are the first part or I/O
symbol linkage changes discussed earlier.
These must be selected if the loadable driver data base changes are to be
applied.

Each set of changes will be applied in sequence as the user selected.
The procedures are designed to verify the modified files against expected
results, but due to DECUS restrictions about copyrighted source code
content on SIG tape submissions, not all the required files can be included.
This should pose no problems, so long as Update D of V4.1 is used as the
baseline for the procedure.
After the modifications are performed, the normal SYSGEN procedure is
initiated as described in the SYSGEN manual.

.ce 1
DIFFERENCES IN SYSGEN PROCEDURE

The following procedural changes should be observed when performing a
SYSGEN with these changes applied.

If the system is autoconfigured, and the autoconfigure results are not
overridden and amended, the resulting system will be restricted to
supporting only the devices found by the autoconfigure program.
This defeats a major purpose of using these changes, that is to generate
a single system capable of supporting many different hardware configurations.

If autoconfigure is suppressed or overridden, when SYSGEN asks for the number
of controllers of each device type in the system, the user should specify
the controllers that comprise the union of all controllers in all the systems
to be supported.
Thus if three systems are to be supported on three different systems disc
types, the controllers for each disc should be specified in the hardware
configuration section.
The number of each controller type to be generated should be specified as the
maximum across all the systems to be supported.
By following these two rules, SYSGEN will build all the device drivers
necessary to support all the systems and will generate data bases to
support the largest hardware configuration.
Smaller systems will indicate off-line status for those devices not
present at boot-time.

The same rules pertain to specifying the number of terminal controllers YL, YH,
YZ, etc during the system hardware configuration.
Later during the procedure, where each system's terminal driver is configured,
the procedure will permit the user to specify the actual number of each
controller type supported by a given system configuration.
This is where each TTDRV data base is reduced in size to support only the
specific terminal interfaces present in a system.

A word of caution applies here however.
If the maximum number of any specific terminal interface class (YL, YH,
YZ, etc) is greater than one, the minimum number that should be specified
during this tailoring phase is either 0 (none) or 2 controllers for that class.
This is particularly important for the YL class of single line controller.
If this rule is not followed, the driver will assemble for a multi-controller
system configuration, but the LOAd processor will create an Interrupt
Transfer Block (ITB) in POOL to support only a single controller.
If this should happen, the generated Executive will CRASH ON THE FIRST
KEYSTROKE after the virgin Executive is bootstrapped!

The SYSGEN procedure continues normally, configuring Executive, terminal
driver and other system features.
During the device configuration phase, where CSR and vector addresses are
specified for each device controller, when the terminal devices are being
configured, the modified procedure asks for the system identifier discussed
earlier.
The procedure then asks for the number of each type of terminal controller
in the system.
The procedure creates a terminals data base containing the currently
specified subset of controllers and asks if another driver data base is to be
built.
If another is to be built, a new identifier and controller set is requested
and the new data base is created.
This process is continued until no more data bases are requested.

During this section, if the first system identifier specified is the NULL
string, a standard single configuration system is built, including support
for loadable data base device drivers.
A non-null string causes a tailored terminals data base (TTTABxxx.MAC) to
be created for the system.

Phase I of SYSGEN continues normally, assembling the Executive, drivers and
individual driver data bases and preparing for Phase II task building.
Chaining to Phase II continues the SYSGEN procedure where the system
libraries, Executive and privileged tasks are built.
It is during this phase that the modified procedure asks the user to
re-specify the list of system identifiers used to designate the different
terminal driver configurations.
This list is used to create a virgin system boot file for each individual
system configuration.
In addition, the user is given the opportunity to specify a list of
device drivers to be installed in each system.
This list of drivers is used to tailor a SYSVMR file for each system
configuration.
At the end of this stage, the user is asked to specify the system identifier
for the system on which the SYSGEN is being performed.
The proper version of the terminal driver is selected for for inclusion
in the host's new system, and the system VMR process is executed to
configure the new operating system for the host machine.
When Phase II of SYSGEN ends, the new Executive is booted and saved with
the bootstrap block written in the usual manner.

When the system re-boots itself, SYSGEN Phase III can be performed to re-build
any needed utilities to use RESLIB, ANSLIB or other system features.
After completing Phase III, and purging the system disc, the system is ready
to be transported to another hardware configuration.

.ce 1
MOVING TO ANOTHER HARDWARE CONFIGURATION

To move the newly generated system to another hardware configuration, the
following minimum set of directories and files should be copied to a new
system disc device, ([1,1], [1,2], [1,54], [11,10]RSXMC.MAC).

Directory [1,1] contains the system object and macro libraries; [1,2]
contains the help files and standard startup procedure files; and [1,54]
contains the system privileged tasks and utilities.
RSXMC.MAC is included to provide definitions of the supported system features
so that privileged tasks needing this information can be assembled correctly.

The correct version of the terminal driver task image and symbol table
should be copied from TTDRVxxx.* to TTDRV.* and VMR executed using
SYSVMRxxx.CMD to configure the bootable Executive for the new system.
The new system image RSX11Mxxx.SYS sholud then be bootstrapped and saved with
bootblock to create a system disc that is bootable on the new configuration.

This new system has exactly the same Executive, resident libraries, privileged
tasks, and utilities as the original system.
Further, neither system has suffered a loss of dynamic storage or POOL space
due to un-necessary device data structures resident in the Executive.
Also, the terminal driver has been tailored to support the specific kind
and number of controllers on each hardware configuration.

.ce 1
ADDING A NEW DEVICE

Adding a new device to a system built with these changes is a relatively
easy job.
There are a number of different cases that need to be considered, but the
job can typically be accomplished without the need of another full system
generation.

If a device is to be added on an existing controller, the procedure is as
follows.
First, the data base source file xxTAB.MAC is edited, adding a new UCB
structure to the file.
The new UCB is added to the end of the existing UCB's in the file and is
linked to the DCB and SCB already present.
The highest unit number field of the DCB is incremented to enable the new
unit.

The revised file is re-assembled with RSXMC.MAC and EXEMC.MLB to produce
an object file for the new data base.
The driver task and symbol table are re-created by task-building the new
data base with the driver code object file.
The new driver is placed in service by simply LOAding it at system startup
if it was not installed by VMR.
Otherwise, a copy of the virgin Executive, RSX11M.TSK, must be reinitialized
with VMR and re-booted to install the new driver.

Installing new devices on a new controller is a similar procedure, except that
a new SCB together with the UCB(s) must be added to the data base.
Additional information on performing these steps can be found in the Guide
to Writing a Device Driver in the sections describing how the I/O data
structures are organized.

If a new type of device is to be added to the system and the system was
originally generated anticipating the device's inclusion in the configuration,
this task simply entails LOAding a driver that is already available.
If a pre-built driver is not available, the data structure for a similar type
device could be used as a model for the new device.
However, this approach is difficult to accomplish successfully except in the
simplest of cases for straight forward devices.
The approach breaks down if the device UCB is extended to include device
specific fields.
In this case, the driver should be built during the SYSGEN procedure.

.ce 1
CONCLUSIONS AND COMMENTS

The techniques discussed here and embodied in the files of the
modification kit permit multiple configuration systems to be generated
simultaneously, with fully loadable device drivers and data structures.
This permits a running system to be expanded easily and can eliminate
the need to do an additional SYSGEN to make simple system configuration
changes.

These techniques have been successfully used to generate systems supporting
PDP 11/34, PDP 11/24, and PDP 11/40 UNIBUS processors.
Systems with both 18 and 22 bit address support have been built from big disk,
RK06/RK07 and RL02 distribution kits.
The following cautions and caveats are applicable when considering using
these changes:

1. Controller CSR and vector addresses must be consistently set across all
systems.
SYSGEN'ing different types of controllers at the same address is acceptable
as long as their device drivers are not LOAded into the same system image
during VMR processing or system operation.

2. Support for multiple terminal driver configurations is provided for the
full-duplex terminal driver only.

3. The changes apply to Update D of RSX11M V4.1.
Proper application to other updates of V4.1 is not guaranteed.
Since Update D added DEUNA driver support to RSX, and changes are made in
building its data base, earlier Update kits are known to be incompatible
with the changes.

4. Laboratory devices (A/D and D/A converters) and the IC series devices have
not been addressed.
Since the systems at the author's site do not use these types of interfaces,
no changes have been designed for these devices during SYSGEN.

5. Any layered product that expects to find some I/O symbols defined in the
Executive symbol table will not link successfully.
This applies only to layered products that are built as privileged tasks as
they are the only ones with the potential to access these I/O structures
directly.

6. The compilers in use at the author's site have been built and used without
modification.
DECnet, however, has not yet been added to these systems, so it is not
known if the changes will effect the NETGEN procedure.
Inclusion of DECnet in these systems is planned for the near future.

7. While the changes made to the SYSGEN procedure do not depend upon
the processors being UNIBUS based, no Q-bus machine configurations have
been generated.
It is not known if these changes will properly support a Q-bus based
system.

8. Last, but not least, it must be remembered that systems generated using
this procedure are transportable only between multiple hardware
configurations that share the following characteristics:

.in +3
a. same or similar processors; if built for EIS support, all processors
must support EIS.

b. have memory management hardware; must be mapped systems to provide the
support necessary for loadable device drivers.

c. same memory address range; if built for 22 bit extended memory, all systems
must support 22 bit addressing.
.in -3

.ce 1
CAVEAT

The kit of files comprising the SYSGEN changes described here are supplied
for information purposes only.
Use of these changes at any PDP-11/RSX11M site is entirely at the risk of the
using organization.
Neither the author, nor Goodyear Aerospace Corporation, nor DECUS, nor the
RSX SIG is responsible if these changes do not perform successfully in any
particular system.
