10 CLS
20 KEY OFF
30 REM  PROGRAM EVALUATION AND REVIEW TECHNIQUE (PERT)
40 REM  A()=START AND END NODES FOR EACH ACTIVITY
50 REM  S()=EARLY START TIMES FOR EACH ACTIVITY
60 REM  F()=LATE FINISH TIMES FOR EACH ACTIVITY
70 REM  E()=EXPECTED DURATIONS AND VARIANCES OF ACTIVITIES
80 DIM A(99,2),S(99),F(99),E(99,2)
90 DEF FNR(Z1)=INT((Z1*1000+.5))/1000
100 PRINT "PROGRAM EVALUATION AND REVIEW TECHNIQUE"
110 PRINT
120 PRINT "ENTER THE NUMBER OF";
130 PRINT " ACTIVITIES IN THIS NETWORK";
140 INPUT N
150 FOR I=1 TO N
160 PRINT
170 PRINT USING "------- ACTIVITY ## -------"; I
180 PRINT "ENTER START NODE, END NODE";
190 INPUT A(I,1),A(I,2)
200 IF A(I,2)<=A(I,1) THEN 220
210 IF A(I,2)<N THEN 270
220 PRINT " START NODE MUST BE NUMBERED LOWER";
230 PRINT "  THEN END NODE, AND END NODE MUST"
240 PRINT " BE LESS THAN THE NUMBER OF ACTIVITIES.";
250 PRINT "     *** TRY ENTRY AGAIN ***"
260 GOTO 160
270 PRINT "ENTER THREE TIME ESTIMATES";
280 PRINT " FOR THIS ACTIVITY (A,M,B)";
290 INPUT A1,M,B
300 REM  E(I,1) IS THE EXPECTED DURATION
310 E(I,1)=FNR((A1+M*4+B)/6)
320 REM  E(I,2) IS THE ACTIVITY VARIANCE
330 E(I,2)=FNR((B-A1)/6)^2
340 S(I)=0
350 F(I)=0
360 NEXT I
370 REM  LOOP TO FIND EARLY START TIMES FOR NETWORK
380 FOR I=1 TO N
390 IF S(A(I,2))>=S(A(I,1))+E(I,1) THEN 410
400 S(A(I,2))=S(A(I,1))+E(I,1)
410 NEXT I
420 F(A(N,2))=S(A(N,2))
430 REM  LOOP TO CALCULATE LATE FINISH TIMES FOR NETWORK
440 FOR I=N TO 1 STEP -1
450 IF F(A(I,1))=0 THEN 480
460 IF F(A(I,1))>F(A(I,2))-E(I,1) THEN 480
470 GOTO 490
480 F(A(I,1))=F(A(I,2))-E(I,1)
490 NEXT I
500 V=0
510 C=0
520 L=0
530 FOR I=1 TO N
540 REM  CALCULATE SLACK TIME IN S1
550 S1=F(A(I,2))-S(A(I,1))-E(I,1)
560 S1=INT(S1*1000000!+.5)/1000000!
570 PRINT "--------------------------------------"
580 PRINT
590 PRINT USING "ACTIVITY ## (NODE ## TO NOD ##)"; I; A(I,1); A(I,2);
600 PRINT " IS A ";
610 IF S1<=0 THEN 630
620 PRINT "NON-";
630 PRINT "CRITICAL EVENT."
640 PRINT USING "    EXPECTED DURATION: ###.###          "; E(I,1);
650 PRINT USING "   STANDARD DEVIATION: ###.###"; SQR (E(I,2))
660 IF S1>0 THEN 740
670 PRINT USING "  START NO LATER THAN: ###.###"; S(A(I,1))
680 PRINT USING " MUST BE COMPLETED BY: ###.###"; F(A(I,2))
690 REM  ACCUMULATE PATH LENGTH IN L, VARIANCE IN V
700 IF L>=F(A(I,2)) THEN 720
710 L=F(A(I,2))
720 V=V+E(I,2)
730 GOTO 790
740 PRINT USING "          EARLY START: ###.###          "; S(A(I,1));
750 PRINT USING "           LATE START: ###.###"; F(A(I,2))-E(I,1)
760 PRINT USING "         EARLY FINISH: ###.###   "; S(A(I,1))+E(I,1);
770 PRINT USING "                 LATE FINISH: ###.###"; F(A(I,2))
780 PRINT USING "           SLACK TIME: ###.###"; S1
790 NEXT I
800 PRINT
810 PRINT "             THE CRITICAL PATH LENGTH IS  ";L;
820 P=SQR (V)
830 PRINT "PLUS OR MINUS";P
840 PRINT "ENTER DESIRED COMPLETION TIME (0 TO END) ";
850 INPUT D
860 IF D<=0 THEN 1010
870 REM  CALCULATE Z-SCORE FOR DESIRED DURATION
880 Y=(D-L)/P
890 REM  CALCULATE CUMULATIVE AREA UNDER NORMAL DISTRIBUTION
900 REM  REF: SOME COMMON BASIC PROGRAMS, 3RD ED. P.128
910 R=EXP(-(Y^2)/2)/2.5066282746#
920 Z=Y
930 Y=1/(1+.33267*ABS(Y))
940 T=1-R*(.4361836*Y-.1201676*Y^2+.937298*Y^3)
950 IF Z>=0 THEN 970
960 T=1-T
970 PRINT "PROBABILITY OF COMPLETION WITH DURATION OF";
980 PRINT D;"IS";T
990 PRINT
1000 GOTO 840
1010 END
