/*
BEGIN DOCUMENTATION

Name: TCMTAB.C					Created: 02/01/84
					    Last Update: 05/29/84
Title: Text collection management tab subroutines.

Index:

Abstract: Routines that set, clear, display and handle tab stops.

Usage:

Parameters:


Environment: DECUS C, RSX11M V4.0

See Also: TCMEDIT.C, TCMSCRN.C, TCM.DOC

Description: Tabs are handle by the following four routines:

		DSPTAB: Display tab stops on status line
	    	TABFUN: Advance to next tab stop
	    	SETTAB: Set tab stop at cursor column
	    	CLRTAB: Clear tab stop at cursor column


Example(s):

Uses:

Internal: A string is used to define which relative column tabs are set in
	     tab settings are marked by a 'T' and all other positions are
	     marked by a '-' character.

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"

/* #define debug 0 */

/***	Global variables used here only, defined in TCM.C   ***/

extern 	char	tabs[];
extern	int	tabcnt; 

/***	DSPTAB: Display tab stops on status line    ***/

dsptab()
{
    register char tempch;
    register charpointer tabend;

	tabdisp = false;		/* Only display until next keystroke */
	iff tabcnt != 0 then
	{
	    lin[vtlin].fircol = tempmsg;
	    tabend = &tabs[(rtmar-lfmar)+1];
	    tempch = *tabend;
	    *tabend = eos;		/* Mark end for this window */
	    scerln(vtlin,1);		/* Clear status line */
	    scout(vtlin,lfmar,tabs);
	    scout(curline,curcol,NULL);
	    *tabend = tempch;
	}
} /* end dsptab */



/***	TABFUN: Advance to next tab stop    ***/

charpointer
tabfun(chr)
    register charpointer chr;
{
    register int oldcol;

	oldcol = bufcol;
	while(bufcol < curwin->width)
	{
	    chr = csright(chr);		/* Move cursor right to tab stop */
	    iff tabs[bufcol-1] == 'T' then
		break;
	}
	iff bufcol >= curwin->width then
	{
	    bufcol = 1;			/* Move down to start of next line */
	    chr = csdown(chr);
	}
	iff ret.cd == TS_SUC then
	{
	    iff tabcnt > 0 then tabdisp = true;
	}
	else bufcol = oldcol;
	return(chr);
}



/***	SETTAB: Set tab stop at cursor column    ***/

charpointer
settab(chr)
    charpointer chr;
{
	tabdisp = true;			/* Display tabs until next keystroke */
	iff tabs[bufcol-1] != 'T' then
	    tabcnt++;
	tabs[bufcol-1] = 'T';
	return(chr);
} /* end settab */



/***	CLRTAB: Clear tab stop at cursor column    ***/

charpointer
clrtab(chr)
    charpointer chr;
{
	tabdisp = true;			/* Display tabs until next keystroke */
	iff (tabs[bufcol-1] == 'T') and (tabcnt > 0) then
	    tabcnt--;
	tabs[bufcol-1] = '-';
	return(chr);
} /* end clrtab */
