/*
BEGIN DOCUMENTATION

Name: TCMREWIN.C				Created: 07/20/83  DTS
					    Last Update: 04/10/84
Title: Text collection management window refresh subroutine.

Index:

Abstract: Implements "TWINRE" function of TCM system and refresh key (^W).

Usage:

Parameters:


Environment: DECUS C, RSX11M V4.0

See Also: TCM.C, TCMSCRN.C, TCM.DOC

Description: SREFRESH:	Uses window buffer returned by fndwnd() to do
			refresh window on screen.
	     REPAINT:	Refreshes all windows and returns pointer into
	    		current line.
	     INIOUT:	Initialize output to screen & data structures used to
			refresh screen.
Example(s):

Uses:

Internal:

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"



/***	(TWINRE) Refresh Window on screen    ***/

srefresh()
{
    register struct twindcb *win;

	ret.cd = TS_SUC;		/* Default to O.K. */
	iniout();			/* Clear output, new screen */
	iff srbuf.name[0] == ' ' then	/* Refresh all windows on screen */
	{
	    for (win = twinroot; win != NULL; win = win->twinptr)
		iff win != curwin then
		{
		    setout(win);
		    refresh();
		    rstout(win);
		}
	}
	else iff (win = fndwnd()) == NULL then
	    ret.cd = TE_NSW;
	else
	{
	    setout(win);
	    iff ret.cd == TS_SUC then
	    {
	    	refresh();
		rstout(win);
	    }
	}
} /* end srefresh */



/***	REPAINT: Refresh display on screen if errlvl < 3 else err    ***/

charpointer
repaint(chr)
    charpointer chr;   
{
	iff errlvl >= 3 then
	    tcmerr(TS_RFS);
	else
	{
	    savlin(curwin);	/* save current screen & editing state */
	    rstout(curwin);
/*
	    iniout();		not needed?
*/
	    srbuf.name[0] = ' ';
	    srefresh();		/* Refresh all windows on the screen */
	    setout(curwin);	/* Restore editing screen */
	    setscroll(top,bot);
	    chr = getlin(curwin->edline);
	}
	return(chr);
} /* end repaint */



/***	INIOUT: Initialize data structures for screen output, new screen    ***/


iniout()
{
    register	int		ln;

	for(ln = 0; ln <= vtlin; ln++)	/* Init screen array to NULLs */
	{
	    lin[ln].start = NULL;
	    lin[ln].fircol = newlin;
	    lin[ln].len = 0;
	}
	iff vttype == VT100 then
	{
	    cpystr(temp,VT100INIT);	/* Initialize terminal */
	    scout(vtlin,1,temp);
	}
}
