/*
BEGIN DOCUMENTATION

Name: Daniel T. Soldahl				Created: 7/20/83
					    Last Update:05/03/84

Title: TCMRETRV.C: Text collection management system text retrieval.

Index: TCM text editor

Abstract: Implements "TRETRV" function of TCM to send next line
	  from window to calling task.

Usage:	See "TCM.DOC"

Parameters:

Environment: RSX11M V4.0, DECUS C Compiler

See Also: TCM.C

Description: 

Example(s):  See "TCM.DOC"

Uses:

Internal: 

Update History:

END DOCUMENTATION
*/

#include <clang.c>
#include <stdio.h>
#include <cx.h>
#include "tcmdefs.h"
#include "tcmerr.h"
#include "tcmpublic.h"


/***	(TRETRV) Send next line from window to calling task    ***/

retrieve()
{
    register struct twindcb *win;
    register charpointer rline;
    register int c;

	ret.cd = TE_EOL;	/* Default to nothing more to send */
	count = 0;
	rline = &count;	/* Point somewhere */

	iff (win = fndwnd()) == NULL then
	    ret.cd = TE_NSW;
	else
	{
	    /* Set status to indicate there is more to send */
	    c = ifx (srbuf.row > 0) thenx srbuf.row elsex win->edlinnum;
	    iff win->botline >= c then
	    {
		ret.cd = TS_SUC;
		iff (win->edlinnum)++ != c then
		{
		    win->edline = fndlin(win->bufstart,win->bufend,c);	/* Set pointer if new line */
		    win->edlinnum = c;
		}
		rline = win->edline;
		count = strlen(rline);
		iff win->botline == c then
		    ret.cd = TS_LSL;		/* Last line */
		else				/* Point to next line */
		{
		    win->edline += strlen(win->edline) + 1;	/* Assumes contiguous buffer */
		    win->edlinnum++;
		}
	    }
	}
	iff vsend(&mastsk,rline,count) != IS_SUC then	/* always do send */
	    error("Send error dsw = %d.",$dsw);
} /* end retrieve */

